/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.patch;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.mojo.patch.AbstractPatchMojo;
import org.codehaus.mojo.patch.PatchContext;
import org.codehaus.mojo.tools.cli.CommandLineManager;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.codehaus.plexus.util.cli.shell.BourneShell;
import org.codehaus.plexus.util.cli.shell.Shell;

public class PackagePatchesMojo
extends AbstractPatchMojo {
    private String patchArtifactClassifier;
    private String patchArtifactType;
    private String tarLongFileMode;
    private String artifactId;
    private String version;
    private File patchArchiveDestDir;
    private File patchDirectory;
    private File patchArtifactUnpackDirectory;
    private ArchiverManager archiverManager;
    private CommandLineManager cliManager;
    private MavenProjectHelper projectHelper;

    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        PatchContext ctx = new PatchContext();
        if (ctx.isPatchArtifactResolved(this.patchArtifactUnpackDirectory)) {
            this.getLog().debug((CharSequence)"Skipping patch-package step, patch file resolved from previous release.");
            return;
        }
        File patchDir = ctx.getPatchDirectory(this.patchArtifactUnpackDirectory, this.patchDirectory);
        File patchArchive = new File(this.patchArchiveDestDir, this.artifactId + "-" + this.version + "-" + this.patchArtifactClassifier + "." + this.patchArtifactType);
        if (this.patchArtifactType.equals("tar") || this.patchArtifactType.equals("tar.gz") || this.patchArtifactType.equals("tgz") || this.patchArtifactType.equals("tar.bz2")) {
            this.tarPatchArtifact(patchDir, patchArchive);
        } else {
            this.archivePatchArtifact(patchDir, patchArchive);
        }
        this.projectHelper.attachArtifact(this.getProject(), this.patchArtifactType, this.patchArtifactClassifier, patchArchive);
    }

    private void archivePatchArtifact(File patchDir, File destFile) throws MojoExecutionException {
        Archiver archiver;
        try {
            archiver = this.archiverManager.getArchiver(this.patchArtifactType);
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("Cannot find archiver for artifact type: " + this.patchArtifactType, (Exception)((Object)e));
        }
        archiver.setDestFile(destFile);
        try {
            String[] excludes = new String[]{};
            if (this.useDefaultIgnores()) {
                excludes = DEFAULT_IGNORED_PATCH_PATTERNS.toArray(new String[DEFAULT_IGNORED_PATCH_PATTERNS.size()]);
            }
            archiver.addDirectory(patchDir, new String[]{"**"}, excludes);
            archiver.createArchive();
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Failed to archive patch-source directory.", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to archive patch-source directory.", (Exception)e);
        }
    }

    private void tarPatchArtifact(File patchDir, File destFile) throws MojoExecutionException {
        StringBuffer cmd = new StringBuffer();
        cmd.append("cd " + patchDir.getAbsolutePath() + " && tar -c");
        if (this.patchArtifactType.equals("tar.gz") || this.patchArtifactType.equals("tgz")) {
            cmd.append("z");
        } else if (this.patchArtifactType.equals("tar.bz2")) {
            cmd.append("j");
        } else if (!this.patchArtifactType.equals("tar")) {
            throw new MojoExecutionException("Unknown tarball type: " + this.patchArtifactType);
        }
        cmd.append("f " + destFile.getAbsolutePath());
        String[] excludes = new String[]{};
        if (this.useDefaultIgnores()) {
            excludes = DEFAULT_IGNORED_PATCHES.toArray(new String[DEFAULT_IGNORED_PATCHES.size()]);
        }
        for (String exclude : excludes) {
            cmd.append(" --exclude " + exclude);
        }
        cmd.append(" *");
        Commandline cli = new Commandline();
        BourneShell shell = new BourneShell(true);
        shell.setQuotedArgumentsEnabled(false);
        cli.setShell((Shell)shell);
        cli.createArg().setLine(cmd.toString());
        this.getLog().debug((CharSequence)("Executing: " + cmd.toString()));
        try {
            StreamConsumer consumer = this.cliManager.newInfoStreamConsumer();
            int result = this.cliManager.execute(cli, consumer, consumer);
            if (result != 0) {
                throw new MojoExecutionException(cmd.toString() + " returned an exit value != 0. Aborting build; see command output above for more information.");
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Failed to execute. Reason: " + e.getMessage(), (Exception)((Object)e));
        }
    }
}

