/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.openjpa;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:openjpa-maven-plugin:1.1", 0);
        this.append(sb, "", 0);
        this.append(sb, "OpenJPA Maven Plugin", 0);
        this.append(sb, "OpenJPA (http://openjpa.apache.org) tasks for enhancing, SQL creation and schema mapping creation", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 5 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "enhance".equals(this.goal)) {
            this.append(sb, "openjpa:enhance", 0);
            this.append(sb, "Processes Application model classes and enhances them by running Open JPA Enhancer tool. This basically only acts as a container for the xdoclet stuff since all the required functionality is already in the AbstratOpenJpaEnhancerMojo.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "addDefaultConstructor (Default: true)", 2);
                this.append(sb, "The JPA spec requires that all persistent classes define a no-arg constructor. This flag tells the enhancer whether to add a protected no-arg constructor to any persistent classes that don't already have one.", 3);
                this.append(sb, "", 0);
                this.append(sb, "classes (Default: ${project.build.outputDirectory})", 2);
                this.append(sb, "Location where persistence-enabled classes are located.", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionDriverName", 2);
                this.append(sb, "This setting can be used to override any openjpa.ConnectionDriverName set in the persistence.xml. It can also be used if the persistence.xml contains no connection information at all.\n\nSample:\n\n<connectionDriverName>com.mchange.v2.c3p0.ComboPooledDataSource</connectionDriverName>\nThis is most times used in conjunction with connectionProperties.", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionProperties", 2);
                this.append(sb, "Used to define the credentials or any other connection properties.\nSample:\n<connectionProperties>\n\u00a0\u00a0driverClass=com.mysql.jdbc.Driver,\n\u00a0\u00a0jdbcUrl=jdbc:mysql://localhost/mydatabase,\n\u00a0\u00a0user=root,\n\u00a0\u00a0password=,\n\u00a0\u00a0minPoolSize=5,\n\u00a0\u00a0acquireRetryAttempts=3,\n\u00a0\u00a0maxPoolSize=20\n</connectionProperties>\nThis is most times used in conjunction with connectionDriverName.", 3);
                this.append(sb, "", 0);
                this.append(sb, "enforcePropertyRestrictions (Default: false)", 2);
                this.append(sb, "Whether to throw an exception when it appears that a property access entity is not obeying the restrictions placed on property access.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Comma separated list of excludes to scan searchDir to pass to the jobs. This option may be used to stop OpenJPA tasks from scanning non-JPA classes (which usually leads to warnings such as 'Type xxx has no metadata')", 3);
                this.append(sb, "", 0);
                this.append(sb, "forceMojoExecution (Default: false)", 2);
                this.append(sb, "Setting this parameter to true will force the execution of this mojo, even if it would get skipped usually.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes (Default: **/*.class)", 2);
                this.append(sb, "Comma separated list of includes to scan searchDir to pass to the jobs. This may be used to restrict the OpenJPA tasks to e.g. a single package which contains all the entities.", 3);
                this.append(sb, "", 0);
                this.append(sb, "persistenceXmlFile", 2);
                this.append(sb, "Used if a non-default file location for the persistence.xml should be used If not specified, the default one in META-INF/persistence.xml will be used. Please note that this is not a resource location but a file path!", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "When true, skip the execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "tmpClassLoader (Default: false)", 2);
                this.append(sb, "Tell the PCEnhancer to use a temporary classloader for enhancement. If you enable this feature, then no depending artifacts from the classpath will be used! Please note that you have to disable the tmpClassLoader for some cases in OpenJPA-1.2.1 due to an extended parsing strategy.", 3);
                this.append(sb, "", 0);
                this.append(sb, "toolProperties", 2);
                this.append(sb, "Additional properties passed to the OpenJPA tools.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "openjpa:help", 0);
            this.append(sb, "Display help information on openjpa-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0openjpa:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "schema".equals(this.goal)) {
            this.append(sb, "openjpa:schema", 0);
            this.append(sb, "Executes the schema generation via the OpenJPA MappingTool.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "action", 2);
                this.append(sb, "Argument to specify the action to take on each class. The available actions are: buildSchema, validate", 3);
                this.append(sb, "", 0);
                this.append(sb, "classes (Default: ${project.build.outputDirectory})", 2);
                this.append(sb, "Location where persistence-enabled classes are located.", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionDriverName", 2);
                this.append(sb, "This setting can be used to override any openjpa.ConnectionDriverName set in the persistence.xml. It can also be used if the persistence.xml contains no connection information at all.\n\nSample:\n\n<connectionDriverName>com.mchange.v2.c3p0.ComboPooledDataSource</connectionDriverName>\nThis is most times used in conjunction with connectionProperties.", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionProperties", 2);
                this.append(sb, "Used to define the credentials or any other connection properties.\nSample:\n<connectionProperties>\n\u00a0\u00a0driverClass=com.mysql.jdbc.Driver,\n\u00a0\u00a0jdbcUrl=jdbc:mysql://localhost/mydatabase,\n\u00a0\u00a0user=root,\n\u00a0\u00a0password=,\n\u00a0\u00a0minPoolSize=5,\n\u00a0\u00a0acquireRetryAttempts=3,\n\u00a0\u00a0maxPoolSize=20\n</connectionProperties>\nThis is most times used in conjunction with connectionDriverName.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Comma separated list of excludes to scan searchDir to pass to the jobs. This option may be used to stop OpenJPA tasks from scanning non-JPA classes (which usually leads to warnings such as 'Type xxx has no metadata')", 3);
                this.append(sb, "", 0);
                this.append(sb, "forceMojoExecution (Default: false)", 2);
                this.append(sb, "Setting this parameter to true will force the execution of this mojo, even if it would get skipped usually.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes (Default: **/*.class)", 2);
                this.append(sb, "Comma separated list of includes to scan searchDir to pass to the jobs. This may be used to restrict the OpenJPA tasks to e.g. a single package which contains all the entities.", 3);
                this.append(sb, "", 0);
                this.append(sb, "persistenceXmlFile", 2);
                this.append(sb, "Used if a non-default file location for the persistence.xml should be used If not specified, the default one in META-INF/persistence.xml will be used. Please note that this is not a resource location but a file path!", 3);
                this.append(sb, "", 0);
                this.append(sb, "schemaAction (Default: add)", 2);
                this.append(sb, "The action to take on the schema. Actions can be composed in a comma-separated list of one of the following items:\n-\tadd (see MappingTool#ACTION_ADD)\n-\trefresh (see MappingTool#ACTION_REFRESH)\n-\tdrop (see MappingTool#ACTION_DROP)\n-\tbuildSchema (see MappingTool#ACTION_BUILD_SCHEMA)\n-\timport (see MappingTool#ACTION_IMPORT)\n-\texport (see MappingTool#ACTION_EXPORT)\n-\tvalidate (see MappingTool#ACTION_VALIDATE)\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "schemaFile (Default: ${project.build.directory}/schema.xml)", 2);
                this.append(sb, "Use this option to write the planned schema to an XML document rather than modify the database. The document can then be manipulated and committed to the database with the schema tool", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "When true, skip the execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "toolProperties", 2);
                this.append(sb, "Additional properties passed to the OpenJPA tools.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "sql".equals(this.goal)) {
            this.append(sb, "openjpa:sql", 0);
            this.append(sb, "Executes the SQL generation via the OpenJPA MappingTool.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "action", 2);
                this.append(sb, "Argument to specify the action to take on each class. The available actions are: buildSchema, validate", 3);
                this.append(sb, "", 0);
                this.append(sb, "classes (Default: ${project.build.outputDirectory})", 2);
                this.append(sb, "Location where persistence-enabled classes are located.", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionDriverName", 2);
                this.append(sb, "This setting can be used to override any openjpa.ConnectionDriverName set in the persistence.xml. It can also be used if the persistence.xml contains no connection information at all.\n\nSample:\n\n<connectionDriverName>com.mchange.v2.c3p0.ComboPooledDataSource</connectionDriverName>\nThis is most times used in conjunction with connectionProperties.", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionProperties", 2);
                this.append(sb, "Used to define the credentials or any other connection properties.\nSample:\n<connectionProperties>\n\u00a0\u00a0driverClass=com.mysql.jdbc.Driver,\n\u00a0\u00a0jdbcUrl=jdbc:mysql://localhost/mydatabase,\n\u00a0\u00a0user=root,\n\u00a0\u00a0password=,\n\u00a0\u00a0minPoolSize=5,\n\u00a0\u00a0acquireRetryAttempts=3,\n\u00a0\u00a0maxPoolSize=20\n</connectionProperties>\nThis is most times used in conjunction with connectionDriverName.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Comma separated list of excludes to scan searchDir to pass to the jobs. This option may be used to stop OpenJPA tasks from scanning non-JPA classes (which usually leads to warnings such as 'Type xxx has no metadata')", 3);
                this.append(sb, "", 0);
                this.append(sb, "forceMojoExecution (Default: false)", 2);
                this.append(sb, "Setting this parameter to true will force the execution of this mojo, even if it would get skipped usually.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes (Default: **/*.class)", 2);
                this.append(sb, "Comma separated list of includes to scan searchDir to pass to the jobs. This may be used to restrict the OpenJPA tasks to e.g. a single package which contains all the entities.", 3);
                this.append(sb, "", 0);
                this.append(sb, "persistenceXmlFile", 2);
                this.append(sb, "Used if a non-default file location for the persistence.xml should be used If not specified, the default one in META-INF/persistence.xml will be used. Please note that this is not a resource location but a file path!", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "When true, skip the execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sqlAction (Default: build)", 2);
                this.append(sb, "The action to take for generating the SQL. Actions can be composed in a comma-separated list of one of the following items:\n-\tadd (see MappingTool#ACTION_ADD)\n-\trefresh (see MappingTool#ACTION_REFRESH)\n-\tdrop (see MappingTool#ACTION_DROP)\n-\tbuildSchema (see MappingTool#ACTION_BUILD_SCHEMA)\n-\timport (see MappingTool#ACTION_IMPORT)\n-\texport (see MappingTool#ACTION_EXPORT)\n-\tvalidate (see MappingTool#ACTION_VALIDATE)\nTechnically this is the same like the schemaAction, but we have to split it for the plugin to allow different actions for generating the mapping and generating the SQL files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sqlFile (Default: ${project.build.directory}/database.sql)", 2);
                this.append(sb, "Use this option to write the planned schema modifications to a SQL script rather than modify the database. Combine this with a schemaAction of 'build' to generate a script that recreates the schema for the current mappings, even if the schema already exists.", 3);
                this.append(sb, "", 0);
                this.append(sb, "toolProperties", 2);
                this.append(sb, "Additional properties passed to the OpenJPA tools.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "test-enhance".equals(this.goal)) {
            this.append(sb, "openjpa:test-enhance", 0);
            this.append(sb, "Processes Application model classes and enhances them by running Open JPA Enhancer tool.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "addDefaultConstructor (Default: true)", 2);
                this.append(sb, "The JPA spec requires that all persistent classes define a no-arg constructor. This flag tells the enhancer whether to add a protected no-arg constructor to any persistent classes that don't already have one.", 3);
                this.append(sb, "", 0);
                this.append(sb, "classes (Default: ${project.build.outputDirectory})", 2);
                this.append(sb, "Location where persistence-enabled classes are located.", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionDriverName", 2);
                this.append(sb, "This setting can be used to override any openjpa.ConnectionDriverName set in the persistence.xml. It can also be used if the persistence.xml contains no connection information at all.\n\nSample:\n\n<connectionDriverName>com.mchange.v2.c3p0.ComboPooledDataSource</connectionDriverName>\nThis is most times used in conjunction with connectionProperties.", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionProperties", 2);
                this.append(sb, "Used to define the credentials or any other connection properties.\nSample:\n<connectionProperties>\n\u00a0\u00a0driverClass=com.mysql.jdbc.Driver,\n\u00a0\u00a0jdbcUrl=jdbc:mysql://localhost/mydatabase,\n\u00a0\u00a0user=root,\n\u00a0\u00a0password=,\n\u00a0\u00a0minPoolSize=5,\n\u00a0\u00a0acquireRetryAttempts=3,\n\u00a0\u00a0maxPoolSize=20\n</connectionProperties>\nThis is most times used in conjunction with connectionDriverName.", 3);
                this.append(sb, "", 0);
                this.append(sb, "enforcePropertyRestrictions (Default: false)", 2);
                this.append(sb, "Whether to throw an exception when it appears that a property access entity is not obeying the restrictions placed on property access.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Comma separated list of excludes to scan searchDir to pass to the jobs. This option may be used to stop OpenJPA tasks from scanning non-JPA classes (which usually leads to warnings such as 'Type xxx has no metadata')", 3);
                this.append(sb, "", 0);
                this.append(sb, "forceMojoExecution (Default: false)", 2);
                this.append(sb, "Setting this parameter to true will force the execution of this mojo, even if it would get skipped usually.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes (Default: **/*.class)", 2);
                this.append(sb, "Comma separated list of includes to scan searchDir to pass to the jobs. This may be used to restrict the OpenJPA tasks to e.g. a single package which contains all the entities.", 3);
                this.append(sb, "", 0);
                this.append(sb, "persistenceXmlFile", 2);
                this.append(sb, "Used if a non-default file location for the persistence.xml should be used If not specified, the default one in META-INF/persistence.xml will be used. Please note that this is not a resource location but a file path!", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "When true, skip the execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "tmpClassLoader (Default: false)", 2);
                this.append(sb, "Tell the PCEnhancer to use a temporary classloader for enhancement. If you enable this feature, then no depending artifacts from the classpath will be used! Please note that you have to disable the tmpClassLoader for some cases in OpenJPA-1.2.1 due to an extended parsing strategy.", 3);
                this.append(sb, "", 0);
                this.append(sb, "toolProperties", 2);
                this.append(sb, "Additional properties passed to the OpenJPA tools.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

