/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.nbm;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.nbm.AbstractNbmMojo;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;

public class BrandingMojo
extends AbstractNbmMojo {
    protected File nbmBuildDir;
    private File brandingSources;
    private String brandingToken;
    protected String cluster;
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        if (!"nbm".equals(this.project.getPackaging())) {
            this.getLog().error((CharSequence)"The nbm:branding goal shall be used within a NetBeans module project only (packaging 'nbm')");
        }
        if (!this.brandingSources.isDirectory()) {
            this.getLog().info((CharSequence)"No branding to process.");
            return;
        }
        if (this.brandingToken == null) {
            throw new MojoExecutionException("brandingToken must be defined for mojo:branding");
        }
        try {
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setIncludes(new String[]{"**/*.*"});
            scanner.addDefaultExcludes();
            scanner.setBasedir(this.brandingSources);
            scanner.scan();
            File clusterDir = new File(this.nbmBuildDir, "netbeans" + File.separator + this.cluster);
            clusterDir.mkdirs();
            for (String brandingFilePath : scanner.getIncludedFiles()) {
                File brandingFile = new File(this.brandingSources, brandingFilePath);
                String destinationFilePath = this.destinationFileName(brandingFilePath);
                File brandingDestination = new File(clusterDir, destinationFilePath);
                if (!brandingDestination.getParentFile().exists()) {
                    brandingDestination.getParentFile().mkdirs();
                }
                FileUtils.copyFile((File)brandingFile, (File)brandingDestination);
            }
            scanner.setIncludes(new String[]{"**/*.jar"});
            scanner.setBasedir(clusterDir);
            scanner.scan();
            for (String jarDirectoryPath : scanner.getIncludedDirectories()) {
                File jarDirectory = new File(clusterDir, jarDirectoryPath);
                File destinationJar = new File(jarDirectory.getParentFile().getAbsolutePath() + File.separator + "locale" + File.separator + this.destinationFileName(jarDirectory.getName()));
                JarArchiver archiver = new JarArchiver();
                archiver.setDestFile(destinationJar);
                archiver.addDirectory(jarDirectory);
                archiver.createArchive();
                FileUtils.deleteDirectory((File)jarDirectory);
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Error creating branding", ex);
        }
    }

    private String destinationFileName(String brandingFilePath) {
        int lastSeparator = brandingFilePath.indexOf(File.separator);
        int firstUnderscore = brandingFilePath.indexOf("_", lastSeparator);
        if (firstUnderscore != -1) {
            return brandingFilePath.substring(0, firstUnderscore) + "_" + this.brandingToken + "_" + brandingFilePath.substring(firstUnderscore + 1);
        }
        int lastDot = brandingFilePath.lastIndexOf(".");
        return brandingFilePath.substring(0, lastDot) + "_" + this.brandingToken + brandingFilePath.substring(lastDot);
    }
}

