/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.license.AbstractLicenseMojo;
import org.codehaus.mojo.license.header.transformer.FileHeaderTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="comment-style-list", requiresProject=false, requiresDirectInvocation=true)
public class CommentStyleListMojo
extends AbstractLicenseMojo {
    private static final Logger LOG = LoggerFactory.getLogger(CommentStyleListMojo.class);
    @Parameter(property="detail")
    private boolean detail;
    @Component(role=FileHeaderTransformer.class)
    private Map<String, FileHeaderTransformer> transformers;

    @Override
    public boolean isSkip() {
        return false;
    }

    @Override
    protected void init() throws Exception {
    }

    @Override
    public void doAction() throws MojoExecutionException, MojoFailureException {
        StringBuilder buffer = new StringBuilder();
        if (this.isVerbose()) {
            buffer.append("\n\n-------------------------------------------------------------------------------\n");
            buffer.append("                           license-maven-plugin\n");
            buffer.append("-------------------------------------------------------------------------------\n\n");
        }
        ArrayList<String> names = new ArrayList<String>(this.transformers.keySet());
        Collections.sort(names);
        int maxLength = 0;
        int maxDLength = 0;
        for (String name : names) {
            FileHeaderTransformer transformer;
            if (name.length() > maxLength) {
                maxLength = name.length();
            }
            if ((transformer = this.transformers.get(name)).getDescription().length() <= maxDLength) continue;
            maxDLength = transformer.getDescription().length();
        }
        String pattern = " * %1$-" + maxLength + "s : %2$-" + maxDLength + "s, extensions : %3$s\n";
        buffer.append("Available comment styles:\n\n");
        for (String transformerName : names) {
            FileHeaderTransformer transformer = this.transformers.get(transformerName);
            buffer.append(String.format(pattern, transformerName, transformer.getDescription(), Arrays.toString(transformer.getDefaultAcceptedExtensions())));
            if (!this.detail) continue;
            buffer.append("\n   example : \n");
            buffer.append(transformer.boxComment("header", true));
            buffer.append('\n');
        }
        LOG.info("{}", (Object)buffer);
    }
}

