/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.api;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.mojo.license.api.DependenciesTool;
import org.codehaus.mojo.license.api.MavenProjectDependenciesConfigurator;
import org.codehaus.mojo.license.api.ThirdPartyHelper;
import org.codehaus.mojo.license.api.ThirdPartyTool;
import org.codehaus.mojo.license.api.ThirdPartyToolException;
import org.codehaus.mojo.license.model.LicenseMap;
import org.codehaus.mojo.license.utils.SortedProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultThirdPartyHelper
implements ThirdPartyHelper {
    private final DependenciesTool dependenciesTool;
    private final ThirdPartyTool thirdPartyTool;
    private final ArtifactRepository localRepository;
    private final List<ArtifactRepository> remoteRepositories;
    private final MavenProject project;
    private final String encoding;
    private final boolean verbose;
    private final Log log;
    private static SortedMap<String, MavenProject> artifactCache;

    public DefaultThirdPartyHelper(MavenProject project, String encoding, boolean verbose, DependenciesTool dependenciesTool, ThirdPartyTool thirdPartyTool, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, Log log) {
        this.project = project;
        this.encoding = encoding;
        this.verbose = verbose;
        this.dependenciesTool = dependenciesTool;
        this.thirdPartyTool = thirdPartyTool;
        this.localRepository = localRepository;
        this.remoteRepositories = remoteRepositories;
        this.log = log;
    }

    @Override
    public SortedMap<String, MavenProject> getArtifactCache() {
        if (artifactCache == null) {
            artifactCache = new TreeMap<String, MavenProject>();
        }
        return artifactCache;
    }

    @Override
    public SortedMap<String, MavenProject> loadDependencies(MavenProjectDependenciesConfigurator configuration) {
        return this.dependenciesTool.loadProjectDependencies(this.project, configuration, this.localRepository, this.remoteRepositories, this.getArtifactCache());
    }

    @Override
    public SortedProperties loadThirdPartyDescriptorForUnsafeMapping(SortedSet<MavenProject> unsafeDependencies, Collection<MavenProject> projects, LicenseMap licenseMap) throws ThirdPartyToolException, IOException {
        return this.thirdPartyTool.loadThirdPartyDescriptorsForUnsafeMapping(this.encoding, projects, unsafeDependencies, licenseMap, this.localRepository, this.remoteRepositories);
    }

    @Override
    public SortedProperties loadUnsafeMapping(LicenseMap licenseMap, File missingFile) throws IOException {
        return this.thirdPartyTool.loadUnsafeMapping(licenseMap, this.getArtifactCache(), this.encoding, missingFile);
    }

    @Override
    public LicenseMap createLicenseMap(SortedMap<String, MavenProject> dependencies) {
        LicenseMap licenseMap = new LicenseMap();
        for (MavenProject project : dependencies.values()) {
            this.thirdPartyTool.addLicense(licenseMap, project, project.getLicenses());
        }
        return licenseMap;
    }

    @Override
    public void attachThirdPartyDescriptor(File file) {
        this.thirdPartyTool.attachThirdPartyDescriptor(this.project, file);
    }

    @Override
    public SortedSet<MavenProject> getProjectsWithNoLicense(LicenseMap licenseMap) {
        return this.thirdPartyTool.getProjectsWithNoLicense(licenseMap, this.verbose);
    }

    @Override
    public SortedProperties createUnsafeMapping(LicenseMap licenseMap, File missingFile, boolean useRepositoryMissingFiles, SortedSet<MavenProject> unsafeDependencies, Collection<MavenProject> projectDependencies) throws ProjectBuildingException, IOException, ThirdPartyToolException {
        SortedProperties unsafeMappings = this.loadUnsafeMapping(licenseMap, missingFile);
        if (CollectionUtils.isNotEmpty(unsafeDependencies) && useRepositoryMissingFiles) {
            ArrayList<MavenProject> projects = new ArrayList<MavenProject>(projectDependencies);
            projects.remove(this.project);
            projects.removeAll(unsafeDependencies);
            SortedProperties resolvedUnsafeMapping = this.loadThirdPartyDescriptorForUnsafeMapping(unsafeDependencies, projects, licenseMap);
            unsafeMappings.putAll((Map<?, ?>)resolvedUnsafeMapping);
        }
        return unsafeMappings;
    }

    @Override
    public void mergeLicenses(List<String> licenseMerges, LicenseMap licenseMap) throws MojoFailureException {
        if (!CollectionUtils.isEmpty(licenseMerges)) {
            HashMap<String, String[]> mergedLicenses = new HashMap<String, String[]>();
            for (String merge : licenseMerges) {
                String[] split = (merge = merge.trim()).split("\\|");
                String mainLicense = split[0];
                if (mergedLicenses.containsKey(mainLicense)) {
                    throw new MojoFailureException("The merge main license " + mainLicense + " was already registred in the " + "configuration, please use only one such entry as describe in example " + "http://mojo.codehaus.org/license-maven-plugin/examples/example-thirdparty.html#Merge_licenses.");
                }
                mergedLicenses.put(mainLicense, split);
            }
            for (Object[] mergedLicense : mergedLicenses.values()) {
                if (this.verbose) {
                    this.log.info((CharSequence)("Will merge " + Arrays.toString(mergedLicense) + ""));
                }
                this.thirdPartyTool.mergeLicenses(licenseMap, (String[])mergedLicense);
            }
        }
    }
}

