/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.l10n;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:l10n-maven-plugin:1.0-alpha-2", 0);
        this.append(sb, "", 0);
        this.append(sb, "Localization Tools Maven Plugin 1.0-alpha-2", 0);
        this.append(sb, "Allows you to do an automated pseudo-localization to test the completeness of your project's internationalization effort. This technique simulates the process of localizing products by prefixing and suffixing all your internationalized messages. For more information on pseudo-localization, see http://developers.sun.com/solaris/articles/i18n/I18N_Testing.html. For more general information on localization, see http://java.sun.com/developer/technicalArticles/Intl/ResourceBundles/.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 3 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "l10n:help", 0);
            this.append(sb, "Display help information on l10n-maven-plugin. Call\n\u00a0\u00a0mvn\u00a0l10n:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "pseudo".equals(this.goal)) {
            this.append(sb, "l10n:pseudo", 0);
            this.append(sb, "Allows you to do an automated pseudo-localization to test the completeness of your project's internationalization effort. This technique simulates the process of localizing products by prefixing and suffixing all your internationalized messages.\n>For more information on pseudo-localization, see I18N Testing Guidelines and Techniques.\n\n>For more general information on localization, see Java Internationalization: Localization with ResourceBundles.\n", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "The list of resources we don't want to pseudo-localize. By default, no files are excluded.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "The list of resources we want to pseudo-localize. If not specified, the default pattern is **/*.properties.", 3);
                this.append(sb, "", 0);
                this.append(sb, "inputDirectory (Default: ${project.build.outputDirectory})", 2);
                this.append(sb, "The input directory from which we copy the resources. The plugin scans the build output directory by default, in order to have the complete set of resources that end up in the product.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.outputDirectory})", 2);
                this.append(sb, "The output directory into which to copy the resources.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pseudoLocPattern (Default: XXX \u00e5\u00a4\u0161\u00e5\u00b0\u2018 {0} YYY)", 2);
                this.append(sb, "Pattern for replacement of localized string values. The plugin iterates over all properties in the property files and replaces the values using MessageFormat with this value as a formatting pattern. The pattern is expected to contain this sequence {0} exactly once with a prefix and/or suffix.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pseudoLocale (Default: xx)", 2);
                this.append(sb, "Locale name that is used for pseudo-localization. The resulting property files will have the following name: <filename>_<pseudoLocale>.properties.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "report".equals(this.goal)) {
            this.append(sb, "l10n:report", 0);
            this.append(sb, "A simple report for keeping track of l10n status. It lists all bundle properties files and the number of properties in them. For a configurable list of locales it also tracks the progress of localization.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "aggregate (Default: false)", 2);
                this.append(sb, "Whether to build an aggregated report at the root, or build individual reports.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "A list of exclude patterns to use. By default no files are excluded.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "A list of include patterns to use. By default all *.properties files are included.", 3);
                this.append(sb, "", 0);
                this.append(sb, "locales", 2);
                this.append(sb, "A list of locale strings that are to be watched for l10n status.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory}/generated-site/xdoc)", 2);
                this.append(sb, "Report output directory.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = this.toLines(description, indent).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private List toLines(String text, int indent) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            this.toLines(lines, ind + plainLines[i]);
        }
        return lines;
    }

    private void toLines(List lines, String line) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= this.lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * this.indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", this.indentSize - buf.length() % this.indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

