/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.keytool;

import java.io.File;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.utils.cli.Commandline;
import org.apache.maven.shared.utils.cli.javatool.JavaToolException;
import org.apache.maven.shared.utils.cli.javatool.JavaToolResult;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.mojo.keytool.AbstractKeyToolMojo;
import org.codehaus.mojo.keytool.KeyTool;
import org.codehaus.mojo.keytool.KeyToolRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractKeyToolRequestMojo<R extends KeyToolRequest>
extends AbstractKeyToolMojo {
    @Parameter
    private String[] arguments;
    @Parameter(defaultValue="${basedir}", required=true, alias="workingdir")
    private File workingDirectory;
    @Component(role=KeyTool.class)
    private KeyTool keyTool;
    @Component
    private ToolchainManager toolchainManager;
    @Component
    private MavenSession session;
    private final Class<R> requestType;

    protected AbstractKeyToolRequestMojo(Class<R> requestType) {
        this.requestType = requestType;
    }

    public void execute() throws MojoExecutionException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)this.getMessage("disabled"));
        } else {
            Toolchain toolchain = this.getToolchain();
            if (toolchain != null) {
                this.keyTool.setToolchain(toolchain);
            }
            R request = this.createKeytoolRequest();
            try {
                JavaToolResult result = this.keyTool.execute(request);
                this.consumeResult(result);
            }
            catch (JavaToolException e) {
                throw new MojoExecutionException(this.getMessage("commandLineException", e.getMessage()), (Exception)((Object)e));
            }
        }
    }

    protected R createKeytoolRequest() {
        KeyToolRequest request;
        try {
            request = (KeyToolRequest)this.requestType.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create keytool request ", e);
        }
        request.setVerbose(this.isVerbose());
        request.setWorkingDirectory(this.workingDirectory);
        request.setArguments(this.arguments);
        return (R)request;
    }

    protected String getCommandlineInfo(Commandline commandLine) {
        if (commandLine == null) {
            throw new NullPointerException("commandLine");
        }
        return commandLine.toString();
    }

    protected final void consumeResult(JavaToolResult result) throws MojoExecutionException {
        Commandline commandLine = result.getCommandline();
        int resultCode = result.getExitCode();
        if (resultCode != 0) {
            throw new MojoExecutionException(this.getMessage("failure", this.getCommandlineInfo(commandLine), resultCode));
        }
    }

    private Toolchain getToolchain() {
        Toolchain tc = null;
        if (this.toolchainManager != null) {
            tc = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
        }
        return tc;
    }
}

