/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.keytool;

import java.io.File;
import org.codehaus.mojo.keytool.KeyToolCommandLineBuilder;
import org.codehaus.mojo.keytool.KeyToolRequest;
import org.codehaus.mojo.keytool.KeyToolRequestWithKeyStoreAndAliasParameters;
import org.codehaus.mojo.keytool.KeyToolRequestWithKeyStoreParameters;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.Commandline;

public abstract class AbstractKeyToolCommandLineBuilder
implements KeyToolCommandLineBuilder {
    private Logger logger;
    private String keyToolFile;

    public final void setLogger(Logger logger) {
        this.logger = logger;
    }

    public final void setKeyToolFile(String keyToolFile) {
        this.keyToolFile = keyToolFile;
    }

    public final void checkRequiredState() {
        if (this.logger == null) {
            throw new IllegalStateException("A logger instance is required.");
        }
        if (this.keyToolFile == null) {
            throw new IllegalStateException("A keyTool file is required.");
        }
    }

    protected final Logger getLogger() {
        return this.logger;
    }

    protected final String getKeyToolFile() {
        return this.keyToolFile;
    }

    protected final void addKeytoolCommandAndDefaultoptions(Commandline cli, String keytoolcommand, KeyToolRequest request) {
        this.addArg(cli, keytoolcommand);
        this.addArgIfTrue(cli, "-v", request.isVerbose());
        if (request instanceof KeyToolRequestWithKeyStoreParameters) {
            this.buildWithKeyStoreParameters((KeyToolRequestWithKeyStoreParameters)request, cli);
        }
        if (request instanceof KeyToolRequestWithKeyStoreAndAliasParameters) {
            this.buildWithKeyStoreAndAliasParameters((KeyToolRequestWithKeyStoreAndAliasParameters)request, cli);
        }
    }

    protected void buildWithKeyStoreParameters(KeyToolRequestWithKeyStoreParameters request, Commandline cli) {
        this.addArgIfNotEmpty(cli, "-keystore", request.getKeystore());
        this.addArgIfNotEmpty(cli, "-storepass", request.getStorepass());
        this.addArgIfNotEmpty(cli, "-storetype", request.getStoretype());
        this.addArgIfNotEmpty(cli, "-providername", request.getProvidername());
        this.addArgIfNotEmpty(cli, "-providerclass", request.getProviderclass());
        this.addArgIfNotEmpty(cli, "-providerarg", request.getProviderarg());
        this.addArgIfNotEmpty(cli, "-providerpath", request.getProviderpath());
    }

    protected void buildWithKeyStoreAndAliasParameters(KeyToolRequestWithKeyStoreAndAliasParameters request, Commandline cli) {
        this.addArgIfNotEmpty(cli, "-protected", request.isPasswordProtected() ? Boolean.TRUE.toString() : "");
        this.addArgIfNotEmpty(cli, "-alias", request.getAlias());
    }

    protected final void addArgIfNotEmpty(Commandline cli, String key, String value) {
        if (!StringUtils.isEmpty((String)value)) {
            this.addArg(cli, key);
            this.addArg(cli, value);
        }
    }

    protected final void addArgIfNotEmpty(Commandline cli, String key, File value) {
        if (value != null) {
            this.addArg(cli, key);
            this.addArg(cli, value);
        }
    }

    protected final void addArgIfTrue(Commandline cli, String key, boolean value) {
        if (value) {
            this.addArg(cli, key);
        }
    }

    protected final void addArg(Commandline cli, String value) {
        cli.createArg().setValue(value);
    }

    protected final void addArg(Commandline cli, File value) {
        cli.createArg().setFile(value);
    }
}

