/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jboss;

import java.io.File;
import java.io.IOException;
import java.rmi.RMISecurityManager;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.jboss.JBossServerUtil;
import org.codehaus.mojo.jboss.StartAndWaitMojo;

public class WaitAppStartMojo
extends StartAndWaitMojo {
    protected String earName;
    private static String command = null;

    public void execute() throws MojoExecutionException {
        try {
            File policyFile = File.createTempFile("jboss-client", ".policy");
            policyFile.deleteOnExit();
            JBossServerUtil.writeSecurityPolicy(policyFile);
            policyFile = policyFile.getCanonicalFile();
            System.setProperty("java.security.policy", policyFile.toURI().toString());
            System.setSecurityManager(new RMISecurityManager());
        }
        catch (IOException e) {
            this.getLog().info((CharSequence)("Unable to create security policy file for loading remote classes: " + e.getMessage()), (Throwable)e);
            this.getLog().info((CharSequence)"Will try to load required classes from local classpath.");
        }
        catch (SecurityException e) {
            this.getLog().info((CharSequence)("Unable to set security manager for loading remote classes: " + e.getMessage()), (Throwable)e);
            this.getLog().info((CharSequence)"Will try to load required classes from local classpath.");
        }
        InitialContext ctx = this.getInitialContext();
        MBeanServerConnection server = null;
        NamingException ne = null;
        for (int i = 0; i < this.retry; ++i) {
            try {
                Thread.sleep(this.retryWait);
                server = (MBeanServerConnection)ctx.lookup("jmx/invoker/RMIAdaptor");
                break;
            }
            catch (NamingException e) {
                ne = e;
                this.getLog().info((CharSequence)"Waiting to retrieve JBoss JMX MBean connection... ");
                continue;
            }
            catch (InterruptedException e) {
                this.getLog().warn((CharSequence)("Thread interrupted while waiting for MBean connection: " + e.getMessage()));
                e.printStackTrace();
            }
        }
        if (server == null) {
            throw new MojoExecutionException("Unable to get JBoss JMX MBean connection: " + ne.getMessage(), (Exception)ne);
        }
        this.getLog().info((CharSequence)"JBoss JMX MBean connection successful!");
        boolean started = false;
        for (int i = 0; i < this.retry; ++i) {
            this.getLog().info((CharSequence)("Trying " + (i + 1) + " of " + this.retry));
            try {
                started = this.isAppStarted(server);
                if (started) break;
                this.getLog().info((CharSequence)"App not started yet");
                Thread.sleep(this.retryWait);
                continue;
            }
            catch (Exception e) {
                this.getLog().error((Throwable)e);
                throw new MojoExecutionException("Unable to wait: " + e.getMessage(), e);
            }
        }
        if (!started) {
            throw new MojoExecutionException("App is not stared before timeout has expired! ");
        }
        this.getLog().info((CharSequence)"App started!");
    }

    protected boolean isAppStarted(MBeanServerConnection server) throws Exception {
        ObjectName serverMBeanName = new ObjectName(this.getAttribute());
        try {
            this.getLog().info((CharSequence)("Checking if " + this.earName + " is already started..."));
            return server.getAttribute(serverMBeanName, "StateString").equals("Started");
        }
        catch (InstanceNotFoundException infe) {
            return false;
        }
    }

    private String getAttribute() {
        if (command == null) {
            StringBuilder commandSB = new StringBuilder("jboss.j2ee:service=EARDeployment,url='");
            commandSB.append(this.earName);
            commandSB.append("'");
            command = commandSB.toString();
        }
        return command;
    }
}

