/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.fitnesse;

import org.apache.maven.plugin.MojoExecutionException;

public class Fitnesse {
    public static final int DEFAULT_FITNESSE_PORT = 80;
    private static final int MIN_PORT = 0;
    private static final int MAX_PORT = 65535;
    static final String PAGE_TYPE_SUITE = "suite";
    static final String PAGE_TYPE_TEST = "test";
    private String hostName = "localhost";
    private String type;
    private int port = 80;
    private String pageName = "MustBeDefinedByProject";
    private String serverId;

    public Fitnesse(String pHostName, int pPort, String pPageName) {
        this.hostName = pHostName;
        this.port = pPort;
        this.pageName = pPageName;
    }

    public Fitnesse() {
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getPageName() {
        return this.pageName;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        return "Fitnesse address=http://" + this.hostName + ":" + this.port + "/" + this.pageName;
    }

    void setPageName(String pPageName) {
        this.pageName = pPageName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getType() throws MojoExecutionException {
        String tShortPageName = this.pageName.indexOf(".") == -1 ? this.pageName : this.pageName.substring(this.pageName.indexOf(".") + 1);
        String string = this.type = this.type == null ? null : this.type.toLowerCase();
        if (this.type == null || this.type.length() == 0) {
            if (tShortPageName.startsWith("Suite")) {
                return PAGE_TYPE_SUITE;
            }
            if (!tShortPageName.startsWith("Test")) throw new MojoExecutionException("Parameter 'type' is mandatory is the page name doesn't begin with 'Test' or 'Suite' according to FitNesse convention. FitNesse server is: " + this.toString());
            return PAGE_TYPE_TEST;
        }
        if (PAGE_TYPE_SUITE.equals(this.type)) return this.type;
        if (PAGE_TYPE_TEST.equals(this.type)) return this.type;
        throw new MojoExecutionException("Invalid type [" + this.type + "] for the server [" + this.toString() + "], should be either [suite] or [test].");
    }

    public void setHostName(String pHostName) {
        this.hostName = pHostName;
    }

    public void setPort(int pPort) {
        this.port = pPort;
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String pServerId) {
        this.serverId = pServerId;
    }

    public void checkConfiguration() throws MojoExecutionException {
        if (this.hostName == null || this.hostName.length() == 0) {
            throw new MojoExecutionException("Fitnesse host is mandatory.");
        }
        if (this.port <= 0 || this.port > 65535) {
            throw new MojoExecutionException("The port should be a valid IP port [" + this.port + "].");
        }
        if (this.pageName == null || this.pageName.length() == 0) {
            throw new MojoExecutionException("Fitnesse page name is mandatory.");
        }
    }

    public void setType(String pType) {
        this.type = pType;
    }
}

