/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.emma;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.emma.AbstractEmmaMojo;
import org.codehaus.plexus.util.FileUtils;

public class EmmaCleanMojo
extends AbstractEmmaMojo {
    protected File metadataFile;
    protected File[] dataFiles;

    protected void checkParameters() throws MojoExecutionException, MojoFailureException {
        super.checkParameters();
        if (this.dataFiles == null) {
            this.dataFiles = new File[]{new File(this.project.getBasedir(), "coverage.ec")};
        }
    }

    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        if (this.metadataFile.exists()) {
            this.getLog().info((CharSequence)("Deleting file " + this.metadataFile.getAbsolutePath()));
            this.metadataFile.delete();
        }
        for (int i = 0; i < this.dataFiles.length; ++i) {
            File dataFile = this.dataFiles[i];
            if (!dataFile.exists()) continue;
            this.getLog().info((CharSequence)("Deleting file " + dataFile.getAbsolutePath()));
            dataFile.delete();
        }
        if (this.outputDirectory.exists()) {
            this.getLog().info((CharSequence)("Deleting directory " + this.outputDirectory.getAbsolutePath()));
            try {
                FileUtils.deleteDirectory((File)this.outputDirectory);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to delete EMMA generated resources", (Exception)e);
            }
        }
    }
}

