/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.dashboard.report.plugin.chart.time;

import java.awt.Paint;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.codehaus.mojo.dashboard.report.plugin.beans.SurefireReportBean;
import org.codehaus.mojo.dashboard.report.plugin.chart.time.AbstractTimeChartStrategy;
import org.jfree.chart.ChartColor;
import org.jfree.data.time.TimeSeries;

public class SurefireTimeChartStrategy
extends AbstractTimeChartStrategy {
    public SurefireTimeChartStrategy(ResourceBundle bundle, String title, List results, String timeUnit, Date startDate, Date endDate) {
        super(bundle, title, results, timeUnit, startDate, endDate);
    }

    public void fillDataset() {
        TimeSeries s1 = new TimeSeries(this.bundle.getString("report.surefire.label.tests"), this.periodClass);
        TimeSeries s2 = new TimeSeries(this.bundle.getString("report.surefire.label.errors"), this.periodClass);
        TimeSeries s3 = new TimeSeries(this.bundle.getString("report.surefire.label.failures"), this.periodClass);
        TimeSeries s4 = new TimeSeries(this.bundle.getString("report.surefire.label.skipped"), this.periodClass);
        Iterator iter = this.mResults.iterator();
        while (iter.hasNext()) {
            SurefireReportBean surefire = (SurefireReportBean)iter.next();
            Date date = surefire.getDateGeneration();
            s1.addOrUpdate(this.getChartDate(this.timePeriod.normalize(date)), (double)surefire.getNbTests());
            s2.addOrUpdate(this.getChartDate(this.timePeriod.normalize(date)), (double)surefire.getNbErrors());
            s3.addOrUpdate(this.getChartDate(this.timePeriod.normalize(date)), (double)surefire.getNbFailures());
            s4.addOrUpdate(this.getChartDate(this.timePeriod.normalize(date)), (double)surefire.getNbSkipped());
        }
        this.defaultdataset.addSeries(s1);
        this.defaultdataset.addSeries(s2);
        this.defaultdataset.addSeries(s3);
        this.defaultdataset.addSeries(s4);
    }

    public Paint[] getPaintColor() {
        return new Paint[]{ChartColor.GREEN, ChartColor.RED, ChartColor.ORANGE, ChartColor.YELLOW};
    }
}

