/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.xsd;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.codehaus.modello.ModelloException;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.ModelAssociation;
import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.ModelField;
import org.codehaus.modello.plugin.AbstractModelloGenerator;
import org.codehaus.modello.plugin.model.ModelClassMetadata;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

public class XsdGenerator
extends AbstractModelloGenerator {
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Properties;

    public void generate(Model model, Properties parameters) throws ModelloException {
        this.initialize(model, parameters);
        try {
            this.generateXsd();
        }
        catch (IOException ex) {
            throw new ModelloException("Exception while generating xsd.", (Throwable)ex);
        }
    }

    private void generateXsd() throws IOException {
        File f;
        Model objectModel = this.getModel();
        String directory = this.getOutputDirectory().getAbsolutePath();
        if (this.isPackageWithVersion()) {
            directory = directory + "/" + this.getGeneratedVersion();
        }
        if (!(f = new File(directory, objectModel.getId() + "-" + this.getGeneratedVersion() + ".xsd")).getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        FileWriter writer = new FileWriter(f);
        PrettyPrintXMLWriter w = new PrettyPrintXMLWriter((Writer)writer);
        writer.write("<?xml version=\"1.0\"?>\n");
        w.startElement("xs:schema");
        w.addAttribute("xmlns:xs", "http://www.w3.org/2001/XMLSchema");
        w.addAttribute("elementFormDefault", "qualified");
        w.addAttribute("targetNamespace", "http://maven.apache.org/POM/4.0.0");
        w.addAttribute("xmlns", "http://maven.apache.org/POM/4.0.0");
        ModelClass root = objectModel.getClass(objectModel.getRoot(this.getGeneratedVersion()), this.getGeneratedVersion());
        w.startElement("xs:element");
        String tagName = XsdGenerator.getTagName(root);
        w.addAttribute("name", tagName);
        w.addAttribute("type", root.getName());
        XsdGenerator.writeClassDocumentation((XMLWriter)w, root);
        w.endElement();
        int initialCapacity = objectModel.getClasses(this.getGeneratedVersion()).size();
        this.writeComplexTypeDescriptor((XMLWriter)w, objectModel, root, new HashSet(initialCapacity));
        w.endElement();
        writer.flush();
        writer.close();
    }

    private static void writeClassDocumentation(XMLWriter w, ModelClass modelClass) {
        XsdGenerator.writeDocumentation(w, modelClass.getVersionRange().toString(), modelClass.getDescription());
    }

    private static void writeFieldDocumentation(XMLWriter w, ModelField field) {
        XsdGenerator.writeDocumentation(w, field.getVersionRange().toString(), field.getDescription());
    }

    private static void writeDocumentation(XMLWriter w, String version, String description) {
        if (version != null || description != null) {
            w.startElement("xs:annotation");
            if (version != null) {
                w.startElement("xs:documentation");
                w.addAttribute("source", "version");
                w.writeText(version);
                w.endElement();
            }
            if (description != null) {
                w.startElement("xs:documentation");
                w.addAttribute("source", "description");
                w.writeText(description);
                w.endElement();
            }
            w.endElement();
        }
    }

    private void writeComplexTypeDescriptor(XMLWriter w, Model objectModel, ModelClass modelClass, Set written) {
        written.add(modelClass);
        w.startElement("xs:complexType");
        w.addAttribute("name", modelClass.getName());
        XsdGenerator.writeClassDocumentation(w, modelClass);
        w.startElement("xs:all");
        ArrayList fields = new ArrayList();
        while (modelClass != null) {
            fields.addAll(modelClass.getFields(this.getGeneratedVersion()));
            String superClass = modelClass.getSuperClass();
            if (superClass != null) {
                modelClass = objectModel.getClass(superClass, this.getGeneratedVersion());
                continue;
            }
            modelClass = null;
        }
        HashSet<ModelClass> toWrite = new HashSet<ModelClass>();
        Iterator j = fields.iterator();
        while (j.hasNext()) {
            ModelField field = (ModelField)j.next();
            w.startElement("xs:element");
            w.addAttribute("name", field.getName());
            w.addAttribute("minOccurs", "0");
            String xsdType = XsdGenerator.getXsdType(field.getType());
            if (xsdType != null) {
                w.addAttribute("type", xsdType);
                if (field.getDefaultValue() != null) {
                    w.addAttribute("default", field.getDefaultValue());
                }
                XsdGenerator.writeFieldDocumentation(w, field);
            } else if (field instanceof ModelAssociation && this.isClassInModel(((ModelAssociation)field).getTo(), objectModel)) {
                ModelAssociation association = (ModelAssociation)field;
                ModelClass fieldModelClass = objectModel.getClass(association.getTo(), this.getGeneratedVersion());
                toWrite.add(fieldModelClass);
                if ("*".equals(association.getMultiplicity())) {
                    XsdGenerator.writeFieldDocumentation(w, field);
                    this.writeListElement(w, field, fieldModelClass.getName());
                } else {
                    w.addAttribute("type", fieldModelClass.getName());
                    XsdGenerator.writeFieldDocumentation(w, field);
                }
            } else if ((class$java$util$List == null ? XsdGenerator.class$("java.util.List") : class$java$util$List).getName().equals(field.getType())) {
                XsdGenerator.writeFieldDocumentation(w, field);
                this.writeListElement(w, field, XsdGenerator.getXsdType("String"));
            } else if ((class$java$util$Properties == null ? XsdGenerator.class$("java.util.Properties") : class$java$util$Properties).getName().equals(field.getType()) || "DOM".equals(field.getType())) {
                XsdGenerator.writeFieldDocumentation(w, field);
                this.writePropertiesElement(w);
            } else {
                throw new IllegalStateException("Non-association field of a non-primitive type '" + field.getType() + "' for '" + field.getName() + "'");
            }
            w.endElement();
        }
        w.endElement();
        w.endElement();
        Iterator iter = toWrite.iterator();
        while (iter.hasNext()) {
            ModelClass fieldModelClass = (ModelClass)iter.next();
            if (written.contains(fieldModelClass)) continue;
            this.writeComplexTypeDescriptor(w, objectModel, fieldModelClass, written);
        }
    }

    private static String getTagName(ModelClass modelClass) {
        ModelClassMetadata metadata = (ModelClassMetadata)modelClass.getMetadata(ModelClassMetadata.ID);
        String tagName = metadata == null || metadata.getTagName() == null ? AbstractModelloGenerator.uncapitalise((String)modelClass.getName()) : metadata.getTagName();
        return tagName;
    }

    private void writePropertiesElement(XMLWriter w) {
        w.startElement("xs:complexType");
        w.startElement("xs:sequence");
        w.startElement("xs:any");
        w.addAttribute("minOccurs", "0");
        w.addAttribute("maxOccurs", "unbounded");
        w.addAttribute("processContents", "skip");
        w.endElement();
        w.endElement();
        w.endElement();
    }

    private void writeListElement(XMLWriter w, ModelField field, String type) {
        w.startElement("xs:complexType");
        w.startElement("xs:sequence");
        w.startElement("xs:element");
        w.addAttribute("name", this.singular(field.getName()));
        w.addAttribute("minOccurs", "0");
        w.addAttribute("maxOccurs", "unbounded");
        w.addAttribute("type", type);
        w.endElement();
        w.endElement();
        w.endElement();
    }

    private static String getXsdType(String type) {
        if ("String".equals(type)) {
            return "xs:string";
        }
        if ("int".equals(type)) {
            return "xs:int";
        }
        if ("boolean".equals(type)) {
            return "xs:boolean";
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

