/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.xdoc;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.codehaus.modello.ModelloException;
import org.codehaus.modello.ModelloRuntimeException;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.ModelAssociation;
import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.ModelField;
import org.codehaus.modello.plugin.AbstractModelloGenerator;
import org.codehaus.modello.plugin.model.ModelClassMetadata;
import org.codehaus.modello.plugins.xml.XmlFieldMetadata;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

public class XdocGenerator
extends AbstractModelloGenerator {
    public void generate(Model model, Properties parameters) throws ModelloException {
        this.initialize(model, parameters);
        try {
            this.generateXdoc();
        }
        catch (IOException ex) {
            throw new ModelloException("Exception while generating XDoc.", (Throwable)ex);
        }
    }

    private void generateXdoc() throws IOException {
        File f;
        Model objectModel = this.getModel();
        String directory = this.getOutputDirectory().getAbsolutePath();
        if (this.isPackageWithVersion()) {
            directory = directory + "/" + this.getGeneratedVersion();
        }
        if (!(f = new File(directory, objectModel.getId() + ".xml")).getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        FileWriter writer = new FileWriter(f);
        PrettyPrintXMLWriter w = new PrettyPrintXMLWriter((Writer)writer);
        writer.write("<?xml version=\"1.0\"?>\n");
        w.startElement("document");
        w.startElement("properties");
        w.startElement("title");
        w.writeText(objectModel.getName());
        w.endElement();
        w.endElement();
        w.startElement("body");
        w.startElement("section");
        w.addAttribute("name", objectModel.getName());
        w.startElement("p");
        w.writeMarkup(objectModel.getDescription());
        w.endElement();
        w.startElement("source");
        StringBuffer sb = new StringBuffer();
        ModelClass root = objectModel.getClass(objectModel.getRoot(this.getGeneratedVersion()), this.getGeneratedVersion());
        sb.append(this.getModelClassDescriptor(objectModel, root, null, 0));
        w.writeMarkup("\n" + sb);
        w.endElement();
        this.writeElementDescriptor((XMLWriter)w, objectModel, root, null, new HashSet());
        w.endElement();
        w.endElement();
        w.endElement();
        writer.flush();
        writer.close();
    }

    private void writeElementDescriptor(XMLWriter w, Model objectModel, ModelClass modelClass, ModelField field, Set written) {
        ModelField f;
        XmlFieldMetadata fieldMetadata;
        String tagName;
        written.add(modelClass);
        ModelClassMetadata metadata = (ModelClassMetadata)modelClass.getMetadata(ModelClassMetadata.ID);
        if (metadata == null || metadata.getTagName() == null) {
            if (field == null) {
                tagName = AbstractModelloGenerator.uncapitalise((String)modelClass.getName());
            } else {
                ModelAssociation a;
                tagName = field.getName();
                if (field instanceof ModelAssociation && "*".equals((a = (ModelAssociation)field).getMultiplicity())) {
                    tagName = this.singular(tagName);
                }
            }
        } else {
            tagName = metadata.getTagName();
        }
        if (field != null && (fieldMetadata = (XmlFieldMetadata)field.getMetadata(XmlFieldMetadata.ID)) != null && fieldMetadata.getTagName() != null) {
            tagName = fieldMetadata.getTagName();
        }
        w.startElement("a");
        w.addAttribute("name", "class_" + tagName);
        w.endElement();
        w.startElement("subsection");
        w.addAttribute("name", tagName);
        if (modelClass.getDescription() != null) {
            w.startElement("p");
            w.writeMarkup(modelClass.getDescription());
            w.endElement();
        }
        w.startElement("table");
        w.startElement("tr");
        w.startElement("th");
        w.writeText("Element");
        w.endElement();
        w.startElement("th");
        w.writeText("Description");
        w.endElement();
        w.endElement();
        List fields = this.getFieldsForClass(objectModel, modelClass);
        Iterator j = fields.iterator();
        while (j.hasNext()) {
            f = (ModelField)j.next();
            w.startElement("tr");
            w.startElement("td");
            w.startElement("code");
            w.writeText(f.getName());
            w.endElement();
            w.endElement();
            w.startElement("td");
            if (f.getDescription() != null) {
                w.writeMarkup(f.getDescription());
            } else {
                w.writeText("No description.");
            }
            w.endElement();
            w.endElement();
        }
        w.endElement();
        w.endElement();
        Iterator iter = fields.iterator();
        while (iter.hasNext()) {
            f = (ModelField)iter.next();
            if (!(f instanceof ModelAssociation) || !this.isClassInModel(((ModelAssociation)f).getTo(), objectModel)) continue;
            ModelAssociation association = (ModelAssociation)f;
            ModelClass fieldModelClass = objectModel.getClass(association.getTo(), this.getGeneratedVersion());
            if (written.contains(f.getName())) continue;
            this.writeElementDescriptor(w, objectModel, fieldModelClass, f, written);
        }
    }

    private List getFieldsForClass(Model objectModel, ModelClass modelClass) {
        ArrayList fields = new ArrayList();
        while (modelClass != null) {
            fields.addAll(modelClass.getFields(this.getGeneratedVersion()));
            String superClass = modelClass.getSuperClass();
            if (superClass != null) {
                modelClass = objectModel.getClass(superClass, this.getGeneratedVersion());
                continue;
            }
            modelClass = null;
        }
        return fields;
    }

    private String getModelClassDescriptor(Model objectModel, ModelClass modelClass, ModelField field, int depth) throws ModelloRuntimeException {
        XmlFieldMetadata fieldMetadata;
        String tagName;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < depth; ++i) {
            sb.append("  ");
        }
        ModelClassMetadata metadata = (ModelClassMetadata)modelClass.getMetadata(ModelClassMetadata.ID);
        if (metadata == null || metadata.getTagName() == null) {
            if (field == null) {
                tagName = AbstractModelloGenerator.uncapitalise((String)modelClass.getName());
            } else {
                ModelAssociation a;
                tagName = field.getName();
                if (field instanceof ModelAssociation && "*".equals((a = (ModelAssociation)field).getMultiplicity())) {
                    tagName = this.singular(tagName);
                }
            }
        } else {
            tagName = metadata.getTagName();
        }
        if (field != null && (fieldMetadata = (XmlFieldMetadata)field.getMetadata(XmlFieldMetadata.ID)) != null && fieldMetadata.getTagName() != null) {
            tagName = fieldMetadata.getTagName();
        }
        sb.append("&lt;<a href=\"#class_").append(tagName).append("\">").append(tagName);
        List fields = this.getFieldsForClass(objectModel, modelClass);
        if (fields.size() > 0) {
            sb.append("</a>&gt;\n");
            Iterator iter = fields.iterator();
            while (iter.hasNext()) {
                ModelField f = (ModelField)iter.next();
                if (f instanceof ModelAssociation && this.isClassInModel(((ModelAssociation)f).getTo(), objectModel)) {
                    int i;
                    ModelAssociation association = (ModelAssociation)f;
                    if ("*".equals(association.getMultiplicity())) {
                        ++depth;
                        for (i = 0; i < depth; ++i) {
                            sb.append("  ");
                        }
                        sb.append("&lt;").append(AbstractModelloGenerator.uncapitalise((String)association.getName())).append("&gt;\n");
                    }
                    ModelClass fieldModelClass = objectModel.getClass(association.getTo(), this.getGeneratedVersion());
                    sb.append(this.getModelClassDescriptor(objectModel, fieldModelClass, f, depth + 1));
                    if (!"*".equals(association.getMultiplicity())) continue;
                    for (i = 0; i < depth; ++i) {
                        sb.append("  ");
                    }
                    sb.append("&lt;/").append(AbstractModelloGenerator.uncapitalise((String)association.getName())).append("&gt;\n");
                    --depth;
                    continue;
                }
                for (int i = 0; i < depth + 1; ++i) {
                    sb.append("  ");
                }
                sb.append("&lt;").append(AbstractModelloGenerator.uncapitalise((String)f.getName())).append("/&gt;\n");
            }
            for (int i = 0; i < depth; ++i) {
                sb.append("  ");
            }
            sb.append("&lt;/").append(tagName).append("&gt;\n");
        } else {
            sb.append("</a>/&gt;\n");
        }
        return sb.toString();
    }
}

