/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.jpox.metadata;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.codehaus.modello.ModelloException;
import org.codehaus.modello.metadata.AbstractMetadataPlugin;
import org.codehaus.modello.metadata.AssociationMetadata;
import org.codehaus.modello.metadata.ClassMetadata;
import org.codehaus.modello.metadata.FieldMetadata;
import org.codehaus.modello.metadata.ModelMetadata;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.ModelAssociation;
import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.ModelField;
import org.codehaus.modello.plugin.jpox.metadata.JPoxAssociationMetadata;
import org.codehaus.modello.plugin.jpox.metadata.JPoxClassMetadata;
import org.codehaus.modello.plugin.jpox.metadata.JPoxFieldMetadata;
import org.codehaus.modello.plugin.jpox.metadata.JPoxModelMetadata;
import org.codehaus.plexus.util.StringUtils;

public class JPoxMetadataPlugin
extends AbstractMetadataPlugin {
    public static final String DEPENDENT = "jpox.dependent";
    public static final String DETACHABLE = "jpox.detachable";
    public static final String FETCH_GROUP_NAMES = "jpox.fetchGroupNames";
    public static final String JOIN = "jpox.join";
    public static final String MAPPED_BY = "jpox.mappedBy";

    public ModelMetadata getModelMetadata(Model model, Map data) {
        return new JPoxModelMetadata();
    }

    public ClassMetadata getClassMetadata(ModelClass clazz, Map data) throws ModelloException {
        JPoxClassMetadata metadata = new JPoxClassMetadata();
        metadata.setDetachable(this.getBoolean(data, DETACHABLE, true));
        return metadata;
    }

    public FieldMetadata getFieldMetadata(ModelField field, Map data) throws ModelloException {
        String mappedBy;
        JPoxFieldMetadata metadata = new JPoxFieldMetadata();
        String fetchGroupNames = (String)data.get(FETCH_GROUP_NAMES);
        if (!StringUtils.isEmpty((String)fetchGroupNames)) {
            List<String> fetchGroups = Arrays.asList(StringUtils.split((String)fetchGroupNames));
            metadata.setFetchGroupNames(fetchGroups);
        }
        if (!StringUtils.isEmpty((String)(mappedBy = (String)data.get(MAPPED_BY)))) {
            metadata.setMappedBy(mappedBy);
        }
        return metadata;
    }

    public AssociationMetadata getAssociationMetadata(ModelAssociation association, Map data) throws ModelloException {
        JPoxAssociationMetadata metadata = new JPoxAssociationMetadata();
        metadata.setDependent(this.getBoolean(data, DEPENDENT, true));
        metadata.setJoin(this.getBoolean(data, JOIN, true));
        return metadata;
    }

    public Map getFieldMap(ModelField field, FieldMetadata metadata) {
        return Collections.EMPTY_MAP;
    }
}

