/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.java.metadata;

import java.util.Map;
import org.codehaus.modello.metadata.AbstractMetadataPlugin;
import org.codehaus.modello.metadata.AssociationMetadata;
import org.codehaus.modello.metadata.ClassMetadata;
import org.codehaus.modello.metadata.FieldMetadata;
import org.codehaus.modello.metadata.InterfaceMetadata;
import org.codehaus.modello.metadata.MetadataPlugin;
import org.codehaus.modello.metadata.ModelMetadata;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.ModelAssociation;
import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.ModelField;
import org.codehaus.modello.model.ModelInterface;
import org.codehaus.modello.plugin.java.metadata.JavaAssociationMetadata;
import org.codehaus.modello.plugin.java.metadata.JavaClassMetadata;
import org.codehaus.modello.plugin.java.metadata.JavaFieldMetadata;
import org.codehaus.modello.plugin.java.metadata.JavaInterfaceMetadata;
import org.codehaus.modello.plugin.java.metadata.JavaModelMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaMetadataPlugin
extends AbstractMetadataPlugin
implements MetadataPlugin {
    public static final String JAVA_ABSTRACT = "java.abstract";
    public static final String JAVA_ADDER = "java.adder";
    public static final String JAVA_BIDI = "java.bidi";
    public static final String JAVA_ENABLED = "java.enabled";
    public static final String JAVA_GETTER = "java.getter";
    public static final String JAVA_INIT = "java.init";
    public static final String JAVA_SETTER = "java.setter";
    public static final String JAVA_USE_INTERFACE = "java.useInterface";
    public static final String JAVA_CLONE = "java.clone";
    public static final String JAVA_CLONE_HOOK = "java.clone.hook";
    public static final String JAVA_SUPPRESS_ALL_WARNINGS = "java.suppressAllWarnings";

    public ModelMetadata getModelMetadata(Model model, Map<String, String> data) {
        JavaModelMetadata metadata = new JavaModelMetadata();
        metadata.setSuppressAllWarnings(this.getBoolean(data, JAVA_SUPPRESS_ALL_WARNINGS, true));
        return metadata;
    }

    public ClassMetadata getClassMetadata(ModelClass clazz, Map<String, String> data) {
        JavaClassMetadata metadata = new JavaClassMetadata();
        metadata.setEnabled(this.getBoolean(data, JAVA_ENABLED, true));
        metadata.setAbstract(this.getBoolean(data, JAVA_ABSTRACT, false));
        metadata.setCloneMode(this.getString(data, JAVA_CLONE));
        metadata.setCloneHook(this.getString(data, JAVA_CLONE_HOOK));
        return metadata;
    }

    public InterfaceMetadata getInterfaceMetadata(ModelInterface iface, Map<String, String> data) {
        return new JavaInterfaceMetadata();
    }

    public FieldMetadata getFieldMetadata(ModelField field, Map<String, String> data) {
        JavaFieldMetadata metadata = new JavaFieldMetadata();
        metadata.setGetter(this.getBoolean(data, JAVA_GETTER, true));
        String fieldType = field.getType();
        metadata.setBooleanGetter(fieldType != null && fieldType.endsWith("oolean"));
        metadata.setSetter(this.getBoolean(data, JAVA_SETTER, true));
        return metadata;
    }

    public AssociationMetadata getAssociationMetadata(ModelAssociation association, Map<String, String> data) {
        JavaAssociationMetadata metadata = new JavaAssociationMetadata();
        metadata.setAdder(this.getBoolean(data, JAVA_ADDER, true));
        metadata.setBidi(this.getBoolean(data, JAVA_BIDI, true));
        metadata.setInterfaceName(this.getString(data, JAVA_USE_INTERFACE));
        metadata.setInitializationMode(this.getString(data, JAVA_INIT));
        metadata.setCloneMode(this.getString(data, JAVA_CLONE));
        return metadata;
    }
}

