/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.java.javasource;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.codehaus.modello.plugin.java.javasource.JConstructor;
import org.codehaus.modello.plugin.java.javasource.JDocComment;
import org.codehaus.modello.plugin.java.javasource.JField;
import org.codehaus.modello.plugin.java.javasource.JMember;
import org.codehaus.modello.plugin.java.javasource.JMethod;
import org.codehaus.modello.plugin.java.javasource.JModifiers;
import org.codehaus.modello.plugin.java.javasource.JNamedMap;
import org.codehaus.modello.plugin.java.javasource.JParameter;
import org.codehaus.modello.plugin.java.javasource.JSourceCode;
import org.codehaus.modello.plugin.java.javasource.JSourceWriter;
import org.codehaus.modello.plugin.java.javasource.JStructure;
import org.codehaus.modello.plugin.java.javasource.JType;

public class JClass
extends JStructure {
    private Vector _constructors = null;
    private JNamedMap _fields = null;
    private Vector _innerClasses = null;
    private Vector _methods = null;
    private String _superClass = null;
    private JSourceCode _staticInitializer = new JSourceCode();
    private List sourceCodeEntries = new ArrayList();

    public JClass(String name) throws IllegalArgumentException {
        super(name);
        this._constructors = new Vector();
        this._fields = new JNamedMap();
        this._methods = new Vector();
        this._innerClasses = new Vector();
        this.getJDocComment().appendComment("Class " + this.getLocalName() + ".");
    }

    public void addConstructor(JConstructor constructor) throws IllegalArgumentException {
        if (constructor == null) {
            throw new IllegalArgumentException("Constructors cannot be null");
        }
        if (constructor.getDeclaringClass() == this) {
            if (!this._constructors.contains(constructor)) {
                this._constructors.addElement(constructor);
            }
        } else {
            String err = "The given JConstructor was not created ";
            err = err + "by this JClass";
            throw new IllegalArgumentException(err);
        }
    }

    public void addField(JField jField) throws IllegalArgumentException {
        if (jField == null) {
            throw new IllegalArgumentException("Class members cannot be null");
        }
        String name = jField.getName();
        if (this._fields.get(name) != null) {
            String err = "duplicate name found: " + name;
            throw new IllegalArgumentException(err);
        }
        this._fields.put(name, jField);
    }

    public void addMember(JMember jMember) throws IllegalArgumentException {
        if (jMember instanceof JField) {
            this.addField((JField)jMember);
        } else if (jMember instanceof JMethod) {
            this.addMethod((JMethod)jMember);
        } else {
            String error = null;
            error = jMember == null ? "the argument 'jMember' must not be null." : "Cannot add JMember '" + jMember.getClass().getName() + "' to JClass, unrecognized type.";
            throw new IllegalArgumentException(error);
        }
    }

    public void addMethod(JMethod jMethod) {
        this.addMethod(jMethod, true);
    }

    public void addMethod(JMethod jMethod, boolean importReturnType) throws IllegalArgumentException {
        if (jMethod == null) {
            throw new IllegalArgumentException("Class methods cannot be null");
        }
        boolean added = false;
        JModifiers modifiers = jMethod.getModifiers();
        if (modifiers.isAbstract()) {
            this.getModifiers().setAbstract(true);
        }
        for (int i = 0; i < this._methods.size(); ++i) {
            JMethod tmp = (JMethod)this._methods.elementAt(i);
            if (tmp.getModifiers().isPrivate() && !modifiers.isPrivate()) {
                this._methods.insertElementAt(jMethod, i);
                added = true;
                break;
            }
            if (jMethod.getName().compareTo(tmp.getName()) >= 0) continue;
            this._methods.insertElementAt(jMethod, i);
            added = true;
            break;
        }
        if (!added) {
            this._methods.addElement(jMethod);
        }
    }

    public void addMethods(JMethod[] jMethods) throws IllegalArgumentException {
        for (int i = 0; i < jMethods.length; ++i) {
            this.addMethod(jMethods[i]);
        }
    }

    public JConstructor createConstructor() {
        return this.createConstructor(null);
    }

    public JConstructor createConstructor(JParameter[] params) {
        JConstructor cons = new JConstructor(this);
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                cons.addParameter(params[i]);
            }
        }
        this.addConstructor(cons);
        return cons;
    }

    public JClass createInnerClass(String localname) {
        if (localname == null) {
            String err = "argument 'localname' must not be null.";
            throw new IllegalArgumentException(err);
        }
        if (localname.indexOf(46) >= 0) {
            String err = "The name of an inner-class must not contain a package name.";
            throw new IllegalArgumentException(err);
        }
        String classname = this.getPackageName();
        classname = classname != null ? classname + "." + localname : localname;
        JInnerClass innerClass = new JInnerClass(classname);
        this._innerClasses.addElement(innerClass);
        return innerClass;
    }

    public JConstructor getConstructor(int index) {
        return (JConstructor)this._constructors.elementAt(index);
    }

    public JConstructor[] getConstructors() {
        int size = this._constructors.size();
        JConstructor[] jcArray = new JConstructor[size];
        for (int i = 0; i < this._constructors.size(); ++i) {
            jcArray[i] = (JConstructor)this._constructors.elementAt(i);
        }
        return jcArray;
    }

    public JField getField(String name) {
        return (JField)this._fields.get(name);
    }

    public JField[] getFields() {
        int size = this._fields.size();
        JField[] farray = new JField[size];
        for (int i = 0; i < size; ++i) {
            farray[i] = (JField)this._fields.get(i);
        }
        return farray;
    }

    public JClass[] getInnerClasses() {
        int size = this._innerClasses.size();
        Object[] carray = new JClass[size];
        this._innerClasses.copyInto(carray);
        return carray;
    }

    public JMethod[] getMethods() {
        int size = this._methods.size();
        JMethod[] marray = new JMethod[size];
        for (int i = 0; i < this._methods.size(); ++i) {
            marray[i] = (JMethod)this._methods.elementAt(i);
        }
        return marray;
    }

    public JMethod getMethod(String name, int startIndex) {
        for (int i = startIndex; i < this._methods.size(); ++i) {
            JMethod jMethod = (JMethod)this._methods.elementAt(i);
            if (!jMethod.getName().equals(name)) continue;
            return jMethod;
        }
        return null;
    }

    public JMethod getMethod(int index) {
        return (JMethod)this._methods.elementAt(index);
    }

    public JSourceCode getStaticInitializationCode() {
        return this._staticInitializer;
    }

    public String getSuperClass() {
        return this._superClass;
    }

    public void print(JSourceWriter jsw) {
        this.print(jsw, false);
    }

    public void print(JSourceWriter jsw, boolean classOnly) {
        int i;
        if (jsw == null) {
            throw new IllegalArgumentException("argument 'jsw' should not be null.");
        }
        StringBuffer buffer = new StringBuffer();
        if (!classOnly) {
            int i2;
            this.printHeader(jsw);
            this.printPackageDeclaration(jsw);
            Vector<String> removeImports = null;
            if (this._innerClasses.size() > 0) {
                removeImports = new Vector<String>();
                for (i2 = 0; i2 < this._innerClasses.size(); ++i2) {
                    JClass iClass = (JClass)this._innerClasses.elementAt(i2);
                    Enumeration e = iClass.getImports();
                    while (e.hasMoreElements()) {
                        String classname = (String)e.nextElement();
                        if (this.hasImport(classname)) continue;
                        this.addImport(classname);
                        removeImports.addElement(classname);
                    }
                }
            }
            this.printImportDeclarations(jsw);
            if (removeImports != null) {
                for (i2 = 0; i2 < removeImports.size(); ++i2) {
                    this.removeImport((String)removeImports.elementAt(i2));
                }
            }
        }
        this.getJDocComment().print(jsw);
        buffer.setLength(0);
        JModifiers modifiers = this.getModifiers();
        if (modifiers.isPrivate()) {
            buffer.append("private ");
        } else if (modifiers.isPublic()) {
            buffer.append("public ");
        }
        if (modifiers.isAbstract()) {
            buffer.append("abstract ");
        }
        buffer.append("class ");
        buffer.append(this.getLocalName());
        jsw.writeln(buffer.toString());
        buffer.setLength(0);
        jsw.indent();
        if (this._superClass != null) {
            buffer.append("extends ");
            buffer.append(this._superClass);
            jsw.writeln(buffer.toString());
            buffer.setLength(0);
        }
        if (this.getInterfaceCount() > 0) {
            buffer.append("implements ");
            Enumeration e = this.getInterfaces();
            while (e.hasMoreElements()) {
                buffer.append(e.nextElement());
                if (!e.hasMoreElements()) continue;
                buffer.append(", ");
            }
            jsw.writeln(buffer.toString());
            buffer.setLength(0);
        }
        jsw.unindent();
        jsw.writeln('{');
        jsw.indent();
        if (this._fields.size() > 0) {
            jsw.writeln();
            jsw.writeln("  //--------------------------/");
            jsw.writeln(" //- Class/Member Variables -/");
            jsw.writeln("//--------------------------/");
            jsw.writeln();
        }
        for (i = 0; i < this._fields.size(); ++i) {
            JField jField = (JField)this._fields.get(i);
            JDocComment comment = jField.getComment();
            if (comment != null) {
                comment.print(jsw);
            }
            jsw.write(jField.getModifiers().toString());
            jsw.write(32);
            JType type = jField.getType();
            String typeName = type.toString();
            if (typeName.equals(this.toString())) {
                typeName = type.getLocalName();
            }
            jsw.write(typeName);
            jsw.write(32);
            jsw.write(jField.getName());
            String init = jField.getInitString();
            if (init != null) {
                jsw.write(" = ");
                jsw.write(init);
            }
            jsw.writeln(';');
            jsw.writeln();
        }
        if (!this._staticInitializer.isEmpty()) {
            jsw.writeln();
            jsw.writeln("static");
            jsw.writeln("{");
            jsw.writeln(this._staticInitializer.toString());
            jsw.writeln("};");
            jsw.writeln();
        }
        if (this._constructors.size() > 0) {
            jsw.writeln();
            jsw.writeln("  //----------------/");
            jsw.writeln(" //- Constructors -/");
            jsw.writeln("//----------------/");
            jsw.writeln();
        }
        for (i = 0; i < this._constructors.size(); ++i) {
            JConstructor jConstructor = (JConstructor)this._constructors.elementAt(i);
            jConstructor.print(jsw);
            jsw.writeln();
        }
        if (this._methods.size() > 0) {
            jsw.writeln();
            jsw.writeln("  //-----------/");
            jsw.writeln(" //- Methods -/");
            jsw.writeln("//-----------/");
            jsw.writeln();
        }
        for (i = 0; i < this._methods.size(); ++i) {
            JMethod jMethod = (JMethod)this._methods.elementAt(i);
            jMethod.print(jsw);
            jsw.writeln();
        }
        if (this._innerClasses.size() > 0) {
            jsw.writeln();
            jsw.writeln("  //-----------------/");
            jsw.writeln(" //- Inner Classes -/");
            jsw.writeln("//-----------------/");
            jsw.writeln();
        }
        for (i = 0; i < this._innerClasses.size(); ++i) {
            JClass jClass = (JClass)this._innerClasses.elementAt(i);
            jClass.print(jsw, true);
            jsw.writeln();
        }
        jsw.unindent();
        Iterator iterator = this.sourceCodeEntries.iterator();
        while (iterator.hasNext()) {
            jsw.write((String)iterator.next());
        }
        jsw.writeln();
        jsw.unindent();
        jsw.writeln('}');
        jsw.flush();
    }

    public void addSourceCode(String sourceCode) {
        this.sourceCodeEntries.add(sourceCode);
    }

    public boolean removeConstructor(JConstructor constructor) {
        return this._constructors.removeElement(constructor);
    }

    public JField removeField(String name) {
        if (name == null) {
            return null;
        }
        JField field = (JField)this._fields.remove(name);
        return field;
    }

    public boolean removeField(JField jField) {
        if (jField == null) {
            return false;
        }
        Object field = this._fields.get(jField.getName());
        if (field == jField) {
            this._fields.remove(jField.getName());
            return true;
        }
        return false;
    }

    public boolean removeInnerClass(JClass jClass) {
        return this._innerClasses.removeElement(jClass);
    }

    public void setSuperClass(String superClass) {
        this._superClass = superClass;
    }

    public static void main(String[] args) {
        JClass testClass = new JClass("org.acme.Test");
        testClass.addImport("java.util.Vector");
        testClass.addMember(new JField(JType.INT, "x"));
        JClass jcString = new JClass("String");
        JField field = null;
        field = new JField(JType.INT, "_z");
        field.getModifiers().setStatic(true);
        testClass.addField(field);
        testClass.getStaticInitializationCode().add("_z = 75;");
        field = new JField(jcString, "myString");
        field.getModifiers().makePrivate();
        testClass.addMember(field);
        JConstructor cons = testClass.createConstructor();
        cons.getSourceCode().add("this.x = 6;");
        JMethod jMethod = new JMethod("getX", JType.INT, null);
        jMethod.setSourceCode("return this.x;");
        testClass.addMethod(jMethod);
        JClass innerClass = testClass.createInnerClass("Foo");
        innerClass.addImport("java.util.Hashtable");
        innerClass.addMember(new JField(JType.INT, "_type"));
        field = new JField(jcString, "_name");
        field.getModifiers().makePrivate();
        innerClass.addMember(field);
        cons = innerClass.createConstructor();
        cons.getSourceCode().add("_name = \"foo\";");
        jMethod = new JMethod("getName", jcString, null);
        jMethod.setSourceCode("return _name;");
        innerClass.addMethod(jMethod);
        testClass.print();
    }

    final class JInnerClass
    extends JClass {
        JInnerClass(String name) {
            super(name);
        }

        public void setPackageName(String packageName) {
            throw new IllegalStateException("Cannot change the package of an inner-class");
        }
    }
}

