/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.path;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.IzPanel;
import com.izforge.izpack.panels.path.PathInputBase;
import com.izforge.izpack.panels.path.PathSelectionPanel;
import java.awt.Component;
import java.awt.LayoutManager2;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PathInputPanel
extends IzPanel
implements ActionListener {
    private static final long serialVersionUID = 3257566217698292531L;
    private static final transient Logger logger = Logger.getLogger(PathInputPanel.class.getName());
    protected boolean mustExist = false;
    protected String[] existFiles = null;
    protected final PathSelectionPanel pathSelectionPanel;
    protected final String emptyTargetMsg = this.getI18nStringForClass("empty_target", "TargetPanel");
    protected final String warnMsg = this.getI18nStringForClass("warn", "TargetPanel");

    public PathInputPanel(Panel panel, InstallerFrame parent, GUIInstallData installData, Resources resources, Log log) {
        super(panel, parent, installData, (LayoutManager2)new IzPanelLayout(log), resources);
        String introText = this.getI18nStringForClass("extendedIntro", "PathInputPanel");
        if ((introText == null || introText.endsWith("extendedIntro") || introText.indexOf(36) > -1) && ((introText = this.getI18nStringForClass("intro", "PathInputPanel")) == null || introText.endsWith("intro"))) {
            introText = "";
        }
        this.add((Component)this.createMultiLineLabel(introText));
        this.add(IzPanelLayout.createParagraphGap());
        this.add(this.createLabel("info", "TargetPanel", "open", 2, true), "nextLine");
        this.pathSelectionPanel = new PathSelectionPanel(this, installData, log);
        this.add(this.pathSelectionPanel, "nextLine");
        this.createLayoutBottom();
        this.getLayoutHelper().completeLayout();
    }

    public String getPath() {
        String chosenPath = this.pathSelectionPanel.getPath();
        return PathInputBase.normalizePath(chosenPath);
    }

    public void createLayoutBottom() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.pathSelectionPanel.getPathInputField()) {
            this.parent.navigateNext();
        }
    }

    public boolean isValidated() {
        String path = this.getPath();
        String normalizedPath = PathInputBase.normalizePath(path);
        File file = new File(normalizedPath).getAbsoluteFile();
        if (normalizedPath.length() == 0 && !this.checkEmptyPath()) {
            return false;
        }
        this.pathSelectionPanel.setPath(normalizedPath);
        if (this.isMustExist()) {
            if (!this.checkExists(file) || !this.pathIsValid(true) || this.modifyInstallation() && !this.checkInstallationInformation(file)) {
                return false;
            }
        } else {
            if (!this.isWritable(file)) {
                this.emitError(this.getString("installer.error"), this.getI18nStringForClass("notwritable", "TargetPanel"));
                return false;
            }
            if (file.exists() ? !this.checkOverwrite(file) : !this.checkCreateDirectory(file)) {
                return false;
            }
        }
        if (!this.installData.getPlatform().isValidDirectoryPath(file)) {
            this.emitError(this.getString("installer.error"), this.getI18nStringForClass("syntax.error", "TargetPanel"));
            return false;
        }
        return true;
    }

    public void panelActivate() {
        super.panelActivate();
        if (this.modifyInstallation()) {
            this.mustExist = true;
        }
        PathInputBase.setInstallData((InstallData)this.installData);
    }

    public boolean isMustExist() {
        return this.mustExist;
    }

    public void setMustExist(boolean mustExist) {
        this.mustExist = mustExist;
    }

    public String[] getExistFiles() {
        return this.existFiles;
    }

    public void setExistFiles(String[] strings) {
        this.existFiles = strings;
    }

    protected boolean checkExists(File file) {
        if (!file.exists()) {
            this.emitError(this.getString("installer.error"), this.getString(this.getI18nStringForClass("required", "PathInputPanel")));
            return false;
        }
        return true;
    }

    protected boolean checkEmptyPath() {
        if (this.isMustExist()) {
            this.emitError(this.getString("installer.error"), this.getI18nStringForClass("required", "PathInputPanel"));
            return false;
        }
        return this.emitWarning(this.getString("installer.warning"), this.emptyTargetMsg);
    }

    protected boolean checkInstallationInformation(File path) {
        File info = new File(path, ".installationinformation");
        if (!info.exists()) {
            this.emitError(this.getString("installer.error"), this.getString("PathInputPanel.required.forModificationInstallation"));
            return false;
        }
        return true;
    }

    protected boolean checkRequiredFilesExist(String path) {
        if (this.existFiles == null || path == null || path.isEmpty()) {
            return true;
        }
        for (String existFile : this.existFiles) {
            File file = new File(path, existFile).getAbsoluteFile();
            if (file.exists()) continue;
            return false;
        }
        return true;
    }

    protected boolean checkCreateDirectory(File dir) {
        boolean result = true;
        String show = this.getMetadata().getConfigurationOptionValue("ShowCreateDirectoryMessage", this.installData.getRules());
        if (show == null || Boolean.getBoolean(show)) {
            result = this.emitNotificationFeedback(this.getI18nStringForClass("createdir", "TargetPanel") + "\n" + dir);
        }
        return result;
    }

    protected boolean checkOverwrite(File dir) {
        boolean result = true;
        String show = this.getMetadata().getConfigurationOptionValue("ShowExistingDirectoryWarning", this.installData.getRules());
        if ((show == null || Boolean.getBoolean(show)) && dir.isDirectory() && dir.list().length > 0) {
            result = this.askWarningQuestion(this.getString("installer.warning"), this.warnMsg, 37, 47) == 47;
        }
        return result;
    }

    protected boolean isWritable(File path) {
        return PathInputBase.isWritable(path);
    }

    protected boolean modifyInstallation() {
        return Boolean.valueOf(this.installData.getVariable("modify.izpack.install"));
    }

    protected boolean pathIsValid() {
        return this.pathIsValid(false);
    }

    protected boolean pathIsValid(boolean notifyUserIfInvalid) {
        String pathToBeChecked = this.getPath();
        boolean isValid = this.checkRequiredFilesExist(pathToBeChecked);
        if (!isValid && notifyUserIfInvalid) {
            String errMsg = this.getString(this.getI18nStringForClass("notValid", "PathInputPanel"));
            logger.log(Level.WARNING, String.format("%s: '%s'", errMsg, pathToBeChecked));
            this.emitError(this.getString("installer.error"), errMsg);
        }
        return isValid;
    }
}

