/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmaven.plugin.tools;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.gmaven:gmaven-plugin:1.2", 0);
        this.append(sb, "", 0);
        this.append(sb, "GMaven Plugin", 0);
        this.append(sb, "Provides support for execution, compilation and other facets of Groovy development.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 9 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "compile".equals(this.goal)) {
            this.append(sb, "groovy:compile", 0);
            this.append(sb, "Compiles Groovy sources.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "classpath", 2);
                this.append(sb, "Additional artifacts to add to the classpath (in addition to the classpath which is picked up from the executing poms configuration).", 3);
                this.append(sb, "", 0);
                this.append(sb, "debug (Default: false)", 2);
                this.append(sb, "Turns debugging operation on or off.", 3);
                this.append(sb, "", 0);
                this.append(sb, "defaultScriptExtension (Default: .groovy)", 2);
                this.append(sb, "Set the default extention for Groovy script source files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.outputDirectory})", 2);
                this.append(sb, "The directory where generated Java class files will be placed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "providerSelection", 2);
                this.append(sb, "A comma-seperated list of provider keys, in order of preference of selection. If the invoking JVM is at least Java 1.5, then the Groovy 1.6 runtime will be used, else the Groovy 1.5 runtime is used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "scriptBaseClassname", 2);
                this.append(sb, "Sets the name of the base class for scripts. It must be a subclass of groovy.lang.Script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceEncoding (Default: ${file.encoding})", 2);
                this.append(sb, "Sets the encoding to be used when reading source files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sources", 2);
                this.append(sb, "Source files to be included. If not specified, then the default will be used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "stacktrace (Default: false)", 2);
                this.append(sb, "Enable compiler to report stack trace information if a problem occurs.", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetBytecode", 2);
                this.append(sb, "Allow setting the bytecode compatibility.", 3);
                this.append(sb, "", 0);
                this.append(sb, "tolerance (Default: 0)", 2);
                this.append(sb, "Sets the error tolerance, which is the number of non-fatal errors (per unit) that should be tolerated before compilation is aborted.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Turns verbose operation on or off.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "console".equals(this.goal)) {
            this.append(sb, "groovy:console", 0);
            this.append(sb, "Launches the Groovy GUI console.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "providerSelection", 2);
                this.append(sb, "A comma-seperated list of provider keys, in order of preference of selection. If the invoking JVM is at least Java 1.5, then the Groovy 1.6 runtime will be used, else the Groovy 1.5 runtime is used.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "execute".equals(this.goal)) {
            this.append(sb, "groovy:execute", 0);
            this.append(sb, "Executes a Groovy script.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "classpath", 2);
                this.append(sb, "Additional artifacts to add to the scripts classpath.", 3);
                this.append(sb, "", 0);
                this.append(sb, "defaults", 2);
                this.append(sb, "A set of default project properties, which the values will be used only if the project or system does not override.", 3);
                this.append(sb, "", 0);
                this.append(sb, "properties", 2);
                this.append(sb, "A set of additional project properties.", 3);
                this.append(sb, "", 0);
                this.append(sb, "providerSelection", 2);
                this.append(sb, "A comma-seperated list of provider keys, in order of preference of selection. If the invoking JVM is at least Java 1.5, then the Groovy 1.6 runtime will be used, else the Groovy 1.5 runtime is used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sanitizeErrors (Default: true)", 2);
                this.append(sb, "Sanatize errors, stripping out Groovy internals.", 3);
                this.append(sb, "", 0);
                this.append(sb, "scriptpath", 2);
                this.append(sb, "Path to search for imported scripts.", 3);
                this.append(sb, "", 0);
                this.append(sb, "source", 2);
                this.append(sb, "The source of the script to execute. This can be a URL, File or script body.", 3);
                this.append(sb, "", 0);
                this.append(sb, "trapAssertionErrors (Default: true)", 2);
                this.append(sb, "Trap assertion errors and rethrow them as execution failures.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "generateStubs".equals(this.goal)) {
            this.append(sb, "groovy:generateStubs", 0);
            this.append(sb, "Generate Java stubs from Groovy sources.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "classpath", 2);
                this.append(sb, "Additional artifacts to add to the classpath (in addition to the classpath which is picked up from the executing poms configuration).", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory}/generated-sources/groovy-stubs/main)", 2);
                this.append(sb, "The directory where generated Java stub files will be placed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "providerSelection", 2);
                this.append(sb, "A comma-seperated list of provider keys, in order of preference of selection. If the invoking JVM is at least Java 1.5, then the Groovy 1.6 runtime will be used, else the Groovy 1.5 runtime is used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sources", 2);
                this.append(sb, "Source files to be included. If not specified, then the default will be used.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "generateTestStubs".equals(this.goal)) {
            this.append(sb, "groovy:generateTestStubs", 0);
            this.append(sb, "Generate Java stubs from Groovy test sources.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "classpath", 2);
                this.append(sb, "Additional artifacts to add to the classpath (in addition to the classpath which is picked up from the executing poms configuration).", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory}/generated-sources/groovy-stubs/test)", 2);
                this.append(sb, "The directory where generated Java stub files will be placed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "providerSelection", 2);
                this.append(sb, "A comma-seperated list of provider keys, in order of preference of selection. If the invoking JVM is at least Java 1.5, then the Groovy 1.6 runtime will be used, else the Groovy 1.5 runtime is used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sources", 2);
                this.append(sb, "Source files to be included. If not specified, then the default will be used.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "groovy:help", 0);
            this.append(sb, "Display help information on gmaven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0groovy:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "providers".equals(this.goal)) {
            this.append(sb, "groovy:providers", 0);
            this.append(sb, "Displays information about the Groovy runtime providers which are configured and selected.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "providerSelection", 2);
                this.append(sb, "A comma-seperated list of provider keys, in order of preference of selection. If the invoking JVM is at least Java 1.5, then the Groovy 1.6 runtime will be used, else the Groovy 1.5 runtime is used.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "shell".equals(this.goal)) {
            this.append(sb, "groovy:shell", 0);
            this.append(sb, "Launches the Groovy Shell (aka. groovysh).", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "args", 2);
                this.append(sb, "Optional arguments to pass to the shell when executing.", 3);
                this.append(sb, "", 0);
                this.append(sb, "color", 2);
                this.append(sb, "Enable or disable use of ANSI colors (aka. groovysh --color). Normally auto-detected.", 3);
                this.append(sb, "", 0);
                this.append(sb, "debug (Default: false)", 2);
                this.append(sb, "Enable debug output (aka. groovysh --debug).", 3);
                this.append(sb, "", 0);
                this.append(sb, "legacy (Default: false)", 2);
                this.append(sb, "Enable the legacy shell.", 3);
                this.append(sb, "", 0);
                this.append(sb, "providerSelection", 2);
                this.append(sb, "A comma-seperated list of provider keys, in order of preference of selection. If the invoking JVM is at least Java 1.5, then the Groovy 1.6 runtime will be used, else the Groovy 1.5 runtime is used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "quiet (Default: false)", 2);
                this.append(sb, "Suppress superfluous output (aka. groovysh --quiet).", 3);
                this.append(sb, "", 0);
                this.append(sb, "terminal", 2);
                this.append(sb, "Specify the terminal type to use (aka. groovysh --terminal). Normally auto-detected. Full class name or one of 'unix', 'win', 'windows', 'false', 'off' or 'none' expected.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Enable verbose output (aka. groovysh --verbose).", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "testCompile".equals(this.goal)) {
            this.append(sb, "groovy:testCompile", 0);
            this.append(sb, "Compiles Groovy test sources.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "classpath", 2);
                this.append(sb, "Additional artifacts to add to the classpath (in addition to the classpath which is picked up from the executing poms configuration).", 3);
                this.append(sb, "", 0);
                this.append(sb, "debug (Default: false)", 2);
                this.append(sb, "Turns debugging operation on or off.", 3);
                this.append(sb, "", 0);
                this.append(sb, "defaultScriptExtension (Default: .groovy)", 2);
                this.append(sb, "Set the default extention for Groovy script source files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.testOutputDirectory})", 2);
                this.append(sb, "The directory where generated Java class files will be placed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "providerSelection", 2);
                this.append(sb, "A comma-seperated list of provider keys, in order of preference of selection. If the invoking JVM is at least Java 1.5, then the Groovy 1.6 runtime will be used, else the Groovy 1.5 runtime is used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "scriptBaseClassname", 2);
                this.append(sb, "Sets the name of the base class for scripts. It must be a subclass of groovy.lang.Script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Flag to allow test compiliation to be skipped.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceEncoding (Default: ${file.encoding})", 2);
                this.append(sb, "Sets the encoding to be used when reading source files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sources", 2);
                this.append(sb, "Source files to be included. If not specified, then the default will be used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "stacktrace (Default: false)", 2);
                this.append(sb, "Enable compiler to report stack trace information if a problem occurs.", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetBytecode", 2);
                this.append(sb, "Allow setting the bytecode compatibility.", 3);
                this.append(sb, "", 0);
                this.append(sb, "tolerance (Default: 0)", 2);
                this.append(sb, "Sets the error tolerance, which is the number of non-fatal errors (per unit) that should be tolerated before compilation is aborted.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Turns verbose operation on or off.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

