/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmaven.plugin;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.shared.io.scan.StaleResourceScanner;
import org.apache.maven.shared.io.scan.mapping.SourceMapping;
import org.apache.maven.shared.model.fileset.FileSet;
import org.codehaus.gmaven.common.ArtifactItem;
import org.codehaus.gmaven.plugin.CompileState;
import org.codehaus.gmaven.plugin.ComponentMojoSupport;

public abstract class CompilerMojoSupport
extends ComponentMojoSupport {
    protected ArtifactItem[] classpath;
    protected FileSet[] sources;
    protected CompileState compileState;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected CompilerMojoSupport(String key) {
        super(key);
    }

    protected abstract File getOutputDirectory() throws Exception;

    protected abstract List getSourceRoots();

    protected void addSourceRoot(File dir) throws IOException {
        if (!$assertionsDisabled && dir == null) {
            throw new AssertionError();
        }
        List roots = this.getSourceRoots();
        if (!$assertionsDisabled && roots == null) {
            throw new AssertionError();
        }
        String path = dir.getCanonicalPath();
        if (!roots.contains(path)) {
            this.log.debug("Adding source root: {}", (Object)path);
            roots.add(path);
        }
    }

    protected abstract FileSet[] getDefaultSources();

    protected ArtifactItem[] getUserClassspathElements() {
        return this.classpath;
    }

    protected Set getIncludesFrom(FileSet fileSet) {
        if (!$assertionsDisabled && fileSet == null) {
            throw new AssertionError();
        }
        List list = fileSet.getIncludes();
        if (list != null) {
            return new HashSet(list);
        }
        return Collections.singleton("**/*");
    }

    protected Set getExcludesFrom(FileSet fileSet) {
        if (!$assertionsDisabled && fileSet == null) {
            throw new AssertionError();
        }
        List list = fileSet.getExcludes();
        if (list != null) {
            return new HashSet(list);
        }
        return Collections.EMPTY_SET;
    }

    protected File[] scanForSources(FileSet fileSet, SourceMapping[] mappings) throws Exception {
        if (!$assertionsDisabled && fileSet == null) {
            throw new AssertionError();
        }
        File sourceDir = new File(fileSet.getDirectory());
        this.log.debug("Scanning for sources in: {}", (Object)sourceDir);
        if (!sourceDir.exists()) {
            this.log.debug("Skipping; missing source directory: {}", (Object)sourceDir);
            return new File[0];
        }
        File targetDir = this.getOutputDirectory();
        Set includes = this.getIncludesFrom(fileSet);
        Set excludes = this.getExcludesFrom(fileSet);
        StaleResourceScanner scanner = new StaleResourceScanner(0L, includes, excludes);
        if (mappings != null && mappings.length > 0) {
            for (int i = 0; i < mappings.length; ++i) {
                scanner.addSourceMapping(mappings[i]);
            }
        }
        Set files = scanner.getIncludedSources(sourceDir, targetDir);
        return files.toArray(new File[files.size()]);
    }

    protected File[] scanForSources(FileSet fileSet, SourceMapping mapping) throws Exception {
        if (!$assertionsDisabled && mapping == null) {
            throw new AssertionError();
        }
        return this.scanForSources(fileSet, new SourceMapping[]{mapping});
    }

    static {
        $assertionsDisabled = !CompilerMojoSupport.class.desiredAssertionStatus();
    }
}

