/*
 * Decompiled with CFR 0.152.
 */
package jsr166y.forkjoin;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.concurrent.atomic.AtomicInteger;
import jsr166y.forkjoin.ForkJoinExecutor;
import jsr166y.forkjoin.Ops;
import jsr166y.forkjoin.PAS;
import jsr166y.forkjoin.ParallelArray;
import jsr166y.forkjoin.ParallelDoubleArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParallelLongArray {
    long[] array;
    final ForkJoinExecutor ex;
    int limit;
    AsList listView;

    public static ForkJoinExecutor defaultExecutor() {
        return PAS.defaultExecutor();
    }

    protected ParallelLongArray(ForkJoinExecutor executor, long[] array, int limit) {
        if (executor == null || array == null) {
            throw new NullPointerException();
        }
        if (limit < 0 || limit > array.length) {
            throw new IllegalArgumentException();
        }
        this.ex = executor;
        this.array = array;
        this.limit = limit;
    }

    ParallelLongArray(ForkJoinExecutor executor, long[] array) {
        this.ex = executor;
        this.array = array;
        this.limit = array.length;
    }

    public static ParallelLongArray create(int size, ForkJoinExecutor executor) {
        long[] array = new long[size];
        return new ParallelLongArray(executor, array, size);
    }

    public static ParallelLongArray createUsingHandoff(long[] handoff, ForkJoinExecutor executor) {
        return new ParallelLongArray(executor, handoff, handoff.length);
    }

    public static ParallelLongArray createFromCopy(long[] source, ForkJoinExecutor executor) {
        int size = source.length;
        long[] array = new long[size];
        System.arraycopy(source, 0, array, 0, size);
        return new ParallelLongArray(executor, array, size);
    }

    public static ParallelLongArray createFromCopy(int size, long[] source, ForkJoinExecutor executor) {
        long[] array = new long[size];
        System.arraycopy(source, 0, array, 0, Math.min(source.length, size));
        return new ParallelLongArray(executor, array, size);
    }

    public static ParallelLongArray createEmpty(int size, ForkJoinExecutor executor) {
        long[] array = new long[size];
        return new ParallelLongArray(executor, array, 0);
    }

    public ForkJoinExecutor getExecutor() {
        return this.ex;
    }

    public void apply(Ops.LongProcedure procedure) {
        new WithBounds(this).apply(procedure);
    }

    public long reduce(Ops.LongReducer reducer, long base) {
        return new WithBounds(this).reduce(reducer, base);
    }

    public ParallelLongArray all() {
        return new WithBounds(this).all();
    }

    public ParallelLongArray combine(long[] other, Ops.LongReducer combiner) {
        return new WithBounds(this).combine(other, combiner);
    }

    public <U, V> ParallelLongArray combine(ParallelLongArray other, Ops.LongReducer combiner) {
        return new WithBounds(this).combine(other, combiner);
    }

    public <U, V> ParallelLongArray combine(WithBounds other, Ops.LongReducer combiner) {
        return new WithBounds(this).combine(other, combiner);
    }

    public void replaceWithTransform(Ops.LongMapper mapper) {
        new WithBounds(this).replaceWithTransform(mapper);
    }

    public void replaceWithMappedIndex(Ops.MapperFromIntToLong mapper) {
        new WithBounds(this).replaceWithMappedIndex(mapper);
    }

    public void replaceWithGeneratedValue(Ops.LongGenerator generator) {
        new WithBounds(this).replaceWithGeneratedValue(generator);
    }

    public void replaceWithValue(long value) {
        new WithBounds(this).replaceWithValue(value);
    }

    public void replaceWithCombination(ParallelLongArray other, Ops.LongReducer combiner) {
        new WithBounds(this).replaceWithCombination(other.array, combiner);
    }

    public void replaceWithCombination(long[] other, Ops.LongReducer combiner) {
        new WithBounds(this).replaceWithCombination(other, combiner);
    }

    public void replaceWithCombination(WithBounds other, Ops.LongReducer combiner) {
        new WithBounds(this).replaceWithCombination(other, combiner);
    }

    public int indexOf(long target) {
        return new WithBounds(this).indexOf(target);
    }

    public int binarySearch(long target) {
        int lo = 0;
        int hi = this.limit - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            long m = this.array[mid];
            if (target == m) {
                return mid;
            }
            if (target < m) {
                hi = mid - 1;
                continue;
            }
            lo = mid + 1;
        }
        return -1;
    }

    public int binarySearch(long target, Ops.LongComparator comparator) {
        int lo = 0;
        int hi = this.limit - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            int c = comparator.compare(target, this.array[mid]);
            if (c == 0) {
                return mid;
            }
            if (c < 0) {
                hi = mid - 1;
                continue;
            }
            lo = mid + 1;
        }
        return -1;
    }

    public SummaryStatistics summary(Ops.LongComparator comparator) {
        return new WithBounds(this).summary(comparator);
    }

    public SummaryStatistics summary() {
        return new WithBounds(this).summary();
    }

    public long min(Ops.LongComparator comparator) {
        return new WithBounds(this).min(comparator);
    }

    public long min() {
        return new WithBounds(this).min();
    }

    public long max(Ops.LongComparator comparator) {
        return new WithBounds(this).max(comparator);
    }

    public long max() {
        return new WithBounds(this).max();
    }

    public void cumulate(Ops.LongReducer reducer, long base) {
        new WithBounds(this).cumulate(reducer, base);
    }

    public long precumulate(Ops.LongReducer reducer, long base) {
        return new WithBounds(this).precumulate(reducer, base);
    }

    public void sort(Ops.LongComparator comparator) {
        new WithBounds(this).sort(comparator);
    }

    public void sort() {
        new WithBounds(this).sort();
    }

    public void removeConsecutiveDuplicates() {
        new WithBounds(this).removeConsecutiveDuplicates();
    }

    public ParallelLongArray allUniqueElements() {
        return new WithBounds(this).allUniqueElements();
    }

    public long sum() {
        return new WithBounds(this).sum();
    }

    public void cumulateSum() {
        new WithBounds(this).cumulateSum();
    }

    public long precumulateSum() {
        return new WithBounds(this).precumulateSum();
    }

    public WithBounds withBounds(int firstIndex, int upperBound) {
        if (firstIndex > upperBound) {
            throw new IllegalArgumentException("firstIndex(" + firstIndex + ") > upperBound(" + upperBound + ")");
        }
        if (firstIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(firstIndex);
        }
        if (upperBound > this.limit) {
            throw new ArrayIndexOutOfBoundsException(upperBound);
        }
        return new WithBounds(this, firstIndex, upperBound);
    }

    public WithFilter withFilter(Ops.LongPredicate selector) {
        return new WithBoundedFilter(this, 0, this.limit, selector);
    }

    public <U> WithMapping<U> withMapping(Ops.MapperFromLong<? extends U> mapper) {
        return new WithBoundedMapping<U>(this, 0, this.limit, mapper);
    }

    public WithLongMapping withMapping(Ops.LongMapper mapper) {
        return new WithBoundedLongMapping(this, 0, this.limit, mapper);
    }

    public WithDoubleMapping withMapping(Ops.MapperFromLongToDouble mapper) {
        return new WithBoundedDoubleMapping(this, 0, this.limit, mapper);
    }

    public Iterator<Long> iterator() {
        return new ParallelLongArrayIterator(this.array, this.limit);
    }

    public List<Long> asList() {
        AsList lv = this.listView;
        if (lv == null) {
            this.listView = lv = new AsList();
        }
        return lv;
    }

    public int size() {
        return this.limit;
    }

    public long[] getArray() {
        return this.array;
    }

    public long get(int i) {
        return this.array[i];
    }

    public void set(int i, long x) {
        this.array[i] = x;
    }

    public String toString() {
        return this.asList().toString();
    }

    public void addAll(long[] other) {
        int csize = other.length;
        int end = this.limit;
        this.insertSlotsAt(end, csize);
        System.arraycopy(other, 0, this.array, end, csize);
    }

    public void addAll(ParallelLongArray other) {
        int csize = other.size();
        int end = this.limit;
        this.insertSlotsAt(end, csize);
        System.arraycopy(other.array, 0, this.array, end, csize);
    }

    public void addAll(WithBounds other) {
        int csize = other.size();
        int end = this.limit;
        this.insertSlotsAt(end, csize);
        System.arraycopy(other.pa.array, other.firstIndex, this.array, end, csize);
    }

    public final void setLimit(int newLimit) {
        if (newLimit < 0) {
            throw new IllegalArgumentException();
        }
        int cap = this.array.length;
        if (newLimit > cap) {
            this.resizeArray(newLimit);
        }
        this.limit = newLimit;
    }

    final void replaceElementsWith(long[] a) {
        System.arraycopy(a, 0, this.array, 0, a.length);
        this.limit = a.length;
    }

    final void resizeArray(int newCap) {
        int cap = this.array.length;
        if (newCap > cap) {
            long[] a = new long[newCap];
            System.arraycopy(this.array, 0, a, 0, cap);
            this.array = a;
        }
    }

    final void insertElementAt(int index, long e) {
        int hi;
        if ((hi = this.limit++) >= this.array.length) {
            this.resizeArray(hi * 3 / 2 + 1);
        }
        if (hi > index) {
            System.arraycopy(this.array, index, this.array, index + 1, hi - index);
        }
        this.array[index] = e;
    }

    final void appendElement(long e) {
        int hi;
        if ((hi = this.limit++) >= this.array.length) {
            this.resizeArray(hi * 3 / 2 + 1);
        }
        this.array[hi] = e;
    }

    final void insertSlotsAt(int index, int len) {
        if (len <= 0) {
            return;
        }
        int cap = this.array.length;
        int newSize = this.limit + len;
        if (cap < newSize) {
            if ((cap = cap * 3 / 2 + 1) < newSize) {
                cap = newSize;
            }
            this.resizeArray(cap);
        }
        if (index < this.limit) {
            System.arraycopy(this.array, index, this.array, index + len, this.limit - index);
        }
        this.limit = newSize;
    }

    final void removeSlotAt(int index) {
        System.arraycopy(this.array, index + 1, this.array, index, this.limit - index - 1);
        --this.limit;
    }

    final void removeSlotsAt(int fromIndex, int toIndex) {
        if (fromIndex < toIndex) {
            int newSize;
            int size = this.limit;
            System.arraycopy(this.array, toIndex, this.array, fromIndex, size - toIndex);
            this.limit = newSize = size - (toIndex - fromIndex);
        }
    }

    final int seqIndexOf(long target) {
        long[] arr = this.array;
        int fence = this.limit;
        for (int i = 0; i < fence; ++i) {
            if (target != arr[i]) continue;
            return i;
        }
        return -1;
    }

    final int seqLastIndexOf(long target) {
        long[] arr = this.array;
        for (int i = this.limit - 1; i >= 0; --i) {
            if (target != arr[i]) continue;
            return i;
        }
        return -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class AsList
    extends AbstractList<Long>
    implements RandomAccess {
        AsList() {
        }

        @Override
        public Long get(int i) {
            if (i >= ParallelLongArray.this.limit) {
                throw new IndexOutOfBoundsException();
            }
            return ParallelLongArray.this.array[i];
        }

        @Override
        public Long set(int i, Long x) {
            if (i >= ParallelLongArray.this.limit) {
                throw new IndexOutOfBoundsException();
            }
            long[] arr = ParallelLongArray.this.array;
            Long t = arr[i];
            arr[i] = x;
            return t;
        }

        @Override
        public boolean isEmpty() {
            return ParallelLongArray.this.limit == 0;
        }

        @Override
        public int size() {
            return ParallelLongArray.this.limit;
        }

        @Override
        public Iterator<Long> iterator() {
            return new ListIter(0);
        }

        @Override
        public ListIterator<Long> listIterator() {
            return new ListIter(0);
        }

        @Override
        public ListIterator<Long> listIterator(int index) {
            if (index < 0 || index > ParallelLongArray.this.limit) {
                throw new IndexOutOfBoundsException();
            }
            return new ListIter(index);
        }

        @Override
        public boolean add(Long e) {
            ParallelLongArray.this.appendElement(e);
            return true;
        }

        @Override
        public void add(int index, Long e) {
            if (index < 0 || index > ParallelLongArray.this.limit) {
                throw new IndexOutOfBoundsException();
            }
            ParallelLongArray.this.insertElementAt(index, e);
        }

        @Override
        public boolean addAll(Collection<? extends Long> c) {
            int csize = c.size();
            if (csize == 0) {
                return false;
            }
            int hi = ParallelLongArray.this.limit;
            ParallelLongArray.this.setLimit(hi + csize);
            long[] arr = ParallelLongArray.this.array;
            for (Long l : c) {
                arr[hi++] = l;
            }
            return true;
        }

        @Override
        public boolean addAll(int index, Collection<? extends Long> c) {
            if (index < 0 || index > ParallelLongArray.this.limit) {
                throw new IndexOutOfBoundsException();
            }
            int csize = c.size();
            if (csize == 0) {
                return false;
            }
            ParallelLongArray.this.insertSlotsAt(index, csize);
            long[] arr = ParallelLongArray.this.array;
            for (Long l : c) {
                arr[index++] = l;
            }
            return true;
        }

        @Override
        public void clear() {
            ParallelLongArray.this.limit = 0;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Long)) {
                return false;
            }
            int idx = ParallelLongArray.this.seqIndexOf((Long)o);
            if (idx < 0) {
                return false;
            }
            ParallelLongArray.this.removeSlotAt(idx);
            return true;
        }

        @Override
        public Long remove(int index) {
            Long oldValue = this.get(index);
            ParallelLongArray.this.removeSlotAt(index);
            return oldValue;
        }

        @Override
        protected void removeRange(int fromIndex, int toIndex) {
            ParallelLongArray.this.removeSlotsAt(fromIndex, toIndex);
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Long)) {
                return false;
            }
            return ParallelLongArray.this.seqIndexOf((Long)o) >= 0;
        }

        @Override
        public int indexOf(Object o) {
            if (!(o instanceof Long)) {
                return -1;
            }
            return ParallelLongArray.this.seqIndexOf((Long)o);
        }

        @Override
        public int lastIndexOf(Object o) {
            if (!(o instanceof Long)) {
                return -1;
            }
            return ParallelLongArray.this.seqLastIndexOf((Long)o);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ListIter
    implements ListIterator<Long> {
        int cursor;
        int lastRet;
        long[] arr;
        int hi;

        ListIter(int lo) {
            this.cursor = lo;
            this.lastRet = -1;
            this.arr = ParallelLongArray.this.array;
            this.hi = ParallelLongArray.this.limit;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.hi;
        }

        @Override
        public Long next() {
            int i = this.cursor;
            if (i < 0 || i >= this.hi) {
                throw new NoSuchElementException();
            }
            long next = this.arr[i];
            this.lastRet = i;
            this.cursor = i + 1;
            return next;
        }

        @Override
        public void remove() {
            int k = this.lastRet;
            if (k < 0) {
                throw new IllegalStateException();
            }
            ParallelLongArray.this.removeSlotAt(k);
            this.hi = ParallelLongArray.this.limit;
            if (this.lastRet < this.cursor) {
                --this.cursor;
            }
            this.lastRet = -1;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public Long previous() {
            int i = this.cursor - 1;
            if (i < 0 || i >= this.hi) {
                throw new NoSuchElementException();
            }
            long previous = this.arr[i];
            this.lastRet = this.cursor = i;
            return previous;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void set(Long e) {
            int i = this.lastRet;
            if (i < 0 || i >= this.hi) {
                throw new NoSuchElementException();
            }
            this.arr[i] = e;
        }

        @Override
        public void add(Long e) {
            int i = this.cursor;
            ParallelLongArray.this.insertElementAt(i, e);
            this.arr = ParallelLongArray.this.array;
            this.hi = ParallelLongArray.this.limit;
            this.lastRet = -1;
            this.cursor = i + 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ParallelLongArrayIterator
    implements Iterator<Long> {
        int cursor;
        final long[] arr;
        final int hi;

        ParallelLongArrayIterator(long[] a, int limit) {
            this.arr = a;
            this.hi = limit;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.hi;
        }

        @Override
        public Long next() {
            if (this.cursor >= this.hi) {
                throw new NoSuchElementException();
            }
            return this.arr[this.cursor++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class WithBoundedFilteredDoubleMapping
    extends WithDoubleMapping {
        final Ops.LongPredicate selector;

        WithBoundedFilteredDoubleMapping(ParallelLongArray pa, int firstIndex, int upperBound, Ops.LongPredicate selector, Ops.MapperFromLongToDouble mapper) {
            super(pa, firstIndex, upperBound, mapper);
            this.selector = selector;
        }

        @Override
        public ParallelDoubleArray all() {
            PAS.FJDSelectAllDriver r = new PAS.FJDSelectAllDriver(this);
            this.ex.invoke(r);
            return new ParallelDoubleArray(this.ex, r.results);
        }

        @Override
        public int size() {
            PAS.FJLCountSelected f = new PAS.FJLCountSelected(this, this.firstIndex, this.upperBound, null, this.selector);
            this.ex.invoke(f);
            return f.count;
        }

        @Override
        public int anyIndex() {
            AtomicInteger result = new AtomicInteger(-1);
            PAS.FJLSelectAny f = new PAS.FJLSelectAny(this, this.firstIndex, this.upperBound, null, result, this.selector);
            this.ex.invoke(f);
            return result.get();
        }

        @Override
        public WithLongMapping withMapping(Ops.MapperFromDoubleToLong mapper) {
            return new WithBoundedFilteredLongMapping(this.pa, this.firstIndex, this.upperBound, this.selector, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        public WithDoubleMapping withMapping(Ops.DoubleMapper mapper) {
            return new WithBoundedFilteredDoubleMapping(this.pa, this.firstIndex, this.upperBound, this.selector, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        public <U> WithMapping<U> withMapping(Ops.MapperFromDouble<? extends U> mapper) {
            return new WithBoundedFilteredMapping<U>(this.pa, this.firstIndex, this.upperBound, this.selector, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.DoubleProcedure procedure) {
            Ops.LongPredicate sel = this.selector;
            long[] array = this.pa.array;
            Ops.MapperFromLongToDouble mpr = this.mapper;
            for (int i = lo; i < hi; ++i) {
                long x = array[i];
                if (!sel.evaluate(x)) continue;
                procedure.apply(mpr.map(x));
            }
        }

        @Override
        double leafReduce(int lo, int hi, Ops.DoubleReducer reducer, double base) {
            Ops.LongPredicate sel = this.selector;
            Ops.MapperFromLongToDouble mpr = this.mapper;
            boolean gotFirst = false;
            double r = base;
            long[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                long t = array[i];
                if (!sel.evaluate(t)) continue;
                double y = mpr.map(t);
                if (!gotFirst) {
                    gotFirst = true;
                    r = y;
                    continue;
                }
                r = reducer.combine(r, y);
            }
            return r;
        }

        @Override
        void leafStats(int lo, int hi, PAS.FJDStats task) {
            Ops.LongPredicate sel = this.selector;
            Ops.MapperFromLongToDouble mpr = this.mapper;
            long[] array = this.pa.array;
            int count = 0;
            for (int i = lo; i < hi; ++i) {
                long t = array[i];
                if (!sel.evaluate(t)) continue;
                ++count;
                double x = mpr.map(t);
                task.sum += x;
                task.updateMin(i, x);
                task.updateMax(i, x);
            }
            task.size = count;
        }

        @Override
        int leafIndexSelected(int lo, int hi, boolean positive, int[] indices) {
            Ops.LongPredicate sel = this.selector;
            long[] array = this.pa.array;
            int k = 0;
            for (int i = lo; i < hi; ++i) {
                if (sel.evaluate(array[i]) != positive) continue;
                indices[lo + k++] = i;
            }
            return k;
        }

        @Override
        int leafMoveSelected(int lo, int hi, int offset, boolean positive) {
            Ops.LongPredicate sel = this.selector;
            long[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                long t = array[i];
                if (sel.evaluate(t) != positive) continue;
                array[offset++] = t;
            }
            return offset;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class WithBoundedDoubleMapping
    extends WithDoubleMapping {
        WithBoundedDoubleMapping(ParallelLongArray pa, int firstIndex, int upperBound, Ops.MapperFromLongToDouble mapper) {
            super(pa, firstIndex, upperBound, mapper);
        }

        @Override
        public ParallelDoubleArray all() {
            double[] dest = new double[this.upperBound - this.firstIndex];
            PAS.FJDMap f = new PAS.FJDMap(this, this.firstIndex, this.upperBound, null, dest, this.firstIndex);
            this.ex.invoke(f);
            return new ParallelDoubleArray(this.ex, dest);
        }

        @Override
        public int size() {
            return this.upperBound - this.firstIndex;
        }

        @Override
        public int anyIndex() {
            return this.firstIndex < this.upperBound ? this.firstIndex : -1;
        }

        @Override
        public WithLongMapping withMapping(Ops.MapperFromDoubleToLong mapper) {
            return new WithBoundedLongMapping(this.pa, this.firstIndex, this.upperBound, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        public WithDoubleMapping withMapping(Ops.DoubleMapper mapper) {
            return new WithBoundedDoubleMapping(this.pa, this.firstIndex, this.upperBound, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        public <U> WithMapping<U> withMapping(Ops.MapperFromDouble<? extends U> mapper) {
            return new WithBoundedMapping<U>(this.pa, this.firstIndex, this.upperBound, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.DoubleProcedure procedure) {
            Ops.MapperFromLongToDouble mpr = this.mapper;
            long[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                procedure.apply(mpr.map(array[i]));
            }
        }

        @Override
        double leafReduce(int lo, int hi, Ops.DoubleReducer reducer, double base) {
            if (lo >= hi) {
                return base;
            }
            long[] array = this.pa.array;
            Ops.MapperFromLongToDouble mpr = this.mapper;
            double r = mpr.map(array[lo]);
            for (int i = lo + 1; i < hi; ++i) {
                r = reducer.combine(r, mpr.map(array[i]));
            }
            return r;
        }

        @Override
        void leafStats(int lo, int hi, PAS.FJDStats task) {
            long[] array = this.pa.array;
            Ops.MapperFromLongToDouble mpr = this.mapper;
            task.size = hi - lo;
            for (int i = lo; i < hi; ++i) {
                double x = mpr.map(array[i]);
                task.sum += x;
                task.updateMin(i, x);
                task.updateMax(i, x);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class WithDoubleMapping
    extends PAS.LPrefix {
        final Ops.MapperFromLongToDouble mapper;

        WithDoubleMapping(ParallelLongArray pa, int firstIndex, int upperBound, Ops.MapperFromLongToDouble mapper) {
            super(pa, firstIndex, upperBound);
            this.mapper = mapper;
        }

        public void apply(Ops.DoubleProcedure procedure) {
            this.ex.invoke(new PAS.FJDApply(this, this.firstIndex, this.upperBound, null, procedure));
        }

        public double reduce(Ops.DoubleReducer reducer, double base) {
            PAS.FJDReduce f = new PAS.FJDReduce(this, this.firstIndex, this.upperBound, null, reducer, base);
            this.ex.invoke(f);
            return f.result;
        }

        public double min() {
            return this.reduce(Ops.naturalDoubleMinReducer(), Double.MAX_VALUE);
        }

        public double min(Ops.DoubleComparator comparator) {
            return this.reduce(Ops.doubleMinReducer(comparator), Double.MAX_VALUE);
        }

        public double max() {
            return this.reduce(Ops.naturalDoubleMaxReducer(), -1.7976931348623157E308);
        }

        public double max(Ops.DoubleComparator comparator) {
            return this.reduce(Ops.doubleMaxReducer(comparator), -1.7976931348623157E308);
        }

        public double sum() {
            return this.reduce(Ops.doubleAdder(), 0.0);
        }

        public ParallelDoubleArray.SummaryStatistics summary(Ops.DoubleComparator comparator) {
            PAS.FJDStats f = new PAS.FJDStats(this, this.firstIndex, this.upperBound, null, comparator);
            this.ex.invoke(f);
            return f;
        }

        public ParallelDoubleArray.SummaryStatistics summary() {
            PAS.FJDStats f = new PAS.FJDStats(this, this.firstIndex, this.upperBound, null, Ops.naturalDoubleComparator());
            this.ex.invoke(f);
            return f;
        }

        public abstract ParallelDoubleArray all();

        public abstract int size();

        public abstract int anyIndex();

        public abstract WithLongMapping withMapping(Ops.MapperFromDoubleToLong var1);

        public abstract WithDoubleMapping withMapping(Ops.DoubleMapper var1);

        public abstract <U> WithMapping<U> withMapping(Ops.MapperFromDouble<? extends U> var1);

        @Override
        final void leafTransfer(int lo, int hi, double[] dest, int offset) {
            long[] array = this.pa.array;
            Ops.MapperFromLongToDouble mpr = this.mapper;
            for (int i = lo; i < hi; ++i) {
                dest[offset++] = mpr.map(array[i]);
            }
        }

        @Override
        final void leafTransferByIndex(int[] indices, int loIdx, int hiIdx, double[] dest, int offset) {
            long[] array = this.pa.array;
            Ops.MapperFromLongToDouble mpr = this.mapper;
            for (int i = loIdx; i < hiIdx; ++i) {
                dest[offset++] = mpr.map(array[indices[i]]);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class WithBoundedFilteredLongMapping
    extends WithLongMapping {
        final Ops.LongPredicate selector;
        final Ops.LongMapper mapper;

        WithBoundedFilteredLongMapping(ParallelLongArray pa, int firstIndex, int upperBound, Ops.LongPredicate selector, Ops.LongMapper mapper) {
            super(pa, firstIndex, upperBound);
            this.selector = selector;
            this.mapper = mapper;
        }

        @Override
        public ParallelLongArray all() {
            PAS.FJLSelectAllDriver r = new PAS.FJLSelectAllDriver(this);
            this.ex.invoke(r);
            return new ParallelLongArray(this.ex, r.results);
        }

        @Override
        public int size() {
            PAS.FJLCountSelected f = new PAS.FJLCountSelected(this, this.firstIndex, this.upperBound, null, this.selector);
            this.ex.invoke(f);
            return f.count;
        }

        @Override
        public int anyIndex() {
            AtomicInteger result = new AtomicInteger(-1);
            PAS.FJLSelectAny f = new PAS.FJLSelectAny(this, this.firstIndex, this.upperBound, null, result, this.selector);
            this.ex.invoke(f);
            return result.get();
        }

        @Override
        public WithLongMapping withMapping(Ops.LongMapper mapper) {
            return new WithBoundedFilteredLongMapping(this.pa, this.firstIndex, this.upperBound, this.selector, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        public WithDoubleMapping withMapping(Ops.MapperFromLongToDouble mapper) {
            return new WithBoundedFilteredDoubleMapping(this.pa, this.firstIndex, this.upperBound, this.selector, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        public <U> WithMapping<U> withMapping(Ops.MapperFromLong<? extends U> mapper) {
            return new WithBoundedFilteredMapping<U>(this.pa, this.firstIndex, this.upperBound, this.selector, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.LongProcedure procedure) {
            Ops.LongPredicate sel = this.selector;
            Ops.LongMapper mpr = this.mapper;
            long[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                long x = array[i];
                if (!sel.evaluate(x)) continue;
                procedure.apply(mpr.map(x));
            }
        }

        @Override
        long leafReduce(int lo, int hi, Ops.LongReducer reducer, long base) {
            Ops.LongPredicate sel = this.selector;
            Ops.LongMapper mpr = this.mapper;
            boolean gotFirst = false;
            long r = base;
            long[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                long t = array[i];
                if (!sel.evaluate(t)) continue;
                long y = mpr.map(t);
                if (!gotFirst) {
                    gotFirst = true;
                    r = y;
                    continue;
                }
                r = reducer.combine(r, y);
            }
            return r;
        }

        @Override
        void leafStats(int lo, int hi, PAS.FJLStats task) {
            Ops.LongPredicate sel = this.selector;
            long[] array = this.pa.array;
            Ops.LongMapper mpr = this.mapper;
            int count = 0;
            for (int i = lo; i < hi; ++i) {
                long t = array[i];
                if (!sel.evaluate(t)) continue;
                ++count;
                long x = mpr.map(t);
                task.sum += x;
                task.updateMin(i, x);
                task.updateMax(i, x);
            }
            task.size = count;
        }

        @Override
        final void leafTransfer(int lo, int hi, long[] dest, int offset) {
            long[] array = this.pa.array;
            Ops.LongMapper mpr = this.mapper;
            for (int i = lo; i < hi; ++i) {
                dest[offset++] = mpr.map(array[i]);
            }
        }

        @Override
        final void leafTransferByIndex(int[] indices, int loIdx, int hiIdx, long[] dest, int offset) {
            long[] array = this.pa.array;
            Ops.LongMapper mpr = this.mapper;
            for (int i = loIdx; i < hiIdx; ++i) {
                dest[offset++] = mpr.map(array[indices[i]]);
            }
        }

        @Override
        int leafIndexSelected(int lo, int hi, boolean positive, int[] indices) {
            Ops.LongPredicate sel = this.selector;
            long[] array = this.pa.array;
            int k = 0;
            for (int i = lo; i < hi; ++i) {
                if (sel.evaluate(array[i]) != positive) continue;
                indices[lo + k++] = i;
            }
            return k;
        }

        @Override
        int leafMoveSelected(int lo, int hi, int offset, boolean positive) {
            Ops.LongPredicate sel = this.selector;
            long[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                long t = array[i];
                if (sel.evaluate(t) != positive) continue;
                array[offset++] = t;
            }
            return offset;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class WithBoundedLongMapping
    extends WithLongMapping {
        final Ops.LongMapper mapper;

        WithBoundedLongMapping(ParallelLongArray pa, int firstIndex, int upperBound, Ops.LongMapper mapper) {
            super(pa, firstIndex, upperBound);
            this.mapper = mapper;
        }

        @Override
        public ParallelLongArray all() {
            long[] dest = new long[this.upperBound - this.firstIndex];
            PAS.FJLMap f = new PAS.FJLMap(this, this.firstIndex, this.upperBound, null, dest, this.firstIndex);
            this.ex.invoke(f);
            return new ParallelLongArray(this.ex, dest);
        }

        @Override
        public int size() {
            return this.upperBound - this.firstIndex;
        }

        @Override
        public int anyIndex() {
            return this.firstIndex < this.upperBound ? this.firstIndex : -1;
        }

        @Override
        public WithLongMapping withMapping(Ops.LongMapper mapper) {
            return new WithBoundedLongMapping(this.pa, this.firstIndex, this.upperBound, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        public WithDoubleMapping withMapping(Ops.MapperFromLongToDouble mapper) {
            return new WithBoundedDoubleMapping(this.pa, this.firstIndex, this.upperBound, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        public <U> WithMapping<U> withMapping(Ops.MapperFromLong<? extends U> mapper) {
            return new WithBoundedMapping<U>(this.pa, this.firstIndex, this.upperBound, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.LongProcedure procedure) {
            Ops.LongMapper mpr = this.mapper;
            long[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                procedure.apply(mpr.map(array[i]));
            }
        }

        @Override
        long leafReduce(int lo, int hi, Ops.LongReducer reducer, long base) {
            if (lo >= hi) {
                return base;
            }
            long[] array = this.pa.array;
            Ops.LongMapper mpr = this.mapper;
            long r = mpr.map(array[lo]);
            for (int i = lo + 1; i < hi; ++i) {
                r = reducer.combine(r, mpr.map(array[i]));
            }
            return r;
        }

        @Override
        void leafStats(int lo, int hi, PAS.FJLStats task) {
            task.size = hi - lo;
            long[] array = this.pa.array;
            Ops.LongMapper mpr = this.mapper;
            for (int i = lo; i < hi; ++i) {
                long x = mpr.map(array[i]);
                task.sum += x;
                task.updateMin(i, x);
                task.updateMax(i, x);
            }
        }

        @Override
        final void leafTransfer(int lo, int hi, long[] dest, int offset) {
            long[] array = this.pa.array;
            Ops.LongMapper mpr = this.mapper;
            for (int i = lo; i < hi; ++i) {
                dest[offset++] = mpr.map(array[i]);
            }
        }

        @Override
        final void leafTransferByIndex(int[] indices, int loIdx, int hiIdx, long[] dest, int offset) {
            long[] array = this.pa.array;
            Ops.LongMapper mpr = this.mapper;
            for (int i = loIdx; i < hiIdx; ++i) {
                dest[offset++] = mpr.map(array[indices[i]]);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class WithBoundedFilter
    extends WithFilter {
        final Ops.LongPredicate selector;

        WithBoundedFilter(ParallelLongArray pa, int firstIndex, int upperBound, Ops.LongPredicate selector) {
            super(pa, firstIndex, upperBound);
            this.selector = selector;
        }

        @Override
        public WithFilter withFilter(Ops.LongPredicate selector) {
            return new WithBoundedFilter(this.pa, this.firstIndex, this.upperBound, Ops.andPredicate(this.selector, selector));
        }

        @Override
        public WithFilter orFilter(Ops.LongPredicate selector) {
            return new WithBoundedFilter(this.pa, this.firstIndex, this.upperBound, Ops.orPredicate(this.selector, selector));
        }

        @Override
        public <U> WithMapping<U> withMapping(Ops.MapperFromLong<? extends U> mapper) {
            return new WithBoundedFilteredMapping<U>(this.pa, this.firstIndex, this.upperBound, this.selector, mapper);
        }

        @Override
        public WithLongMapping withMapping(Ops.LongMapper mapper) {
            return new WithBoundedFilteredLongMapping(this.pa, this.firstIndex, this.upperBound, this.selector, mapper);
        }

        @Override
        public WithDoubleMapping withMapping(Ops.MapperFromLongToDouble mapper) {
            return new WithBoundedFilteredDoubleMapping(this.pa, this.firstIndex, this.upperBound, this.selector, mapper);
        }

        @Override
        public int anyIndex() {
            AtomicInteger result = new AtomicInteger(-1);
            PAS.FJLSelectAny f = new PAS.FJLSelectAny(this, this.firstIndex, this.upperBound, null, result, this.selector);
            this.ex.invoke(f);
            return result.get();
        }

        @Override
        public ParallelLongArray all() {
            PAS.FJLSelectAllDriver r = new PAS.FJLSelectAllDriver(this);
            this.ex.invoke(r);
            return new ParallelLongArray(this.ex, r.results);
        }

        @Override
        public int size() {
            PAS.FJLCountSelected f = new PAS.FJLCountSelected(this, this.firstIndex, this.upperBound, null, this.selector);
            this.ex.invoke(f);
            return f.count;
        }

        @Override
        public ParallelLongArray allUniqueElements() {
            PAS.LUniquifierTable tab = new PAS.LUniquifierTable(this.upperBound - this.firstIndex, this.pa.array, this.selector);
            PAS.FJUniquifier f = new PAS.FJUniquifier(this, this.firstIndex, this.upperBound, null, tab);
            this.ex.invoke(f);
            long[] res = tab.uniqueElements(f.count);
            return new ParallelLongArray(this.ex, res);
        }

        @Override
        public void removeAll() {
            PAS.FJRemoveAllDriver f = new PAS.FJRemoveAllDriver(this, this.firstIndex, this.upperBound);
            this.ex.invoke(f);
            this.pa.removeSlotsAt(f.offset, this.upperBound);
        }

        @Override
        void leafApply(int lo, int hi, Ops.LongProcedure procedure) {
            Ops.LongPredicate sel = this.selector;
            long[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                long x = array[i];
                if (!sel.evaluate(x)) continue;
                procedure.apply(x);
            }
        }

        @Override
        long leafReduce(int lo, int hi, Ops.LongReducer reducer, long base) {
            Ops.LongPredicate sel = this.selector;
            boolean gotFirst = false;
            long r = base;
            long[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                long x = array[i];
                if (!sel.evaluate(x)) continue;
                if (!gotFirst) {
                    gotFirst = true;
                    r = x;
                    continue;
                }
                r = reducer.combine(r, x);
            }
            return r;
        }

        @Override
        void leafStats(int lo, int hi, PAS.FJLStats task) {
            Ops.LongPredicate sel = this.selector;
            long[] array = this.pa.array;
            int count = 0;
            for (int i = lo; i < hi; ++i) {
                long x = array[i];
                if (!sel.evaluate(x)) continue;
                ++count;
                task.sum += x;
                task.updateMin(i, x);
                task.updateMax(i, x);
            }
            task.size = count;
        }

        @Override
        void leafTransform(int lo, int hi, Ops.LongMapper mapper) {
            Ops.LongPredicate sel = this.selector;
            long[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                long x = array[i];
                if (!sel.evaluate(x)) continue;
                array[i] = mapper.map(x);
            }
        }

        @Override
        void leafIndexMap(int lo, int hi, Ops.MapperFromIntToLong mapper) {
            Ops.LongPredicate sel = this.selector;
            long[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                long x = array[i];
                if (!sel.evaluate(x)) continue;
                array[i] = mapper.map(i);
            }
        }

        @Override
        void leafGenerate(int lo, int hi, Ops.LongGenerator generator) {
            Ops.LongPredicate sel = this.selector;
            long[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                long x = array[i];
                if (!sel.evaluate(x)) continue;
                array[i] = generator.generate();
            }
        }

        @Override
        void leafFillValue(int lo, int hi, long value) {
            Ops.LongPredicate sel = this.selector;
            long[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                long x = array[i];
                if (!sel.evaluate(x)) continue;
                array[i] = value;
            }
        }

        @Override
        void leafCombineInPlace(int lo, int hi, long[] other, int otherOffset, Ops.LongReducer combiner) {
            Ops.LongPredicate sel = this.selector;
            long[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                long x = array[i];
                if (!sel.evaluate(x)) continue;
                array[i] = combiner.combine(x, other[i + otherOffset]);
            }
        }

        @Override
        int leafIndexSelected(int lo, int hi, boolean positive, int[] indices) {
            Ops.LongPredicate sel = this.selector;
            long[] array = this.pa.array;
            int k = 0;
            for (int i = lo; i < hi; ++i) {
                if (sel.evaluate(array[i]) != positive) continue;
                indices[lo + k++] = i;
            }
            return k;
        }

        @Override
        int leafMoveSelected(int lo, int hi, int offset, boolean positive) {
            Ops.LongPredicate sel = this.selector;
            long[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                long t = array[i];
                if (sel.evaluate(t) != positive) continue;
                array[offset++] = t;
            }
            return offset;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class WithBounds
    extends WithFilter {
        WithBounds(ParallelLongArray pa, int firstIndex, int upperBound) {
            super(pa, firstIndex, upperBound);
        }

        WithBounds(ParallelLongArray pa) {
            super(pa, 0, pa.limit);
        }

        public WithBounds withBounds(int firstIndex, int upperBound) {
            if (firstIndex > upperBound) {
                throw new IllegalArgumentException("firstIndex(" + firstIndex + ") > upperBound(" + upperBound + ")");
            }
            if (firstIndex < 0) {
                throw new ArrayIndexOutOfBoundsException(firstIndex);
            }
            if (upperBound - firstIndex > this.upperBound - this.firstIndex) {
                throw new ArrayIndexOutOfBoundsException(upperBound);
            }
            return new WithBounds(this.pa, this.firstIndex + firstIndex, this.firstIndex + upperBound);
        }

        @Override
        public WithFilter withFilter(Ops.LongPredicate selector) {
            return new WithBoundedFilter(this.pa, this.firstIndex, this.upperBound, selector);
        }

        @Override
        public <U> WithMapping<U> withMapping(Ops.MapperFromLong<? extends U> mapper) {
            return new WithBoundedMapping<U>(this.pa, this.firstIndex, this.upperBound, mapper);
        }

        @Override
        public WithLongMapping withMapping(Ops.LongMapper mapper) {
            return new WithBoundedLongMapping(this.pa, this.firstIndex, this.upperBound, mapper);
        }

        @Override
        public WithDoubleMapping withMapping(Ops.MapperFromLongToDouble mapper) {
            return new WithBoundedDoubleMapping(this.pa, this.firstIndex, this.upperBound, mapper);
        }

        @Override
        public WithFilter orFilter(Ops.LongPredicate selector) {
            return new WithBoundedFilter(this.pa, this.firstIndex, this.upperBound, selector);
        }

        @Override
        public int anyIndex() {
            return this.firstIndex < this.upperBound ? this.firstIndex : -1;
        }

        public ParallelLongArray combine(long[] other, Ops.LongReducer combiner) {
            int size = this.upperBound - this.firstIndex;
            if (other.length < size) {
                throw new ArrayIndexOutOfBoundsException();
            }
            long[] dest = new long[size];
            this.ex.invoke(new PAS.FJLCombine(this, this.firstIndex, this.upperBound, null, other, -this.firstIndex, dest, combiner));
            return new ParallelLongArray(this.ex, dest);
        }

        public ParallelLongArray combine(ParallelLongArray other, Ops.LongReducer combiner) {
            int size = this.upperBound - this.firstIndex;
            if (other.size() < size) {
                throw new ArrayIndexOutOfBoundsException();
            }
            long[] dest = new long[size];
            this.ex.invoke(new PAS.FJLCombine(this, this.firstIndex, this.upperBound, null, other.array, -this.firstIndex, dest, combiner));
            return new ParallelLongArray(this.ex, dest);
        }

        public <U, V> ParallelLongArray combine(WithBounds other, Ops.LongReducer combiner) {
            int size = this.upperBound - this.firstIndex;
            if (other.size() < size) {
                throw new ArrayIndexOutOfBoundsException();
            }
            long[] dest = new long[size];
            this.ex.invoke(new PAS.FJLCombine(this, this.firstIndex, this.upperBound, null, other.pa.array, other.firstIndex - this.firstIndex, dest, combiner));
            return new ParallelLongArray(this.ex, dest);
        }

        @Override
        public ParallelLongArray all() {
            long[] array = this.pa.array;
            int size = this.upperBound - this.firstIndex;
            long[] dest = new long[size];
            System.arraycopy(array, this.firstIndex, dest, 0, size);
            return new ParallelLongArray(this.ex, dest);
        }

        @Override
        public ParallelLongArray allUniqueElements() {
            PAS.LUniquifierTable tab = new PAS.LUniquifierTable(this.upperBound - this.firstIndex, this.pa.array, null);
            PAS.FJUniquifier f = new PAS.FJUniquifier(this, this.firstIndex, this.upperBound, null, tab);
            this.ex.invoke(f);
            long[] res = tab.uniqueElements(f.count);
            return new ParallelLongArray(this.ex, res);
        }

        public int indexOf(long target) {
            AtomicInteger result = new AtomicInteger(-1);
            PAS.FJLIndexOf f = new PAS.FJLIndexOf(this, this.firstIndex, this.upperBound, null, result, target);
            this.ex.invoke(f);
            return result.get();
        }

        public int binarySearch(long target) {
            long[] array = this.pa.array;
            int lo = this.firstIndex;
            int hi = this.upperBound - 1;
            while (lo <= hi) {
                int mid = lo + hi >>> 1;
                long m = array[mid];
                if (target == m) {
                    return mid;
                }
                if (target < m) {
                    hi = mid - 1;
                    continue;
                }
                lo = mid + 1;
            }
            return -1;
        }

        public int binarySearch(long target, Ops.LongComparator comparator) {
            long[] array = this.pa.array;
            int lo = this.firstIndex;
            int hi = this.upperBound - 1;
            while (lo <= hi) {
                int mid = lo + hi >>> 1;
                int c = comparator.compare(target, array[mid]);
                if (c == 0) {
                    return mid;
                }
                if (c < 0) {
                    hi = mid - 1;
                    continue;
                }
                lo = mid + 1;
            }
            return -1;
        }

        @Override
        public int size() {
            return this.upperBound - this.firstIndex;
        }

        public void cumulate(Ops.LongReducer reducer, long base) {
            PAS.FJLCumulateOp op = new PAS.FJLCumulateOp(this, reducer, base);
            PAS.FJLScan r = new PAS.FJLScan(null, op, this.firstIndex, this.upperBound);
            this.ex.invoke(r);
        }

        public void cumulateSum() {
            PAS.FJLCumulatePlusOp op = new PAS.FJLCumulatePlusOp(this);
            PAS.FJLScan r = new PAS.FJLScan(null, op, this.firstIndex, this.upperBound);
            this.ex.invoke(r);
        }

        public long precumulate(Ops.LongReducer reducer, long base) {
            PAS.FJLPrecumulateOp op = new PAS.FJLPrecumulateOp(this, reducer, base);
            PAS.FJLScan r = new PAS.FJLScan(null, op, this.firstIndex, this.upperBound);
            this.ex.invoke(r);
            return r.out;
        }

        public long precumulateSum() {
            PAS.FJLPrecumulatePlusOp op = new PAS.FJLPrecumulatePlusOp(this);
            PAS.FJLScan r = new PAS.FJLScan(null, op, this.firstIndex, this.upperBound);
            this.ex.invoke(r);
            return r.out;
        }

        public void sort(Ops.LongComparator cmp) {
            this.ex.invoke(new PAS.FJLSorter(cmp, this.pa.array, new long[this.upperBound], this.firstIndex, this.upperBound - this.firstIndex, this.threshold));
        }

        public void sort() {
            this.ex.invoke(new PAS.FJLCSorter(this.pa.array, new long[this.upperBound], this.firstIndex, this.upperBound - this.firstIndex, this.threshold));
        }

        @Override
        public void removeAll() {
            this.pa.removeSlotsAt(this.firstIndex, this.upperBound);
        }

        public void removeConsecutiveDuplicates() {
            int k = this.firstIndex;
            int n = this.upperBound;
            if (k < n) {
                long[] arr = this.pa.array;
                long last = arr[k++];
                for (int i = k; i < n; ++i) {
                    long x = arr[i];
                    if (last == x) continue;
                    arr[k++] = last = x;
                }
                this.pa.removeSlotsAt(k, n);
            }
        }

        @Override
        void leafApply(int lo, int hi, Ops.LongProcedure procedure) {
            long[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                procedure.apply(array[i]);
            }
        }

        @Override
        long leafReduce(int lo, int hi, Ops.LongReducer reducer, long base) {
            if (lo >= hi) {
                return base;
            }
            long[] array = this.pa.array;
            long r = array[lo];
            for (int i = lo + 1; i < hi; ++i) {
                r = reducer.combine(r, array[i]);
            }
            return r;
        }

        @Override
        void leafStats(int lo, int hi, PAS.FJLStats task) {
            long[] array = this.pa.array;
            task.size = hi - lo;
            for (int i = lo; i < hi; ++i) {
                long x = array[i];
                task.sum += x;
                task.updateMin(i, x);
                task.updateMax(i, x);
            }
        }

        @Override
        void leafTransform(int lo, int hi, Ops.LongMapper mapper) {
            long[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                array[i] = mapper.map(array[i]);
            }
        }

        @Override
        void leafIndexMap(int lo, int hi, Ops.MapperFromIntToLong mapper) {
            long[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                array[i] = mapper.map(i);
            }
        }

        @Override
        void leafGenerate(int lo, int hi, Ops.LongGenerator generator) {
            long[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                array[i] = generator.generate();
            }
        }

        @Override
        void leafFillValue(int lo, int hi, long value) {
            long[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                array[i] = value;
            }
        }

        @Override
        void leafCombineInPlace(int lo, int hi, long[] other, int otherOffset, Ops.LongReducer combiner) {
            long[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                array[i] = combiner.combine(array[i], other[i + otherOffset]);
            }
        }

        @Override
        void leafCombine(int lo, int hi, long[] other, int otherOffset, long[] dest, Ops.LongReducer combiner) {
            long[] array = this.pa.array;
            int k = lo - this.firstIndex;
            for (int i = lo; i < hi; ++i) {
                dest[k] = combiner.combine(array[i], other[i + otherOffset]);
                ++k;
            }
        }
    }

    public static abstract class WithFilter
    extends WithLongMapping {
        WithFilter(ParallelLongArray pa, int firstIndex, int upperBound) {
            super(pa, firstIndex, upperBound);
        }

        public void replaceWithTransform(Ops.LongMapper mapper) {
            this.ex.invoke(new PAS.FJLTransform(this, this.firstIndex, this.upperBound, null, mapper));
        }

        public void replaceWithMappedIndex(Ops.MapperFromIntToLong mapper) {
            this.ex.invoke(new PAS.FJLIndexMap(this, this.firstIndex, this.upperBound, null, mapper));
        }

        public void replaceWithGeneratedValue(Ops.LongGenerator generator) {
            this.ex.invoke(new PAS.FJLGenerate(this, this.firstIndex, this.upperBound, null, generator));
        }

        public void replaceWithValue(long value) {
            this.ex.invoke(new PAS.FJLFill(this, this.firstIndex, this.upperBound, null, value));
        }

        public void replaceWithCombination(ParallelLongArray other, Ops.LongReducer combiner) {
            if (other.size() < this.size()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            this.ex.invoke(new PAS.FJLCombineInPlace(this, this.firstIndex, this.upperBound, null, other.array, 0, combiner));
        }

        public void replaceWithCombination(WithBounds other, Ops.LongReducer combiner) {
            if (other.size() < this.size()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            this.ex.invoke(new PAS.FJLCombineInPlace(this, this.firstIndex, this.upperBound, null, other.pa.array, other.firstIndex - this.firstIndex, combiner));
        }

        public void replaceWithCombination(long[] other, Ops.LongReducer combiner) {
            if (other.length < this.size()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            this.ex.invoke(new PAS.FJLCombineInPlace(this, this.firstIndex, this.upperBound, null, other, -this.firstIndex, combiner));
        }

        public abstract void removeAll();

        public abstract ParallelLongArray allUniqueElements();

        public abstract WithFilter withFilter(Ops.LongPredicate var1);

        public abstract WithFilter orFilter(Ops.LongPredicate var1);

        final void leafTransfer(int lo, int hi, long[] dest, int offset) {
            long[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                dest[offset++] = array[i];
            }
        }

        final void leafTransferByIndex(int[] indices, int loIdx, int hiIdx, long[] dest, int offset) {
            long[] array = this.pa.array;
            for (int i = loIdx; i < hiIdx; ++i) {
                dest[offset++] = array[indices[i]];
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class WithLongMapping
    extends PAS.LPrefix {
        WithLongMapping(ParallelLongArray pa, int firstIndex, int upperBound) {
            super(pa, firstIndex, upperBound);
        }

        public void apply(Ops.LongProcedure procedure) {
            this.ex.invoke(new PAS.FJLApply(this, this.firstIndex, this.upperBound, null, procedure));
        }

        public long reduce(Ops.LongReducer reducer, long base) {
            PAS.FJLReduce f = new PAS.FJLReduce(this, this.firstIndex, this.upperBound, null, reducer, base);
            this.ex.invoke(f);
            return f.result;
        }

        public long min() {
            return this.reduce(Ops.naturalLongMinReducer(), Long.MAX_VALUE);
        }

        public long min(Ops.LongComparator comparator) {
            return this.reduce(Ops.longMinReducer(comparator), Long.MAX_VALUE);
        }

        public long max() {
            return this.reduce(Ops.naturalLongMaxReducer(), Long.MIN_VALUE);
        }

        public long max(Ops.LongComparator comparator) {
            return this.reduce(Ops.longMaxReducer(comparator), Long.MIN_VALUE);
        }

        public long sum() {
            return this.reduce(Ops.longAdder(), 0L);
        }

        public SummaryStatistics summary(Ops.LongComparator comparator) {
            PAS.FJLStats f = new PAS.FJLStats(this, this.firstIndex, this.upperBound, null, comparator);
            this.ex.invoke(f);
            return f;
        }

        public SummaryStatistics summary() {
            PAS.FJLStats f = new PAS.FJLStats(this, this.firstIndex, this.upperBound, null, Ops.naturalLongComparator());
            this.ex.invoke(f);
            return f;
        }

        public abstract ParallelLongArray all();

        public abstract int size();

        public abstract int anyIndex();

        public abstract WithLongMapping withMapping(Ops.LongMapper var1);

        public abstract WithDoubleMapping withMapping(Ops.MapperFromLongToDouble var1);

        public abstract <U> WithMapping<U> withMapping(Ops.MapperFromLong<? extends U> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class WithBoundedFilteredMapping<U>
    extends WithMapping<U> {
        final Ops.LongPredicate selector;

        WithBoundedFilteredMapping(ParallelLongArray pa, int firstIndex, int upperBound, Ops.LongPredicate selector, Ops.MapperFromLong<? extends U> mapper) {
            super(pa, firstIndex, upperBound, mapper);
            this.selector = selector;
        }

        @Override
        public ParallelArray<U> all() {
            PAS.FJRSelectAllDriver r = new PAS.FJRSelectAllDriver(this, Object.class);
            this.ex.invoke(r);
            return new ParallelArray<Object>(this.ex, r.results);
        }

        @Override
        public ParallelArray<U> all(Class<? super U> elementType) {
            PAS.FJRSelectAllDriver r = new PAS.FJRSelectAllDriver(this, elementType);
            this.ex.invoke(r);
            return new ParallelArray<Object>(this.ex, r.results);
        }

        @Override
        public int size() {
            PAS.FJLCountSelected f = new PAS.FJLCountSelected(this, this.firstIndex, this.upperBound, null, this.selector);
            this.ex.invoke(f);
            return f.count;
        }

        @Override
        public int anyIndex() {
            AtomicInteger result = new AtomicInteger(-1);
            PAS.FJLSelectAny f = new PAS.FJLSelectAny(this, this.firstIndex, this.upperBound, null, result, this.selector);
            this.ex.invoke(f);
            return result.get();
        }

        @Override
        public U any() {
            int idx = this.anyIndex();
            long[] array = this.pa.array;
            Ops.MapperFromLong mpr = this.mapper;
            return idx < 0 ? null : (U)mpr.map(array[idx]);
        }

        @Override
        public <V> WithMapping<V> withMapping(Ops.Mapper<? super U, ? extends V> mapper) {
            return new WithBoundedFilteredMapping<V>(this.pa, this.firstIndex, this.upperBound, this.selector, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        public WithLongMapping withMapping(Ops.MapperToLong<? super U> mapper) {
            return new WithBoundedFilteredLongMapping(this.pa, this.firstIndex, this.upperBound, this.selector, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        public WithDoubleMapping withMapping(Ops.MapperToDouble<? super U> mapper) {
            return new WithBoundedFilteredDoubleMapping(this.pa, this.firstIndex, this.upperBound, this.selector, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.Procedure procedure) {
            Ops.LongPredicate sel = this.selector;
            Ops.MapperFromLong mpr = this.mapper;
            long[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                long x = array[i];
                if (!sel.evaluate(x)) continue;
                procedure.apply(mpr.map(x));
            }
        }

        @Override
        Object leafReduce(int lo, int hi, Ops.Reducer reducer, Object base) {
            Ops.LongPredicate sel = this.selector;
            Ops.MapperFromLong mpr = this.mapper;
            boolean gotFirst = false;
            Object r = base;
            long[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                long x = array[i];
                if (!sel.evaluate(x)) continue;
                Object y = mpr.map(x);
                if (!gotFirst) {
                    gotFirst = true;
                    r = y;
                    continue;
                }
                r = reducer.combine(r, y);
            }
            return r;
        }

        @Override
        void leafStats(int lo, int hi, PAS.FJRStats task) {
            Ops.LongPredicate sel = this.selector;
            Ops.MapperFromLong mpr = this.mapper;
            long[] array = this.pa.array;
            int count = 0;
            for (int i = lo; i < hi; ++i) {
                long t = array[i];
                if (!sel.evaluate(t)) continue;
                Object x = mpr.map(t);
                ++count;
                task.updateMin(i, x);
                task.updateMax(i, x);
            }
            task.size = count;
        }

        @Override
        int leafIndexSelected(int lo, int hi, boolean positive, int[] indices) {
            Ops.LongPredicate sel = this.selector;
            long[] array = this.pa.array;
            int k = 0;
            for (int i = lo; i < hi; ++i) {
                if (sel.evaluate(array[i]) != positive) continue;
                indices[lo + k++] = i;
            }
            return k;
        }

        @Override
        int leafMoveSelected(int lo, int hi, int offset, boolean positive) {
            Ops.LongPredicate sel = this.selector;
            long[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                long t = array[i];
                if (sel.evaluate(t) != positive) continue;
                array[offset++] = t;
            }
            return offset;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class WithBoundedMapping<U>
    extends WithMapping<U> {
        WithBoundedMapping(ParallelLongArray pa, int firstIndex, int upperBound, Ops.MapperFromLong<? extends U> mapper) {
            super(pa, firstIndex, upperBound, mapper);
        }

        @Override
        public ParallelArray<U> all() {
            int n = this.upperBound - this.firstIndex;
            Object[] dest = new Object[n];
            PAS.FJRMap f = new PAS.FJRMap(this, this.firstIndex, this.upperBound, null, dest, this.firstIndex);
            this.ex.invoke(f);
            return new ParallelArray<Object>(this.ex, dest);
        }

        @Override
        public ParallelArray<U> all(Class<? super U> elementType) {
            int n = this.upperBound - this.firstIndex;
            Object[] dest = (Object[])Array.newInstance(elementType, n);
            PAS.FJRMap f = new PAS.FJRMap(this, this.firstIndex, this.upperBound, null, dest, this.firstIndex);
            this.ex.invoke(f);
            return new ParallelArray<Object>(this.ex, dest);
        }

        @Override
        public int size() {
            return this.upperBound - this.firstIndex;
        }

        @Override
        public int anyIndex() {
            return this.firstIndex < this.upperBound ? this.firstIndex : -1;
        }

        @Override
        public U any() {
            Ops.MapperFromLong mpr = this.mapper;
            long[] array = this.pa.array;
            return this.firstIndex < this.upperBound ? (U)mpr.map(array[this.firstIndex]) : null;
        }

        @Override
        public <V> WithMapping<V> withMapping(Ops.Mapper<? super U, ? extends V> mapper) {
            return new WithBoundedMapping<V>(this.pa, this.firstIndex, this.upperBound, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        public WithLongMapping withMapping(Ops.MapperToLong<? super U> mapper) {
            return new WithBoundedLongMapping(this.pa, this.firstIndex, this.upperBound, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        public WithDoubleMapping withMapping(Ops.MapperToDouble<? super U> mapper) {
            return new WithBoundedDoubleMapping(this.pa, this.firstIndex, this.upperBound, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.Procedure procedure) {
            long[] array = this.pa.array;
            Ops.MapperFromLong mpr = this.mapper;
            for (int i = lo; i < hi; ++i) {
                procedure.apply(mpr.map(array[i]));
            }
        }

        @Override
        Object leafReduce(int lo, int hi, Ops.Reducer reducer, Object base) {
            if (lo >= hi) {
                return base;
            }
            long[] array = this.pa.array;
            Ops.MapperFromLong mpr = this.mapper;
            Object r = mpr.map(array[lo]);
            for (int i = lo + 1; i < hi; ++i) {
                r = reducer.combine(r, mpr.map(array[i]));
            }
            return r;
        }

        @Override
        void leafStats(int lo, int hi, PAS.FJRStats task) {
            long[] array = this.pa.array;
            Ops.MapperFromLong mpr = this.mapper;
            task.size = hi - lo;
            for (int i = lo; i < hi; ++i) {
                Object x = mpr.map(array[i]);
                task.updateMin(i, x);
                task.updateMax(i, x);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class WithMapping<U>
    extends PAS.LPrefix {
        final Ops.MapperFromLong<? extends U> mapper;

        WithMapping(ParallelLongArray pa, int firstIndex, int upperBound, Ops.MapperFromLong<? extends U> mapper) {
            super(pa, firstIndex, upperBound);
            this.mapper = mapper;
        }

        public void apply(Ops.Procedure<? super U> procedure) {
            this.ex.invoke(new PAS.FJRApply(this, this.firstIndex, this.upperBound, null, procedure));
        }

        public U reduce(Ops.Reducer<U> reducer, U base) {
            PAS.FJRReduce f = new PAS.FJRReduce(this, this.firstIndex, this.upperBound, null, reducer, base);
            this.ex.invoke(f);
            return (U)f.result;
        }

        public abstract int anyIndex();

        public abstract U any();

        public U min(Comparator<? super U> comparator) {
            return this.reduce(Ops.minReducer(comparator), null);
        }

        public U min() {
            return this.reduce(Ops.castedMinReducer(), null);
        }

        public U max(Comparator<? super U> comparator) {
            return this.reduce(Ops.maxReducer(comparator), null);
        }

        public U max() {
            return this.reduce(Ops.castedMaxReducer(), null);
        }

        public ParallelArray.SummaryStatistics<U> summary(Comparator<? super U> comparator) {
            PAS.FJRStats f = new PAS.FJRStats(this, this.firstIndex, this.upperBound, null, comparator);
            this.ex.invoke(f);
            return f;
        }

        public ParallelArray.SummaryStatistics<U> summary() {
            PAS.FJRStats f = new PAS.FJRStats(this, this.firstIndex, this.upperBound, null, Ops.castedComparator());
            this.ex.invoke(f);
            return f;
        }

        public abstract ParallelArray<U> all();

        public abstract ParallelArray<U> all(Class<? super U> var1);

        public abstract int size();

        public abstract <V> WithMapping<V> withMapping(Ops.Mapper<? super U, ? extends V> var1);

        public abstract WithLongMapping withMapping(Ops.MapperToLong<? super U> var1);

        public abstract WithDoubleMapping withMapping(Ops.MapperToDouble<? super U> var1);

        @Override
        final void leafTransfer(int lo, int hi, Object[] dest, int offset) {
            long[] array = this.pa.array;
            Ops.MapperFromLong<U> mpr = this.mapper;
            for (int i = lo; i < hi; ++i) {
                dest[offset++] = mpr.map(array[i]);
            }
        }

        @Override
        final void leafTransferByIndex(int[] indices, int loIdx, int hiIdx, Object[] dest, int offset) {
            long[] array = this.pa.array;
            Ops.MapperFromLong<U> mpr = this.mapper;
            for (int i = loIdx; i < hiIdx; ++i) {
                dest[offset++] = mpr.map(array[indices[i]]);
            }
        }
    }

    public static interface SummaryStatistics {
        public int size();

        public long min();

        public long max();

        public int indexOfMin();

        public int indexOfMax();

        public long sum();

        public double average();
    }
}

