/*
 * #%L
 * Pollen :: Vote Counting
 * 
 * $Id: Group.java 3122 2012-01-30 20:43:30Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3.1/pollen-votecounting/src/main/java/org/chorem/pollen/votecounting/business/Group.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.votecounting.business;

import java.util.ArrayList;
import java.util.List;

import org.chorem.pollen.votecounting.utils.ListBehavior;

/**
 * Cette classe décrit un groupe du sondage. Sa valeur dépend du choix et sera
 * calculée au moment du dépouillement.
 *
 * @author fdesbois
 * @version $Id: Group.java 3122 2012-01-30 20:43:30Z tchemit $
 */
public class Group implements ListBehavior<Vote> {
    /**
     * Identifiant du groupe
     */
    private String idGroup;
    /**
     * Poids du groupe
     */
    private double weight;
    /**
     * Valeur du groupe pour le choix dans lequel il appartient
     */
    private double value;
    /**
     * Liste des votes liés au groupe
     */
    private List<Vote> votes;

    /**
     * Constructeur
     *
     * @param id : identifiant du groupe
     * @param weight : poids du groupe
     */
    public Group(String id, double weight) {
        this.idGroup = id;
        this.weight = weight;
        this.value = 0.;
        this.votes = new ArrayList<Vote>();
    }

    /**
     * getIdGroup : Identifiant du groupe
     *
     * @return identifiant du groupe
     */
    public String getIdGroup() {
        return this.idGroup;
    }

    /**
     * getWeight : Renvoie le poids du groupe
     *
     * @return poids du groupe
     */
    public double getWeight() {
        return this.weight;
    }

    /**
     * setValue : Mise à jour de la valeur du groupe
     *
     * @param value : nouvelle valeur du groupe
     */
    public void setValue(double value) {
        this.value = value;
    }

    /**
     * getValue : Renvoie la valeur du groupe pour le choix auquel il appartient
     *
     * @return la valeur du groupe
     */
    public double getValue() {
        return this.value;
    }

    /**
     * getVotes : Renvoie la liste des votes liés au groupe
     *
     * @return liste des votes
     */
    public List<Vote> getVotes() {
        return this.votes;
    }

    /**
     * addVote : Ajout d'un nouveau vote au groupe
     *
     * @param value : valeur du vote
     * @param weight : poids du vote
     */
    public void addVote(double value, double weight, String votingID) {
        this.votes.add(new Vote(value, weight, votingID));
    }

    @Override
    public List<Vote> list() {
        return getVotes();
    }
}