<%--
  #%L
  Pollen :: UI (strust2)
  
  $Id: vote.jsp 3396 2012-05-28 16:10:06Z tchemit $
  $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3.1.1/pollen-ui-struts2/src/main/webapp/WEB-INF/jsp/poll/vote.jsp $
  %%
  Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@page contentType="text/html" pageEncoding="UTF-8" %>
<%@ taglib prefix="s" uri="/struts-tags" %>
<%@ taglib prefix="sj" uri="/struts-jquery-tags" %>

<title><s:property value="%{poll.title}"/></title>

<link rel="stylesheet" type="text/css"
      href="<s:url value='/css/vote.css'/>"/>

<script type="text/javascript"
        src="<s:url value='/js/gridHelper.js' />"></script>

<s:set id='deleteCommentTitle'>
  <s:text name="pollen.title.delete.pollComment"/>
</s:set>
<s:set id='deleteCommentVote'>
  <s:text name="pollen.title.delete.pollVote"/>
</s:set>
<s:set id='deleteCommentChoice'>
  <s:text name="pollen.title.delete.pollChoice"/>
</s:set>

<script type="text/javascript">

  function openConfirmDialog(title, url) {
    $('.ui-dialog-title').html(title);
    var dialog = $("#confirmDialog");
    dialog.html('');
    dialog.load(url);
    dialog.dialog('open');
    return false;
  }
  function closeConfirmDialog() {
    $('#confirmDialog').dialog('close');
    return false;
  }

  function openDeleteCommentDialog(commentId) {
    return openConfirmDialog(
      "<s:property value='%{deleteCommentTitle}'/>",
      $.prepareUrl("<s:url action='confirmDeleteComment' namespace='/poll'/>",
                   { uriId:"<s:property value='%{uriId}'/>",
                     commentId:commentId})
    );
  }

  function openDeleteVoteDialog(voteId) {
    return openConfirmDialog(
      "<s:property value='%{deleteCommentVote}'/>",
      $.prepareUrl("<s:url action='confirmDeleteVote' namespace='/poll'/>",
                   {uriId:"<s:property value='%{uriId}'/>",
                     voteId:voteId})
    );
  }

  function openDeleteChoiceDialog(choiceId) {
    return openConfirmDialog(
      "<s:property value='%{deleteCommentChoice}'/>",
      $.prepareUrl("<s:url action='confirmDeleteChoice' namespace='/poll'/>",
                   {uriId:"<s:property value='%{uriId}'/>",
                     choiceId:choiceId})
    );
  }

  jQuery(document).ready(function () {

    $('#poll tr:even').addClass('even');

    var $anonymousField = $('#voteForm [name="vote.anonymous"]');
    var $votingIdField = $('#voteForm [name="pollAccount.votingId"]');

    $votingIdField.attr('disabled', $anonymousField.prop('checked'));

    $anonymousField.change(function() {
      $votingIdField.attr('disabled', $(this).prop('checked'));
    });

  });

</script>

<h1 class="titleVote"><s:property value="poll.title"/></h1>

<!-- Informations sur le sondage -->

<div id="pollTop">
  <div style="white-space:pre-wrap; text-align: start;">
    <s:property value="poll.description"/>
  </div>
  <fieldset>
    <legend><s:text name="pollen.common.aboutPoll"/></legend>
    <div style="float: right">
      <s:if test="poll.publicResults">

        <s:a namespace="/poll" action="results/%{uriId}">
          <img src="<s:url value='/img/count.png'/>"
               title="<s:text name="pollen.common.vote.results-help"/>"
               alt="<s:text name="pollen.common.vote.results"/>"/>
        </s:a>
      </s:if>
      <s:if test="feedFileExisting">
        <s:a namespace="/poll" action="getFeed">
          <s:param name="pollId" value="poll.pollId"/>
          <img src="<s:url value='/img/feed.png'/>" title="Atom" alt="Atom"/>
        </s:a>
      </s:if>
    </div>
    <s:label value="%{creatorName}" key='pollen.common.pollCreator'/>
    <s:label value="%{poll.beginDate}" key='pollen.common.beginDate'/>
    <s:label value="%{poll.endDate}" key='pollen.common.endDate'/>
    <s:label value="%{poll.voteCountingType}"
             label='%{getText("pollen.common.voteCountingType")}'
             tooltip="%{getVoteCountingTypeHelp(poll.voteCountingType)}"
             tooltipIconPath="/img/tooltip.png"/>
  </fieldset>
</div>

<div id="pollZone">
<s:if test="pollChoiceOrVoteStarted">

<!-- Sondage -->

<s:if test="poll.anonymous">
  <p>
    <s:text name="pollen.common.voteNbVotes">
      <s:param><s:property value="%{poll.sizeVote()}"/></s:param>
    </s:text>
  </p>
  <%--<t:feedback t:id="voteFeedback"/>--%>
</s:if>
<s:else>
  <div class="p-pager">
    <s:property value="%{voteSizeMessage}"/>
  </div>
  <%--TODO Do me pager !--%>
  <%--<t:pager t:nbRowsPerPage="nbVotesPerPage" t:nbTotalRows="poll.nbVotes"--%>
  <%--t:currentPage="page" t:noPagerText="prop:noPagerText"/>--%>
</s:else>

<s:form id="voteForm" validate="true">
<s:hidden key="uriId" label=''/>
<table id="poll">
<thead>
<tr>
  <s:if test="accountFieldDisplayed">
    <th style="width:200px;">
      <s:text name="pollen.common.voterName"/>
    </th>
  </s:if>
  <s:else>
    <th></th>
  </s:else>
  <s:if test="textType">
    <s:iterator value="poll.choice" var="choice">
      <s:if test="!isChoiceHidden(#choice)">
        <th>
          <s:if test="!isDescNull(#choice)">

            <span
              title='<s:property value="escapeLineBreak(#choice.description)"/>'>
                <s:property value="name"/>
            </span>
          </s:if>
          <s:else>
            <s:property value="name"/>
          </s:else>
          <s:if test="pollChoiceRunning">
            <s:if test="creatorUser">
              <s:a action="deleteChoice" namespace="/poll"
                   onclick="return openDeleteChoiceDialog('%{#choice.topiaId}');">
                <s:param name="choiceId"><s:property value="id"/></s:param>
                <img src="<s:url value="/img/delete.png"/>"
                     title="<s:text name="pollen.action.deleteChoice"/>"
                     alt="<s:text name="pollen.action.deleteChoice"/>"/>
              </s:a>
            </s:if>
          </s:if>
        </th>
      </s:if>
    </s:iterator>
  </s:if>

  <s:if test="dateType">
    <s:iterator value="poll.choice" var="choice">
      <s:if test="!isChoiceHidden(#choice)">
        <s:if test="!isDescNull(#choice)">

          <th class="desc">
            <span
              title='<s:property value="escapeLineBreak(#choice.description)"/>'>
                <s:property value="%{getChoiceAsDate(#choice)}"/>
            </span>
          </th>
        </s:if>
        <s:else>
          <th>
            <s:property value="%{getChoiceAsDate(#choice)}"/>
          </th>
        </s:else>
      </s:if>
    </s:iterator>
  </s:if>

  <s:if test="imageType">
    <s:iterator value="poll.choice" var="choice">
      <s:if test="!isChoiceHidden(#choice)">
        <s:url id="imageUrl" namespace="/io"
               action="getPollChoiceImage"
               escapeAmp="false">
          <s:param name="choiceId" value="name"/>
          <s:param name="pollId" value="poll.pollId"/>
          <s:param name="thumb" value="true"/>
        </s:url>
        <s:if test="!isDescNull(#choice)">

          <th class="desc">

            <img alt="<s:property value='name'/>"
                 title='<s:property value="escapeLineBreak(#choice.description)"/>'
                 src="<s:property value='imageUrl'/>">
          </th>
        </s:if>
        <s:else>
          <th>
            <img alt="<s:property value='name'/>"
                 title='<s:property value="escapeLineBreak(#choice.description)"/>'
                 src="<s:property value='imageUrl'/>">
          </th>
        </s:else>
      </s:if>
    </s:iterator>
  </s:if>
</tr>
</thead>
<s:if test="voteAllowed">
  <tfoot>
  <tr>
    <s:if test="accountFieldDisplayed">
      <th id="voterName">
        <s:textfield key='pollAccount.votingId' required="true" label=''
                     value="%{pollAccount.votingId}" theme="simple"/>
      </th>
    </s:if>
    <s:else>
      <th></th>
    </s:else>
    <s:iterator value="poll.choice" var="choice" status="status">

      <s:if test="!isChoiceHidden(#choice)">
        <th>
          <s:if test="normalVoteCounting">
            <s:checkbox
              name="vote.choiceVoteToChoice[%{#status.index}].voteValue"
              value="%{vote.choiceVoteToChoice[#status.index].voteValue}"
              theme="simple"/>
          </s:if>
          <s:if test="percentageVoteCounting">
            <s:textfield
              name="vote.choiceVoteToChoice[%{#status.index}].voteValue"
              value="%{vote.choiceVoteToChoice[#status.index].voteValue}"
              required="true" size="3" theme="simple"/>
          </s:if>
          <s:if test="condorcetVoteCounting">
            <s:textfield
              name="vote.choiceVoteToChoice[%{#status.index}].voteValue"
              value="%{vote.choiceVoteToChoice[#status.index].voteValue}"
              id="condorcetInput" size="3" theme="simple"/>
          </s:if>
          <s:if test="numberVoteCounting">
            <s:textfield
              name="vote.choiceVoteToChoice[%{#status.index}].voteValue"
              value="%{vote.choiceVoteToChoice[#status.index].voteValue}"
              size="3" theme="simple"/>
          </s:if>
        </th>
      </s:if>
    </s:iterator>
  </tr>
  </tfoot>
</s:if>
<tbody>
<s:if test="!poll.anonymous">
  <s:iterator value="votes" var="vote">
    <tr>
      <td>
        <s:if test="accountFieldDisplayed">
          <s:if test="!#vote.anonymous">
            <s:property value="pollAccount.votingId"/>
          </s:if>
          <s:else>
            ?
          </s:else>
        </s:if>
        <s:if test="!poll.anonymous">
          <s:if test="isModifAllowed(#vote)">
            <s:a action="editVote" namespace="/poll">
              <s:param name="pollId" value="%{pollId}"/>
              <s:param name="accountId" value="%{#vote.pollAccount.accountId}"/>
              <img src="<s:url value="/img/editSmall.png"/>"
                   title="<s:text name="pollen.action.editVote"/>"
                   alt="<s:text name="pollen.action.editVote"/>"/>
            </s:a>
          </s:if>
          <s:if test="isDeleteVoteAllowed(#vote)">
            <s:a action="deleteVote" namespace="/poll" href="#"
                 onclick="return openDeleteVoteDialog('%{#vote.topiaId}');">
              <img src="<s:url value="/img/delete.png"/>"
                   title="<s:text name="pollen.action.deleteVote"/>"
                   alt="<s:text name="pollen.action.deleteVote"/>"/>
            </s:a>
          </s:if>
        </s:if>
      </td>
      <s:iterator value="poll.choice" var="choice">
        <s:if test="!isChoiceHidden(#choice)">
          <s:set name="currentVoteChoice"
                 value="%{#vote.getChoiceVoteToChoice(#choice)}"/>
          <s:if test="poll.anonymous">
            <td class="anonymous">?</td>
          </s:if>
          <s:else>
            <s:if test="normalVoteCounting">
              <s:if test="isChoiceInVote(#currentVoteChoice)">
                <td class="voted">OK</td>
              </s:if>
              <s:else>
                <td class="notVoted"></td>
              </s:else>
            </s:if>
            <s:if test="percentageVoteCounting">
              <s:if test="isChoiceInVote(#currentVoteChoice)">
                <td class="voted">
                  <s:property value="%{#currentVoteChoice.voteValue}"/> %
                </td>
              </s:if>
              <s:else>
                <td class="notVoted"></td>
              </s:else>
            </s:if>
            <s:if test="condorcetVoteCounting">
              <s:if test="isChoiceInVote(#currentVoteChoice)">
                <td class="voted">
                  <s:property value="%{#currentVoteChoice.voteValue}"/>
                </td>
              </s:if>
              <s:else>
                <td class="notVoted"></td>
              </s:else>
            </s:if>
            <s:if test="numberVoteCounting">
              <s:if test="isChoiceInVote(#currentVoteChoice)">
                <td class="voted">
                  <s:property value="%{#currentVoteChoice.voteValue}"/>
                </td>
              </s:if>
              <s:else>
                <td class="notVoted"></td>
              </s:else>
            </s:if>
          </s:else>
        </s:if>
      </s:iterator>
    </tr>
  </s:iterator>
</s:if>
<s:if test="poll.continuousResults">
  <tr>
    <td>
      <s:a namespace="/poll" action="results/%{poll.pollId}">
        <s:text name="pollen.common.vote.results"/>
      </s:a>
    </td>

    <s:iterator value="poll.choice" var="choice">
      <s:if test="!isChoiceHidden(#choice)">
        <td class="result">
          <s:property value="%{getResultValue(#choice)}"/>
        </td>
      </s:if>
    </s:iterator>
  </tr>
</s:if>
</tbody>
</table>
<div id="voteError">
  <s:fielderror fieldName="pollAccount.votingId"/>
  <s:fielderror fieldName="vote.choices"/>
</div>

<s:if test="voteAllowed">
  <div id="buttons">
    <s:if test="poll.anonymousVoteAllowed">
      <s:checkbox key="vote.anonymous"/>
      <br/>
    </s:if>
    <s:submit action="vote/%{uriId}" key="pollen.action.pollVote"
              align="center"/>
  </div>
</s:if>
</s:form>
</div>

<!-- Ajout de choix -->
<s:if test="pollChoiceRunning">
  <div id="choiceFormDiv">
    <s:form id="choiceForm" method="POST" namespace="/poll"
            enctype="multipart/form-data">
      <h4><s:text name="pollen.action.addChoice"/></h4>
      <s:if test="textType">
        <s:textfield key="choice.name"
                     label="%{getText('pollen.common.choice')}"
                     required="true"/>
      </s:if>
      <s:elseif test="dateType">
        <sj:datepicker key="choice.date"
                       label="%{getText('pollen.common.choice')}"
                       changeMonth="true" changeYear="true"
                       timepicker="true"
                       displayFormat="%{getText('pollen.common.datePickerPattern')}"
                       required="true"/>
      </s:elseif>
      <s:elseif test="imageType">
        <s:file key="imageChoice[0]"
                label="%{getText('pollen.common.choice')}"
                cssClass="nameField"
                required="true"/>
      </s:elseif>
      <br/>
      <s:textarea cols="36" key="choice.description"
                  label="%{getText('pollen.common.description')}"/>
      <br/>
      <s:submit action="addChoice/%{uriId}" key="pollen.action.addChoice"
                align="center"/>
    </s:form>
  </div>
</s:if>

<!-- Ajout de commentaires -->
<h3><s:text name="pollen.common.comments"/></h3>

<div id="commentZone">

  <%--Show paginated comments--%>
  <%@include file="displayPollComments.jsp" %>

  <div id="commentFormDiv">

    <s:form id='addCommentForm' method="POST" namespace="/poll" validate="true">
      <s:textfield key="commentAuthor" required="true" size="78"
                   label="%{getText('pollen.common.commentAuthor')}"/>
      <s:textarea key="commentText" required="true" value=''
                  label="%{getText('pollen.common.commentText')}"/>

      <div class="cleanBoth">
        <s:submit action="addComment/%{uriId}" key="pollen.action.addComment"
                  align="center"/>
      </div>
    </s:form>

  </div>

  <sj:dialog id="confirmDialog" resizable="false" autoOpen="false" modal="true"
             width="800"/>
</div>
</s:if>