/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.json;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.chorem.pollen.business.persistence.PersonList;
import org.chorem.pollen.services.impl.FavoriteService;
import org.chorem.pollen.ui.actions.json.AbstractJSONPaginedAction;

public class GetFavoriteLists
extends AbstractJSONPaginedAction {
    private static final long serialVersionUID = 1L;
    protected transient Map<String, Object>[] favoriteLists;

    public Map<String, Object>[] getFavoriteLists() {
        return this.favoriteLists;
    }

    public Integer getRows() {
        return this.pager.getPageSize();
    }

    public Integer getPage() {
        return this.pager.getPageIndex();
    }

    public Integer getTotal() {
        return this.pager.getPagesNumber();
    }

    public Integer getRecords() {
        return this.pager.getRecords();
    }

    public String execute() throws Exception {
        FavoriteService service = (FavoriteService)this.newService(FavoriteService.class);
        List allFavoriteLists = service.getFavoriteLists(this.getPollenUserAccount(), this.pager);
        this.favoriteLists = new Map[allFavoriteLists.size()];
        int index = 0;
        for (PersonList favoriteList : allFavoriteLists) {
            HashMap map = Maps.newHashMap();
            map.put("name", favoriteList.getName());
            map.put("id", favoriteList.getTopiaId());
            map.put("nbAccounts", favoriteList.sizePollAccount());
            this.favoriteLists[index++] = map;
        }
        return "success";
    }
}

