/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.bean;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.collections4.CollectionUtils;
import org.chorem.pollen.persistence.PollenEntity;
import org.chorem.pollen.services.bean.PaginationResultBean;
import org.chorem.pollen.services.bean.PollenBean;
import org.nuiton.util.pagination.PaginationOrder;
import org.nuiton.util.pagination.PaginationResult;

public class PollenBeans {
    public static <E extends PollenEntity, B extends PollenBean<E>> PaginationResultBean<B> toBean(PaginationResult<E> entities, Function<E, B> beanFunction) {
        ImmutableList<B> bs = PollenBeans.toBeanList(entities.getElements(), beanFunction);
        PaginationResultBean<B> result = new PaginationResultBean<B>();
        result.setElements((List<B>)bs);
        result.setPageSize(entities.getCurrentPage().getPageSize());
        result.setCurrentPage(entities.getCurrentPage().getPageNumber());
        result.setLastPage(entities.getLastPage().getPageNumber());
        result.setCount(entities.getCount());
        List orderClauses = entities.getCurrentPage().getOrderClauses();
        if (CollectionUtils.isNotEmpty((Collection)orderClauses)) {
            PaginationOrder paginationOrder = (PaginationOrder)orderClauses.get(0);
            result.setOrder(paginationOrder.getClause());
            result.setDesc(paginationOrder.isDesc());
        }
        return result;
    }

    public static <E extends PollenEntity, B extends PollenBean<E>> ImmutableSet<B> toBeanSet(Collection<E> entities, Function<E, B> beanFunction) {
        return (ImmutableSet)entities.stream().map(beanFunction).collect(ImmutableSet.toImmutableSet());
    }

    public static <E extends PollenEntity, B extends PollenBean<E>> ImmutableList<B> toBeanList(Collection<E> entities, Function<E, B> beanFunction) {
        return (ImmutableList)entities.stream().map(beanFunction).collect(ImmutableList.toImmutableList());
    }
}

