/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.bean;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.chorem.pollen.persistence.entity.CommentVisibility;
import org.chorem.pollen.persistence.entity.Poll;
import org.chorem.pollen.persistence.entity.PollType;
import org.chorem.pollen.persistence.entity.ResultPresentation;
import org.chorem.pollen.persistence.entity.ResultVisibility;
import org.chorem.pollen.persistence.entity.VoteVisibility;
import org.chorem.pollen.services.bean.PollenBean;
import org.chorem.pollen.services.bean.QuestionBean;
import org.chorem.pollen.services.bean.ReportResumeBean;

public class PollBean
extends PollenBean<Poll> {
    protected String permission;
    protected String creatorName;
    protected String creatorEmail;
    protected String title;
    protected String description;
    protected Date createDate;
    protected Date beginDate;
    protected Date endDate;
    protected boolean anonymousVoteAllowed;
    protected boolean continuousResults;
    protected PollType pollType;
    protected VoteVisibility voteVisibility;
    protected CommentVisibility commentVisibility;
    protected ResultVisibility resultVisibility;
    protected boolean closed;
    protected boolean resultIsVisible;
    protected boolean commentIsVisible;
    protected boolean voteIsVisible;
    protected boolean participantsIsVisible;
    protected boolean canVote;
    protected long commentCount;
    protected Set<String> invalidEmails;
    protected long participantCount;
    protected long participantInvitedCount;
    protected PollStatus status;
    protected int notifyMeHoursBeforePollEnds;
    protected boolean voteNotification;
    protected boolean commentNotification;
    protected boolean newChoiceNotification;
    protected String notificationLocale;
    protected ReportResumeBean report;
    protected boolean gtuValidated;
    protected int maxVoters;
    protected String creatorAvatar;
    protected List<String> emailAddressSuffixes;
    protected List<QuestionBean> questions;
    protected String picture;
    protected String builtinPicture;
    protected ResultPresentation resultPresentation;

    public PollBean() {
        super(Poll.class);
    }

    public static boolean isPollFree(PollBean poll) {
        return Objects.equals(PollType.FREE, poll.getPollType());
    }

    public static boolean isPollRestricted(PollBean poll) {
        return Objects.equals(PollType.RESTRICTED, poll.getPollType());
    }

    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public String getCreatorName() {
        return this.creatorName;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public String getCreatorEmail() {
        return this.creatorEmail;
    }

    public void setCreatorEmail(String creatorEmail) {
        this.creatorEmail = creatorEmail;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public boolean isAnonymousVoteAllowed() {
        return this.anonymousVoteAllowed;
    }

    public void setAnonymousVoteAllowed(boolean anonymousVoteAllowed) {
        this.anonymousVoteAllowed = anonymousVoteAllowed;
    }

    public boolean isContinuousResults() {
        return this.continuousResults;
    }

    public void setContinuousResults(boolean continuousResults) {
        this.continuousResults = continuousResults;
    }

    public PollType getPollType() {
        return this.pollType;
    }

    public void setPollType(PollType pollType) {
        this.pollType = pollType;
    }

    public VoteVisibility getVoteVisibility() {
        return this.voteVisibility;
    }

    public void setVoteVisibility(VoteVisibility voteVisibility) {
        this.voteVisibility = voteVisibility;
    }

    public CommentVisibility getCommentVisibility() {
        return this.commentVisibility;
    }

    public void setCommentVisibility(CommentVisibility commentVisibility) {
        this.commentVisibility = commentVisibility;
    }

    public ResultVisibility getResultVisibility() {
        return this.resultVisibility;
    }

    public void setResultVisibility(ResultVisibility resultVisibility) {
        this.resultVisibility = resultVisibility;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public boolean isResultIsVisible() {
        return this.resultIsVisible;
    }

    public void setResultIsVisible(boolean resultIsVisible) {
        this.resultIsVisible = resultIsVisible;
    }

    public boolean isCommentIsVisible() {
        return this.commentIsVisible;
    }

    public void setCommentIsVisible(boolean commentIsVisible) {
        this.commentIsVisible = commentIsVisible;
    }

    public boolean isVoteIsVisible() {
        return this.voteIsVisible;
    }

    public void setVoteIsVisible(boolean voteIsVisible) {
        this.voteIsVisible = voteIsVisible;
    }

    public boolean isParticipantsIsVisible() {
        return this.participantsIsVisible;
    }

    public void setParticipantsIsVisible(boolean participantsIsVisible) {
        this.participantsIsVisible = participantsIsVisible;
    }

    public boolean isCanVote() {
        return this.canVote;
    }

    public void setCanVote(boolean canVote) {
        this.canVote = canVote;
    }

    public long getCommentCount() {
        return this.commentCount;
    }

    public void setCommentCount(long commentCount) {
        this.commentCount = commentCount;
    }

    public PollStatus getStatus() {
        return this.status;
    }

    public void setStatus(PollStatus status) {
        this.status = status;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public int getNotifyMeHoursBeforePollEnds() {
        return this.notifyMeHoursBeforePollEnds;
    }

    public void setNotifyMeHoursBeforePollEnds(int notifyMeHoursBeforePollEnds) {
        this.notifyMeHoursBeforePollEnds = notifyMeHoursBeforePollEnds;
    }

    public boolean isVoteNotification() {
        return this.voteNotification;
    }

    public void setVoteNotification(boolean voteNotification) {
        this.voteNotification = voteNotification;
    }

    public boolean isCommentNotification() {
        return this.commentNotification;
    }

    public void setCommentNotification(boolean commentNotification) {
        this.commentNotification = commentNotification;
    }

    public boolean isNewChoiceNotification() {
        return this.newChoiceNotification;
    }

    public void setNewChoiceNotification(boolean newChoiceNotification) {
        this.newChoiceNotification = newChoiceNotification;
    }

    public String getNotificationLocale() {
        return this.notificationLocale;
    }

    public void setNotificationLocale(String notificationLocale) {
        this.notificationLocale = notificationLocale;
    }

    public long getParticipantCount() {
        return this.participantCount;
    }

    public void setParticipantCount(long participantCount) {
        this.participantCount = participantCount;
    }

    public long getParticipantInvitedCount() {
        return this.participantInvitedCount;
    }

    public void setParticipantInvitedCount(long participantInvitedCount) {
        this.participantInvitedCount = participantInvitedCount;
    }

    public ReportResumeBean getReport() {
        return this.report;
    }

    public void setReport(ReportResumeBean report) {
        this.report = report;
    }

    public boolean isGtuValidated() {
        return this.gtuValidated;
    }

    public void setGtuValidated(boolean gtuValidated) {
        this.gtuValidated = gtuValidated;
    }

    public int getMaxVoters() {
        return this.maxVoters;
    }

    public void setMaxVoters(int maxVoters) {
        this.maxVoters = maxVoters;
    }

    public String getCreatorAvatar() {
        return this.creatorAvatar;
    }

    public void setCreatorAvatar(String creatorAvatar) {
        this.creatorAvatar = creatorAvatar;
    }

    public Set<String> getInvalidEmails() {
        return this.invalidEmails;
    }

    public void setInvalidEmails(Set<String> invalidEmails) {
        this.invalidEmails = invalidEmails;
    }

    public List<String> getEmailAddressSuffixes() {
        return this.emailAddressSuffixes;
    }

    public void setEmailAddressSuffixes(List<String> emailAddressSuffixes) {
        this.emailAddressSuffixes = emailAddressSuffixes;
    }

    public List<QuestionBean> getQuestions() {
        return this.questions;
    }

    public void setQuestions(List<QuestionBean> questions) {
        this.questions = questions;
    }

    public void addQuestion(QuestionBean question) {
        if (null == this.questions) {
            this.questions = new ArrayList<QuestionBean>();
        }
        this.questions.add(question);
    }

    public String getPicture() {
        return this.picture;
    }

    public void setPicture(String picture) {
        this.picture = picture;
    }

    public String getBuiltinPicture() {
        return this.builtinPicture;
    }

    public void setBuiltinPicture(String builtinPicture) {
        this.builtinPicture = builtinPicture;
    }

    public ResultPresentation getResultPresentation() {
        return this.resultPresentation;
    }

    public void setResultPresentation(ResultPresentation resultPresentation) {
        this.resultPresentation = resultPresentation;
    }

    public static enum PollStatus {
        CREATED,
        VOTING,
        ADDING_CHOICES,
        CLOSED;

    }
}

