/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.persistence.entity;

import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import org.chorem.pollen.persistence.AbstractPollenEntity;
import org.chorem.pollen.persistence.PollenEntity;
import org.chorem.pollen.persistence.entity.PollenResource;
import org.chorem.pollen.persistence.entity.PollenUserEmailAddress;
import org.chorem.pollen.persistence.entity.UserCredential;

public class PollenUser
extends AbstractPollenEntity {
    private static final long serialVersionUID = 3978988966681000289L;
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_ADMINISTRATOR = "administrator";
    public static final String PROPERTY_LANGUAGE = "language";
    public static final String PROPERTY_PASSWORD = "password";
    public static final String PROPERTY_SALT = "salt";
    public static final String PROPERTY_BANNED = "banned";
    public static final String PROPERTY_GTU_VALIDATION_DATE = "gtuValidationDate";
    public static final String PROPERTY_PREMIUM_TO = "premiumTo";
    public static final String PROPERTY_CAN_CREATE_POLL = "canCreatePoll";
    public static final String PROPERTY_USER_CREDENTIAL = "userCredential";
    public static final String PROPERTY_AVATAR = "avatar";
    public static final String PROPERTY_DEFAULT_EMAIL_ADDRESS = "defaultEmailAddress";
    public static final String PROPERTY_EMAIL_ADDRESSES = "emailAddresses";
    protected String name;
    protected boolean administrator;
    protected String language;
    protected String password;
    protected String salt;
    protected boolean banned;
    protected Date gtuValidationDate;
    protected Date premiumTo;
    protected boolean canCreatePoll;
    protected Collection<UserCredential> userCredential;
    protected PollenResource avatar;
    protected PollenUserEmailAddress defaultEmailAddress;
    protected Collection<PollenUserEmailAddress> emailAddresses;

    public boolean isEmailValidated() {
        return this.getDefaultEmailAddress() == null || this.getDefaultEmailAddress().isValidated();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setAdministrator(boolean administrator) {
        this.administrator = administrator;
    }

    public boolean isAdministrator() {
        return this.administrator;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public String getSalt() {
        return this.salt;
    }

    public void setBanned(boolean banned) {
        this.banned = banned;
    }

    public boolean isBanned() {
        return this.banned;
    }

    public void setGtuValidationDate(Date gtuValidationDate) {
        this.gtuValidationDate = gtuValidationDate;
    }

    public Date getGtuValidationDate() {
        return this.gtuValidationDate;
    }

    public void setPremiumTo(Date premiumTo) {
        this.premiumTo = premiumTo;
    }

    public Date getPremiumTo() {
        return this.premiumTo;
    }

    public void setCanCreatePoll(boolean canCreatePoll) {
        this.canCreatePoll = canCreatePoll;
    }

    public boolean isCanCreatePoll() {
        return this.canCreatePoll;
    }

    public void addUserCredential(UserCredential userCredential) {
        if (this.userCredential == null) {
            this.userCredential = new LinkedList<UserCredential>();
        }
        this.userCredential.add(userCredential);
    }

    public void setUserCredential(Collection<UserCredential> userCredential) {
        this.userCredential = userCredential;
    }

    public Collection<UserCredential> getUserCredential() {
        return this.userCredential;
    }

    public UserCredential getUserCredentialByTopiaId(String topiaId) {
        return this.getEntityByTopiaId(this.userCredential, topiaId);
    }

    public void setAvatar(PollenResource avatar) {
        this.avatar = avatar;
    }

    public PollenResource getAvatar() {
        return this.avatar;
    }

    public void setDefaultEmailAddress(PollenUserEmailAddress defaultEmailAddress) {
        this.defaultEmailAddress = defaultEmailAddress;
    }

    public PollenUserEmailAddress getDefaultEmailAddress() {
        return this.defaultEmailAddress;
    }

    public void addEmailAddresses(PollenUserEmailAddress emailAddresses) {
        if (this.emailAddresses == null) {
            this.emailAddresses = new LinkedList<PollenUserEmailAddress>();
        }
        this.emailAddresses.add(emailAddresses);
    }

    public void setEmailAddresses(Collection<PollenUserEmailAddress> emailAddresses) {
        this.emailAddresses = emailAddresses;
    }

    public void removeEmailAddresses(PollenUserEmailAddress emailAddresses) {
        if (this.emailAddresses == null || !this.emailAddresses.remove(emailAddresses)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    public Collection<PollenUserEmailAddress> getEmailAddresses() {
        return this.emailAddresses;
    }

    public PollenUserEmailAddress getEmailAddressesByTopiaId(String topiaId) {
        return this.getEntityByTopiaId(this.emailAddresses, topiaId);
    }

    public int sizeEmailAddresses() {
        if (this.emailAddresses == null) {
            return 0;
        }
        return this.emailAddresses.size();
    }

    private <E extends PollenEntity> E getEntityByTopiaId(Collection<E> entities, String topiaId) {
        if (entities != null) {
            for (PollenEntity e : entities) {
                if (!topiaId.equals(e.getTopiaId())) continue;
                return (E)e;
            }
        }
        return null;
    }
}

