/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.callao.service;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.callao.entity.Account;
import org.chorem.callao.entity.AccountDAO;
import org.chorem.callao.entity.CallaoDAOHelper;
import org.chorem.callao.entity.Entry;
import org.chorem.callao.entity.EntryDAO;
import org.chorem.callao.service.convertObject.ConvertAccount;
import org.chorem.callao.service.dto.AccountDTO;
import org.chorem.callao.service.utils.ContextCallao;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class AccountServiceImpl {
    private static final Log log = LogFactory.getLog(AccountServiceImpl.class);
    private TopiaContext rootContext = ContextCallao.getInstance().getContext();
    private ConvertAccount convertAccount = new ConvertAccount();

    public String createAccount(String accountNumber, String label, Account masterAccount, String type) {
        String result = "error";
        boolean existAccount = this.existAccount(accountNumber);
        if (existAccount) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Le compte num\u00e9ro " + accountNumber + " existe deja !"));
            }
            result = "account_double";
        } else {
            try {
                TopiaContext topiaContext = this.rootContext.beginTransaction();
                AccountDAO accountDAO = CallaoDAOHelper.getAccountDAO((TopiaContext)topiaContext);
                if (masterAccount != null) {
                    boolean existMasterAccount = this.existAccount(masterAccount.getAccountNumber());
                    if (!existMasterAccount) {
                        if (log.isWarnEnabled()) {
                            log.warn((Object)("Le compte p\u00e8re num\u00e9ro " + accountNumber + " n'existe pas !"));
                        }
                        result = "account_not_master";
                    } else {
                        Account newAccount = (Account)accountDAO.create(new Object[0]);
                        newAccount.setAccountNumber(accountNumber);
                        newAccount.setLabel(label);
                        newAccount.setMasterAccount(masterAccount);
                        newAccount.setType(type);
                        topiaContext.commitTransaction();
                        result = "success";
                    }
                } else {
                    Account newAccount = (Account)accountDAO.create(new Object[0]);
                    newAccount.setAccountNumber(accountNumber);
                    newAccount.setLabel(label);
                    newAccount.setType(type);
                    topiaContext.commitTransaction();
                    result = "success";
                }
                topiaContext.closeContext();
            }
            catch (TopiaException e) {
                log.error((Object)e);
            }
        }
        return result;
    }

    public String createAccount(String accountNumber, String label, String masterAccountNumber, String type) {
        String result = "error";
        Account masterAccount = this.searchAccount(masterAccountNumber);
        if (masterAccount == null && !masterAccountNumber.equals("0")) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Le compte p\u00e8re num\u00e9ro " + masterAccountNumber + " n'existe pas !"));
            }
            result = "account_not_master";
        } else {
            result = this.createAccount(accountNumber, label, masterAccount, type);
        }
        return result;
    }

    public String createAccount(AccountDTO accountDTO) {
        boolean error = false;
        String result = this.createAccount(accountDTO.getAccountNumber(), accountDTO.getLabel(), accountDTO.getMasterAccount(), accountDTO.getType());
        for (AccountDTO accountChildDTO : accountDTO.getAccountChildDTO()) {
            result = this.createAccount(accountChildDTO);
            if (result.equals("success")) continue;
            if (log.isWarnEnabled()) {
                log.warn((Object)("Le compte num\u00e9ro " + accountChildDTO.getLabel() + " n'a pu \u00eatre cr\u00e9\u00e9 !"));
            }
            error = true;
            String string = result;
        }
        if (error) {
            result = "error";
        }
        return result;
    }

    public AccountDTO searchAccountDTO(String accountNumber) {
        AccountDTO accountDTO = null;
        try {
            TopiaContext topiaContext = this.rootContext.beginTransaction();
            AccountDAO accountDAO = CallaoDAOHelper.getAccountDAO((TopiaContext)topiaContext);
            Account account = accountDAO.findByAccountNumber(accountNumber);
            this.convertAccount.setTransaction(topiaContext);
            accountDTO = this.convertAccount.accountEntityToDto(account, null);
            topiaContext.closeContext();
        }
        catch (TopiaException e) {
            log.error((Object)e);
        }
        return accountDTO;
    }

    public Account searchAccount(String accountNumber) {
        Account accountResult = null;
        try {
            TopiaContext topiaContext = this.rootContext.beginTransaction();
            AccountDAO accountDAO = CallaoDAOHelper.getAccountDAO((TopiaContext)topiaContext);
            accountResult = accountDAO.findByAccountNumber(accountNumber);
            topiaContext.closeContext();
        }
        catch (TopiaException e) {
            log.error((Object)e);
        }
        return accountResult;
    }

    public List<Account> searchListChildAccount(Account account) {
        List ListAccount = null;
        try {
            TopiaContext topiaContext = this.rootContext.beginTransaction();
            AccountDAO accountDAO = CallaoDAOHelper.getAccountDAO((TopiaContext)topiaContext);
            ListAccount = accountDAO.findAllByMasterAccount(account);
            topiaContext.closeContext();
        }
        catch (TopiaException e) {
            log.error((Object)e);
        }
        return ListAccount;
    }

    public List<Account> searchListChildAccount(String accountNumber) {
        List<Account> ListAccount = null;
        Account account = this.searchAccount(accountNumber);
        if (account == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Le compte num\u00e9ro " + accountNumber + " n'existe pas !"));
            }
        } else {
            ListAccount = this.searchListChildAccount(account);
        }
        return ListAccount;
    }

    public List<AccountDTO> getAllAccount() {
        ArrayList<AccountDTO> listAccountDTO = new ArrayList<AccountDTO>();
        try {
            TopiaContext topiaContext = this.rootContext.beginTransaction();
            AccountDAO accountDAO = CallaoDAOHelper.getAccountDAO((TopiaContext)topiaContext);
            List listAccount = accountDAO.findAll();
            this.convertAccount.setTransaction(topiaContext);
            for (Account account : listAccount) {
                if (account.getMasterAccount() != null) continue;
                AccountDTO accountDTO = this.convertAccount.accountEntityToDto(account, null);
                listAccountDTO.add(accountDTO);
            }
            topiaContext.closeContext();
        }
        catch (TopiaException e) {
            log.error((Object)e);
        }
        return listAccountDTO;
    }

    public boolean existAccount(String accountNumber) {
        Account accountSearch = this.searchAccount(accountNumber);
        boolean result = false;
        if (accountSearch != null) {
            result = true;
        }
        return result;
    }

    public String removeAccount(String accountNumber) {
        String result = "error";
        Account deleteAccount = this.searchAccount(accountNumber);
        if (deleteAccount == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Le compte num\u00e9ro " + accountNumber + " n'existe pas !"));
            }
            result = "account_not_exist";
        } else {
            try {
                TopiaContext topiaContext = this.rootContext.beginTransaction();
                EntryDAO entryDAO = CallaoDAOHelper.getEntryDAO((TopiaContext)topiaContext);
                Entry entry = entryDAO.findByAccount(deleteAccount);
                if (entry != null) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("Le compte num\u00e9ro " + accountNumber + " poss\u00e8de des entr\u00e9es comptable !"));
                    }
                    result = "account_with_entries";
                } else {
                    List<Account> listAccountChild = this.searchListChildAccount(deleteAccount);
                    boolean ErrorRemoveChild = false;
                    for (Account accountChild : listAccountChild) {
                        result = this.removeAccount(accountChild.getAccountNumber());
                        if (!result.equals("error")) continue;
                        ErrorRemoveChild = true;
                        if (!log.isErrorEnabled()) continue;
                        log.error((Object)("Le compte fils num\u00e9ro " + accountChild.getAccountNumber() + " n'a pas \u00e9t\u00e9 supprim\u00e9 !"));
                    }
                    if (!ErrorRemoveChild) {
                        AccountDAO accountDAO = CallaoDAOHelper.getAccountDAO((TopiaContext)topiaContext);
                        accountDAO.delete(deleteAccount);
                        topiaContext.commitTransaction();
                        topiaContext.closeContext();
                        result = "success";
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Le compte num\u00e9ro " + accountNumber + " a ete supprim\u00e9 avec succ\u00e8s."));
                        }
                    }
                }
            }
            catch (TopiaException e) {
                log.error((Object)e);
            }
        }
        return result;
    }

    public String removeAccount(AccountDTO accountDTO) {
        String result = this.removeAccount(accountDTO.getAccountNumber());
        return result;
    }

    public String modifyAccount(String accountNumber, String label, String type, Account masterAccount) {
        String result = "error";
        try {
            TopiaContext topiaContext = this.rootContext.beginTransaction();
            AccountDAO accountDAO = CallaoDAOHelper.getAccountDAO((TopiaContext)topiaContext);
            Account modifyAccount = accountDAO.findByAccountNumber(accountNumber);
            if (modifyAccount == null) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Le compte num\u00e9ro " + accountNumber + " n'existe pas !"));
                }
                result = "account_not_exist";
            } else {
                modifyAccount.setLabel(label);
                modifyAccount.setType(type);
                if (masterAccount != null) {
                    modifyAccount.setMasterAccount(masterAccount);
                }
                modifyAccount.update();
                topiaContext.commitTransaction();
                topiaContext.closeContext();
                result = "success";
            }
        }
        catch (TopiaException e) {
            log.error((Object)e);
        }
        return result;
    }

    public String modifyAccount(String accountNumber, String label, String type, String masterAccountNumber) {
        String result = "error";
        try {
            TopiaContext topiaContext = this.rootContext.beginTransaction();
            AccountDAO accountDAO = CallaoDAOHelper.getAccountDAO((TopiaContext)topiaContext);
            Account masterAccount = accountDAO.findByAccountNumber(masterAccountNumber);
            result = this.modifyAccount(accountNumber, label, type, masterAccount);
            topiaContext.closeContext();
        }
        catch (TopiaException e) {
            log.error((Object)e);
        }
        return result;
    }

    public String modifyAccount(AccountDTO accountDTO) {
        String result = "error";
        try {
            TopiaContext topiaContext = this.rootContext.beginTransaction();
            AccountDAO accountDAO = CallaoDAOHelper.getAccountDAO((TopiaContext)topiaContext);
            Account masterAccount = accountDAO.findByAccountNumber(accountDTO.getMasterAccount());
            result = this.modifyAccount(accountDTO.getAccountNumber(), accountDTO.getLabel(), accountDTO.getType(), masterAccount);
            topiaContext.closeContext();
        }
        catch (TopiaException e) {
            log.error((Object)e);
        }
        return result;
    }

    public String updateDTO(AccountDTO accountDTO) {
        String result = this.existAccount(accountDTO.getAccountNumber()) ? this.modifyAccount(accountDTO) : this.createAccount(accountDTO);
        for (AccountDTO accountChildDTO : accountDTO.getAccountChildDTO()) {
            this.updateDTO(accountChildDTO);
        }
        List<Account> listAccountChild = this.searchListChildAccount(accountDTO.getAccountNumber());
        for (Account account : listAccountChild) {
            if (accountDTO.existAccountChild(account.getAccountNumber())) continue;
            result = this.removeAccount(account.getAccountNumber());
        }
        return result;
    }
}

