/**
 * *##% Callao AccountDTO
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */

package org.chorem.callao.service.dto;

import java.util.ArrayList;
import java.util.List;

/**
 * Classe DTO - représente un objet compte pour le Plan Comptable Général (PCG)
 *
 * @author Rémi Chapelet
 */
public class AccountDTO  {

    private String id; // Identifiant Topia

    private String accountNumber;

    private String label;

    private String masterAccount;

    private List<AccountDTO> accountChildDTO;

    private String type;

    public AccountDTO ()
    {
        this.id = "";
        this.accountNumber = "0";
        this.label = "";
        this.masterAccount = "0";
        this.accountChildDTO = new ArrayList<AccountDTO>();
        this.type = "actif";    // Par défaut actif
    }

    public AccountDTO (String id, String accountNumber, String label,String masterAccount, List<AccountDTO> accountChildDTO,String type)
    {
        this.id = id;
        this.accountNumber = accountNumber;
        this.label = label;
        this.masterAccount = masterAccount;
        this.type = type;
        // Si la liste est vide, il faut l'initialiser
        if (accountChildDTO == null )
        {
            this.accountChildDTO = new ArrayList<AccountDTO>();
        } else 
        {
            this.accountChildDTO = accountChildDTO;
        }
    }

    /**
     * Permet d'ajouter un compte fils
     * @param accountChildDTO
     */
    public void addAccountChild (AccountDTO accountChildDTO)
    {
        // Si le numéro père/fils correspond
        if ( this.accountNumber.equals(accountChildDTO.getMasterAccount()) )
        {
            // Non présent
            if ( !existAccountChild(accountChildDTO) )
            {
                this.accountChildDTO.add(accountChildDTO);
            }
        } 
    }

    /**
     * Permet d'enlever un compte fils
     * @param accountChildDTO
     */
    public void removeAccountChild (AccountDTO accountChildDTO)
    {
        AccountDTO accountDeleteDTO = null;
        // recherche du compte
        for (AccountDTO accountChild : this.accountChildDTO)
        {
            if (accountChild.getAccountNumber().equals(accountChildDTO.getAccountNumber()))
            {
                accountDeleteDTO = accountChild;               
            }
        }
        // Si le compte à supprimer est trouvé, on le supprime
        if ( accountDeleteDTO != null )
        {
            this.accountChildDTO.remove(accountDeleteDTO);
        }
    }

    /**
     * Permet d'afficher tous les comptes enfants
     */
    public void toStringAccountChild ()
    {
        int i = 0;
        for (AccountDTO accountDTO : this.accountChildDTO)
        {
            System.out.println("Compte "+accountDTO.getAccountNumber()+" : "+accountDTO.getLabel());
            i++;
        }
        System.out.println("Nombre de compte(s) enfant(s) : "+i);
    }

    /**
     * Permet de vérifier si un compte DTO fait parti des enfants
     * @param accountDTO
     * @return
     */
    public boolean existAccountChild (AccountDTO accountDTO)
    {
        boolean exist = false;
        for (AccountDTO accountChild : this.accountChildDTO)
        {
            if (accountChild.getAccountNumber().equals(accountDTO.getAccountNumber()))
            {
                exist = true;
            }
        }
        return exist;
    }

    /**
     * Permet de vérifier si un compte DTO fait parti des enfants
     * @param accountDTO
     * @return
     */
    public boolean existAccountChild (String accountNumber)
    {
        boolean exist = false;
        for (AccountDTO accountChild : this.accountChildDTO)
        {
            if (accountChild.getAccountNumber().equals(accountNumber))
            {
                exist = true;
            }
        }
        return exist;
    }

    /**
     * @return the id
     */
    public String getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * @return the accountNumber
     */
    public String getAccountNumber() {
        return accountNumber;
    }

    /**
     * @param accountNumber the accountNumber to set
     */
    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    /**
     * @return the label
     */
    public String getLabel() {
        return label;
    }

    /**
     * @param label the label to set
     */
    public void setLabel(String label) {
        this.label = label;
    }

    /**
     * @return the accountChildDTO
     */
    public List<AccountDTO> getAccountChildDTO() {
        return accountChildDTO;
    }

    /**
     * @param accountChildDTO the accountChildDTO to set
     */
    public void setAccountChildDTO(List<AccountDTO> accountChildDTO) {
        this.accountChildDTO = accountChildDTO;
    }

    /**
     * @return the masterAccount
     */
    public String getMasterAccount() {
        return masterAccount;
    }

    /**
     * @param masterAccount the masterAccount to set
     */
    public void setMasterAccount(String masterAccount) {
        this.masterAccount = masterAccount;
    }

    /**
     * @return the type
     */
    public String getType() {
        return type;
    }

    /**
     * @param type the type to set
     */
    public void setType(String type) {
        this.type = type;
    }


}