/**
 * *##% Callao ConvertPeriod
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */

package org.chorem.callao.service.convertObject;

import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.callao.entity.Period;
import org.chorem.callao.entity.TimeSpan;
import org.chorem.callao.service.dto.PeriodDTO;
import org.chorem.callao.service.dto.TimeSpanDTO;
import org.chorem.callao.service.TimeSpanServiceImpl;


/**
 * Transforme les objets Period : DTO, DAO et entity
 *
 * @author Rémi Chapelet
 */
public class ConvertPeriod  extends ConvertTopiaContext {

    private static final Log log = LogFactory.getLog(ConvertPeriod.class);

    private TimeSpanServiceImpl timeSpanServiceImpl = new TimeSpanServiceImpl();


    public PeriodDTO periodEntityToDto(Period period)
    {
        PeriodDTO periodDTO = null;
        if (period != null)
        {
            periodDTO = new PeriodDTO();
            periodDTO.setId(period.getTopiaId());
            periodDTO.setBeginPeriod(period.getBeginPeriod());
            periodDTO.setEndPeriod(period.getEndPeriod());
            periodDTO.setLocked(period.getLocked());
            /**
             * Converti les timeSpans en timeSpanDTO
             */
            List<TimeSpan> listTimeSpan = timeSpanServiceImpl.searchListTimeSpan(period);
            ConvertTimeSpan convertTimeSpan = new ConvertTimeSpan();
            for (TimeSpan timeSpan : listTimeSpan)
            {
                // Converti le timeSpan
                TimeSpanDTO timeSpanDTO = convertTimeSpan.timeSpanEntityToDto(timeSpan);
                // Ajoute le timeSpanDTO à periodDTO
                periodDTO.addTimeSpan(timeSpanDTO);
            }
        }
        return periodDTO;
    }

}