/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.callao.service.dto;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.chorem.callao.service.dto.TimeSpanDTO;
import org.chorem.callao.service.utils.DateUtil;

public class PeriodDTO {
    private String id;
    private Date beginPeriod;
    private Date endPeriod;
    private boolean locked;
    private List<TimeSpanDTO> listTimeSpan;
    private static DateUtil dateUtil = new DateUtil();

    public PeriodDTO() {
        this.id = "";
        this.beginPeriod = new Date();
        this.beginPeriod = dateUtil.InitDateFirstDayMonth(this.beginPeriod);
        this.endPeriod = new Date();
        this.endPeriod = dateUtil.InitDateEndDayMonth(this.endPeriod);
        this.locked = false;
        this.listTimeSpan = new ArrayList<TimeSpanDTO>();
    }

    public PeriodDTO(String id, Date beginPeriod, Date endPeriod, boolean locked, List<TimeSpanDTO> listTimeSpan) {
        this.id = id;
        this.beginPeriod = dateUtil.InitDateFirstDayMonth(beginPeriod);
        this.endPeriod = dateUtil.InitDateEndDayMonth(endPeriod);
        this.locked = locked;
        if (listTimeSpan == null) {
            this.listTimeSpan = new ArrayList<TimeSpanDTO>();
        } else {
            for (TimeSpanDTO timeSpanDTO : this.listTimeSpan) {
                this.addTimeSpan(timeSpanDTO);
            }
        }
    }

    public boolean isCorrectTimeSpan(TimeSpanDTO timeSpanDTO) {
        boolean result = false;
        if (timeSpanDTO != null && !this.existTimeSpan(timeSpanDTO) && this.getListTimeSpan().size() < 12 && dateUtil.betweenDate(timeSpanDTO.getBeginTimeSpan(), this.beginPeriod, this.endPeriod) && dateUtil.betweenDate(timeSpanDTO.getEndTimeSpan(), this.beginPeriod, this.endPeriod)) {
            result = true;
        }
        return result;
    }

    public void addTimeSpan(TimeSpanDTO timeSpanDTO) {
        if (this.isCorrectTimeSpan(timeSpanDTO)) {
            this.getListTimeSpan().add(timeSpanDTO);
            Collections.sort(this.getListTimeSpan());
        }
    }

    public boolean existTimeSpan(TimeSpanDTO timeSpanDTO) {
        boolean exist = false;
        for (TimeSpanDTO timeSpanDtoOfList : this.getListTimeSpan()) {
            if (!timeSpanDTO.getId().equals("") && timeSpanDtoOfList.getId().equals(timeSpanDTO.getId())) {
                exist = true;
            }
            if (timeSpanDtoOfList.getBeginTimeSpan().compareTo(timeSpanDTO.getBeginTimeSpan()) != 0) continue;
            exist = true;
        }
        return exist;
    }

    public void blockPeriod() {
        if (!this.isLocked()) {
            boolean existTimeSpanDTONotBlocked = false;
            for (TimeSpanDTO timeSpanDTO : this.listTimeSpan) {
                if (!timeSpanDTO.isLocked()) continue;
                existTimeSpanDTONotBlocked = true;
            }
            if (existTimeSpanDTONotBlocked) {
                this.locked = true;
            }
        }
    }

    public void blockAllTimeSpan() {
        for (TimeSpanDTO timeSpanDTO : this.listTimeSpan) {
            timeSpanDTO.setLocked(true);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Date getBeginPeriod() {
        return this.beginPeriod;
    }

    public void setBeginPeriod(Date beginPeriod) {
        this.beginPeriod = dateUtil.InitDateFirstDayMonth(beginPeriod);
    }

    public Date getEndPeriod() {
        return this.endPeriod;
    }

    public void setEndPeriod(Date endPeriod) {
        this.endPeriod = dateUtil.InitDateEndDayMonth(endPeriod);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.blockPeriod();
    }

    public List<TimeSpanDTO> getListTimeSpan() {
        return this.listTimeSpan;
    }

    public void setListTimeSpan(List<TimeSpanDTO> listTimeSpan) {
        this.listTimeSpan = listTimeSpan;
    }
}

