/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.callao.service.dto;

import java.util.ArrayList;
import java.util.List;

public class AccountDTO {
    private String id;
    private String accountNumber;
    private String label;
    private String masterAccount;
    private List<AccountDTO> accountChildDTO;
    private String type;

    public AccountDTO() {
        this.id = "";
        this.accountNumber = "0";
        this.label = "";
        this.masterAccount = "0";
        this.accountChildDTO = new ArrayList<AccountDTO>();
        this.type = "actif";
    }

    public AccountDTO(String id, String accountNumber, String label, String masterAccount, List<AccountDTO> accountChildDTO, String type) {
        this.id = id;
        this.accountNumber = accountNumber;
        this.label = label;
        this.masterAccount = masterAccount;
        this.type = type;
        this.accountChildDTO = accountChildDTO == null ? new ArrayList<AccountDTO>() : accountChildDTO;
    }

    public void addAccountChild(AccountDTO accountChildDTO) {
        if (this.accountNumber.equals(accountChildDTO.getMasterAccount()) && !this.existAccountChild(accountChildDTO)) {
            this.accountChildDTO.add(accountChildDTO);
        }
    }

    public void removeAccountChild(AccountDTO accountChildDTO) {
        AccountDTO accountDeleteDTO = null;
        for (AccountDTO accountChild : this.accountChildDTO) {
            if (!accountChild.getAccountNumber().equals(accountChildDTO.getAccountNumber())) continue;
            accountDeleteDTO = accountChild;
        }
        if (accountDeleteDTO != null) {
            this.accountChildDTO.remove(accountDeleteDTO);
        }
    }

    public void toStringAccountChild() {
        int i = 0;
        for (AccountDTO accountDTO : this.accountChildDTO) {
            System.out.println("Compte " + accountDTO.getAccountNumber() + " : " + accountDTO.getLabel());
            ++i;
        }
        System.out.println("Nombre de compte(s) enfant(s) : " + i);
    }

    public boolean existAccountChild(AccountDTO accountDTO) {
        boolean exist = false;
        for (AccountDTO accountChild : this.accountChildDTO) {
            if (!accountChild.getAccountNumber().equals(accountDTO.getAccountNumber())) continue;
            exist = true;
        }
        return exist;
    }

    public boolean existAccountChild(String accountNumber) {
        boolean exist = false;
        for (AccountDTO accountChild : this.accountChildDTO) {
            if (!accountChild.getAccountNumber().equals(accountNumber)) continue;
            exist = true;
        }
        return exist;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public List<AccountDTO> getAccountChildDTO() {
        return this.accountChildDTO;
    }

    public void setAccountChildDTO(List<AccountDTO> accountChildDTO) {
        this.accountChildDTO = accountChildDTO;
    }

    public String getMasterAccount() {
        return this.masterAccount;
    }

    public void setMasterAccount(String masterAccount) {
        this.masterAccount = masterAccount;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

