/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.android.saymytexts;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Fragment;
import android.app.PendingIntent;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.preference.ListPreference;
import android.preference.Preference;
import android.preference.PreferenceFragment;
import android.preference.PreferenceManager;
import android.preference.SwitchPreference;
import android.telephony.SmsManager;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.view.View;
import android.widget.EditText;
import android.widget.Toast;
import org.chorem.android.saymytexts.SayMyTextsUtils;

public class SettingsActivity
extends Activity {
    private static final String TAG = "SettingsActivity";
    protected static final int CHECK_TTS_REQUEST_CODE = 42;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getFragmentManager().beginTransaction().replace(0x1020002, (Fragment)new SettingsFragment()).commit();
        try {
            Intent checkIntent = new Intent();
            checkIntent.setAction("android.speech.tts.engine.CHECK_TTS_DATA");
            this.startActivityForResult(checkIntent, 42);
        }
        catch (ActivityNotFoundException eee) {
            Log.e((String)TAG, (String)"No activity found fo texttospeech", (Throwable)eee);
            Toast.makeText((Context)this, (int)2131034139, (int)1).show();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 42) {
            try {
                if (resultCode == 0) {
                    Intent installIntent = new Intent("android.speech.tts.engine.INSTALL_TTS_DATA");
                    this.startActivity(installIntent);
                }
            }
            catch (ActivityNotFoundException eee) {
                Log.e((String)TAG, (String)"No activity found fo texttospeech", (Throwable)eee);
                Toast.makeText((Context)this, (int)2131034139, (int)1).show();
            }
        } else {
            super.onActivityResult(requestCode, resultCode, data);
        }
    }

    public static class SettingsFragment
    extends PreferenceFragment
    implements SharedPreferences.OnSharedPreferenceChangeListener {
        public void onCreate(Bundle savedInstanceState) {
            int maxAttemptNumber;
            super.onCreate(savedInstanceState);
            this.addPreferencesFromResource(2130903040);
            Preference testPreference = this.findPreference(this.getString(2131034116));
            testPreference.setOnPreferenceClickListener(new Preference.OnPreferenceClickListener(){

                public boolean onPreferenceClick(Preference preference) {
                    SettingsFragment.this.sendSMS();
                    return true;
                }
            });
            Activity context = this.getActivity();
            try {
                String currentVersion = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
                Preference versionPreference = this.findPreference(this.getString(2131034117));
                versionPreference.setSummary((CharSequence)currentVersion);
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e((String)SettingsActivity.TAG, (String)"error while getting the version");
            }
            this.addWebsitePreferenceClickListener(2131034118);
            this.addWebsitePreferenceClickListener(2131034119);
            SharedPreferences sharedPref = PreferenceManager.getDefaultSharedPreferences((Context)this.getActivity());
            String key = this.getString(2131034112);
            ListPreference listPreference = (ListPreference)this.findPreference(key);
            CharSequence summary = listPreference.getEntry();
            listPreference.setSummary(summary);
            key = this.getString(2131034113);
            SwitchPreference switchPreference = (SwitchPreference)this.findPreference(key);
            boolean enabled = SayMyTextsUtils.checkVoiceRecognition((Context)context);
            switchPreference.setEnabled(enabled);
            boolean interactionEnabled = enabled && sharedPref.getBoolean(key, switchPreference.isChecked());
            switchPreference.setChecked(interactionEnabled);
            key = this.getString(2131034115);
            String maxAttemptValue = sharedPref.getString(key, null);
            try {
                maxAttemptNumber = Integer.parseInt(maxAttemptValue);
            }
            catch (NumberFormatException e) {
                maxAttemptNumber = 3;
            }
            Preference preference = this.findPreference(key);
            preference.setSummary((CharSequence)String.valueOf(maxAttemptNumber));
            preference.setEnabled(interactionEnabled);
            key = this.getString(2131034114);
            switchPreference = (SwitchPreference)this.findPreference(key);
            interactionEnabled = sharedPref.getBoolean(key, switchPreference.isChecked());
            switchPreference.setChecked(interactionEnabled);
            sharedPref.registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
        }

        public void onDestroy() {
            super.onDestroy();
            SharedPreferences sharedPref = PreferenceManager.getDefaultSharedPreferences((Context)this.getActivity());
            sharedPref.unregisterOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
        }

        public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
            if (this.getString(2131034112).equals(key)) {
                ListPreference preference = (ListPreference)this.findPreference(key);
                CharSequence summary = preference.getEntry();
                preference.setSummary(summary);
            } else if (this.getString(2131034113).equals(key)) {
                SwitchPreference switchPreference = (SwitchPreference)this.findPreference(key);
                boolean enabled = sharedPreferences.getBoolean(key, switchPreference.isChecked());
                switchPreference.setChecked(enabled);
                this.findPreference(this.getString(2131034115)).setEnabled(enabled);
            } else if (this.getString(2131034115).equals(key)) {
                int maxAttemptNumber;
                String maxAttemptValue = sharedPreferences.getString(key, null);
                try {
                    maxAttemptNumber = Integer.parseInt(maxAttemptValue);
                }
                catch (NumberFormatException e) {
                    maxAttemptNumber = 3;
                }
                this.findPreference(key).setSummary((CharSequence)String.valueOf(maxAttemptNumber));
            } else if (this.getString(2131034114).equals(key)) {
                SwitchPreference switchPreference = (SwitchPreference)this.findPreference(key);
                boolean enabled = sharedPreferences.getBoolean(key, switchPreference.isChecked());
                switchPreference.setChecked(enabled);
            }
        }

        protected void addWebsitePreferenceClickListener(int keyId) {
            Preference preference = this.findPreference(this.getString(keyId));
            preference.setOnPreferenceClickListener(new Preference.OnPreferenceClickListener(){

                public boolean onPreferenceClick(Preference preference) {
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.setData(Uri.parse((String)preference.getSummary().toString()));
                    SettingsFragment.this.startActivity(intent);
                    return true;
                }
            });
        }

        protected void sendSMS() {
            Activity context = this.getActivity();
            final String message = this.getString(2131034129);
            final PendingIntent pi = PendingIntent.getActivity((Context)context, (int)-1, (Intent)new Intent((Context)context, SettingsActivity.class), (int)0);
            final SmsManager sms = SmsManager.getDefault();
            TelephonyManager tMgr = (TelephonyManager)context.getSystemService("phone");
            String phoneNumber = tMgr.getLine1Number();
            if (phoneNumber != null) {
                sms.sendTextMessage(phoneNumber, null, message, pi, null);
            } else {
                AlertDialog.Builder alert = new AlertDialog.Builder((Context)context);
                alert.setTitle(2131034136);
                alert.setMessage(2131034137);
                final EditText input = new EditText((Context)context);
                input.setInputType(3);
                alert.setView((View)input);
                alert.setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int whichButton) {
                        String value = input.getText().toString();
                        sms.sendTextMessage(value, null, message, pi, null);
                    }
                });
                alert.setNegativeButton(0x1040000, null);
                alert.show();
            }
        }
    }
}

