/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.models;

import java.util.List;
import java.util.Map;
import ognl.Ognl;
import org.apache.tapestry5.OptionGroupModel;
import org.apache.tapestry5.OptionModel;
import org.apache.tapestry5.internal.OptionModelImpl;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.Defense;
import org.apache.tapestry5.util.AbstractSelectModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OgnlSelectModel<T>
extends AbstractSelectModel {
    private static final Map<String, Object> _cache = CollectionFactory.newMap();
    private List<T> _objectList;
    private String _labelExpression;

    public OgnlSelectModel(String labelExpression) {
        this(null, labelExpression);
    }

    public OgnlSelectModel(List<T> objectList, String labelExpression) {
        Defense.notBlank((String)labelExpression, (String)"labelExpression");
        this._labelExpression = labelExpression;
        if (objectList != null) {
            this.setObjectList(objectList);
        }
    }

    public void setObjectList(List<T> objectList) {
        this._objectList = CollectionFactory.newList(objectList);
    }

    public List<OptionGroupModel> getOptionGroups() {
        return null;
    }

    public List<OptionModel> getOptions() {
        List optionModelList = CollectionFactory.newList();
        if (this._objectList != null) {
            for (int i = 1; i <= this._objectList.size(); ++i) {
                String label = String.valueOf(this.getValue(this._objectList.get(i - 1), this._labelExpression));
                optionModelList.add(new OptionModelImpl(label, this._objectList.get(i - 1)));
            }
        }
        return optionModelList;
    }

    private synchronized Object getParsedExpression(String expression) {
        Object result = _cache.get(expression);
        if (result == null) {
            try {
                result = Ognl.parseExpression((String)expression);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            _cache.put(expression, result);
        }
        return result;
    }

    private Object getValue(Object rootObject, String expression) {
        Object ognlExpression = this.getParsedExpression(expression);
        try {
            Map context = Ognl.createDefaultContext((Object)rootObject);
            return Ognl.getValue((Object)ognlExpression, (Map)context, (Object)rootObject);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

