/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.mixins;

import org.apache.tapestry5.ClientElement;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.RenderSupport;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.IncludeJavaScriptLibrary;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.InjectContainer;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.Cookies;

@IncludeJavaScriptLibrary(value={"../Chenillekit.js", "../Cookie.js", "${tapestry.scriptaculous}/dragdrop.js", "Resizable.js"})
@IncludeStylesheet(value={"Resizable.css"})
public class Resizable
implements ClientElement {
    @InjectContainer
    private ClientElement _clientElement;
    @Inject
    private ComponentResources _resources;
    @Environmental
    private RenderSupport _pageRenderSupport;
    @Inject
    private Cookies _cookies;
    @Parameter(value="prop:componentResources.id", defaultPrefix="literal")
    private String _clientId;
    @Parameter(defaultPrefix="literal")
    private String _constraint;
    @Parameter(value="false", defaultPrefix="prop")
    private boolean _persist;
    private String _assignedClientId;

    void setupRender() {
        this._assignedClientId = this._pageRenderSupport.allocateClientId(this._clientId);
    }

    void afterRender(MarkupWriter writer) {
        writer.element("div", new Object[]{"id", "handle_" + this._clientElement.getClientId(), "class", "ck-resizable-handle"});
        writer.end();
        if (this._persist) {
            int width = this.getIntValueFromCookie(this._clientElement.getClientId() + ".width");
            int height = this.getIntValueFromCookie(this._clientElement.getClientId() + ".height");
            if (width > 0) {
                this._pageRenderSupport.addScript("$('%s').style.width = '%dpx';", new Object[]{this._clientElement.getClientId(), width});
            }
            if (height > 0) {
                this._pageRenderSupport.addScript("$('%s').style.height = '%dpx';", new Object[]{this._clientElement.getClientId(), height});
            }
        }
        String jsString = "%s = new Resizable('%s', {handle:$('handle_%s')";
        if (this._constraint != null) {
            jsString = jsString + String.format(",constraint:'%s'", this._constraint);
        }
        jsString = jsString + ", persist:%s});";
        this._pageRenderSupport.addScript(jsString, new Object[]{this.getClientId(), this._clientElement.getClientId(), this._clientElement.getClientId(), this._persist});
    }

    public String getClientId() {
        return this._assignedClientId;
    }

    private int getIntValueFromCookie(String key) {
        int intValue = 0;
        String cookieValue = this._cookies.readCookieValue(key);
        if (cookieValue != null) {
            try {
                intValue = Integer.parseInt(cookieValue);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException(e);
            }
        }
        return intValue;
    }
}

