/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.components;

import java.util.Locale;
import org.apache.tapestry5.ClientElement;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.RenderSupport;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.IncludeJavaScriptLibrary;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.OnEvent;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.Request;

@IncludeJavaScriptLibrary(value={"${tapestry.scriptaculous}/controls.js", "${tapestry.scriptaculous}/slider.js"})
@IncludeStylesheet(value={"Slider.css"})
public class Slider
implements ClientElement {
    private static final String _handleCSS = "ck_slider-handle";
    private static final String _trackCSS = "ck_slider-track";
    private static final String _valueCSS = "ck_slider-value";
    @Parameter(value="prop:componentResources.id", defaultPrefix="literal")
    private String _clientId;
    @Parameter(required=true)
    private Number _value;
    @Parameter(value="0", required=false)
    private Number _min;
    @Parameter(value="100", required=false)
    private Number _max;
    @Parameter(value="1", required=false)
    private Number _inc;
    @Parameter(value="false", required=false)
    private boolean _disabled;
    @Inject
    private ComponentResources _resources;
    @Inject
    private Request _request;
    private String _handleId;
    private String _tackId;
    private String _ouputId;
    @Environmental
    private RenderSupport _pageRenderSupport;
    private String _assignedClientId;

    void setupRender() {
        this._assignedClientId = this._pageRenderSupport.allocateClientId(this._clientId);
    }

    void beginRender(MarkupWriter writer) {
        this._handleId = "handle_" + this.getClientId();
        this._tackId = "track_" + this.getClientId();
        this._ouputId = "ouput_" + this.getClientId();
        writer.element("div", new Object[]{"id", this._tackId, "class", _trackCSS});
        writer.element("div", new Object[]{"id", this._handleId, "class", _handleCSS});
    }

    void afterRender(MarkupWriter writer) {
        writer.end();
        writer.end();
        writer.element("div", new Object[]{"id", this._ouputId, "class", _valueCSS});
        if (this._value == null) {
            this._value = 0;
        }
        writer.write(this._value.toString());
        writer.end();
        String jsCommand = "new Control.Slider('%s','%s',{sliderValue:" + this.getNumberPattern(this._value) + ",range:" + "$R(" + this.getNumberPattern(this._min) + "," + this.getNumberPattern(this._max) + "),increment:" + this.getNumberPattern(this._inc) + ",onSlide:function(v){$('%s').innerHTML = v}";
        jsCommand = String.format(Locale.US, jsCommand, this._handleId, this._tackId, this._value, this._min, this._max, this._inc, this._ouputId);
        if (this._disabled) {
            jsCommand = jsCommand + ",disabled:true";
        }
        jsCommand = jsCommand + ", onChange:function(value){$('%s').innerHTML = value; new Ajax.Request('%s/' + value,{method:'get', onFailure: function(){ alert('%s')}})}});";
        jsCommand = String.format(Locale.US, jsCommand, this._ouputId, this.getActionLink(), "Something went wrong...");
        this._pageRenderSupport.addScript(jsCommand);
    }

    @OnEvent(value="action")
    private void onAction(Number value) {
        this._value = value;
    }

    public Number getValue() {
        return this._value;
    }

    public void setValue(Number value) {
        this._value = value;
    }

    public String getActionLink() {
        return this._resources.createActionLink("action", false, new Object[0]).toURI();
    }

    private String getNumberPattern(Number value) {
        String numberPattern = "%d";
        if (value instanceof Float || value instanceof Double) {
            numberPattern = "%f";
        }
        return numberPattern;
    }

    public String getClientId() {
        return this._assignedClientId;
    }
}

