/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.components;

import javax.swing.text.MaskFormatter;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.slf4j.Logger;

@SupportsInformalParameters
public class MaskFormat {
    @Inject
    private Logger _logger;
    @Parameter(required=true)
    private String _value;
    @Parameter(required=true, defaultPrefix="literal")
    private String _mask;
    @Parameter(required=false, defaultPrefix="literal")
    private String _placeholder;
    @Parameter(required=false, defaultPrefix="literal")
    private String _validCharacters;
    @Inject
    private ComponentResources _resources;

    private String getFormatedValue() {
        try {
            MaskFormatter mf = new MaskFormatter(this._mask);
            mf.setValueContainsLiteralCharacters(false);
            if (this._placeholder != null) {
                mf.setPlaceholderCharacter(this._placeholder.toCharArray()[0]);
            }
            if (this._validCharacters != null) {
                mf.setValidCharacters(this._validCharacters);
            }
            return mf.valueToString(this._value);
        }
        catch (Exception e) {
            this._logger.error(e.getLocalizedMessage());
            return this._value;
        }
    }

    void beginRender(MarkupWriter writer) {
        String formattedValue = this.getFormatedValue();
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("parameter value: %s / transformed value: %s", (Object)this._value, (Object)formattedValue);
        }
        writer.element("span", new Object[0]);
        this._resources.renderInformalParameters(writer);
        writer.write(formattedValue);
        writer.end();
    }
}

