/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.base;

import org.apache.tapestry5.Asset;
import org.apache.tapestry5.ClientElement;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.RenderSupport;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.IncludeJavaScriptLibrary;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.services.SymbolSource;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.AssetSource;

@IncludeJavaScriptLibrary(value={"${tapestry.scriptaculous}/effects.js", "../components/window/window.js", "../components/window/window_effects.js"})
@IncludeStylesheet(value={"../components/window/themes/default.css"})
public abstract class AbstractWindow
implements ClientElement {
    @Parameter(value="prop:componentResources.id", defaultPrefix="literal")
    private String clientId;
    @Parameter(value="alphacube", defaultPrefix="literal", name="style")
    private String className;
    @Parameter(value="0", defaultPrefix="prop")
    private int width;
    @Parameter(value="0", defaultPrefix="prop")
    private int height;
    @Parameter(value="true", defaultPrefix="prop")
    private boolean show;
    @Parameter(value="true", defaultPrefix="prop")
    private boolean center;
    @Parameter(value="true", defaultPrefix="prop")
    private boolean modal;
    @Parameter(value="", defaultPrefix="prop")
    private String title;
    private String assignedClientId;
    @Environmental
    private RenderSupport renderSupport;
    @Inject
    private ComponentResources resources;
    @Inject
    private AssetSource assetSource;
    @Inject
    private SymbolSource symbolSource;

    void setupRender() {
        this.assignedClientId = this.renderSupport.allocateClientId(this.clientId);
    }

    void beginRender(MarkupWriter writer) {
        String scriptPathSymbolValue = this.symbolSource.expandSymbols("${ck.components}") + "/window/themes";
        String cssStyleFile = this.className.endsWith("lighting") ? "lighting.css" : (this.className.equals("dialog") ? "default.css" : (this.className.endsWith("_os_x") ? "mac_os_x.css" : this.className + ".css"));
        Asset cssAsset = this.assetSource.getClasspathAsset(scriptPathSymbolValue + "/" + cssStyleFile);
        this.renderSupport.addStylesheetLink(cssAsset, "screen");
    }

    protected void configure(JSONObject options) {
    }

    public String getClientId() {
        return this.assignedClientId;
    }

    public boolean isShow() {
        return this.show;
    }

    public boolean isCenter() {
        return this.center;
    }

    public boolean isModal() {
        return this.modal;
    }

    public String getClassName() {
        return this.className;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String getTitle() {
        return this.title;
    }
}

