/*
 * Decompiled with CFR 0.152.
 */
package morfologik.tools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import morfologik.tools.FSABuildTool;
import morfologik.tools.MorphEncoder;
import morfologik.tools.SharedOptions;
import morfologik.tools.Tool;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.StringEscapeUtils;

class MorphEncodingTool
extends Tool {
    private boolean prefixes = false;
    private boolean infixes = false;
    private boolean noWarn = false;
    private MorphEncoder encoder;

    MorphEncodingTool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void go(CommandLine line) throws Exception {
        this.noWarn = line.hasOption(SharedOptions.noWarnIfTwoFields.getOpt());
        this.infixes = line.hasOption(SharedOptions.infixEncoding.getOpt());
        if (!this.infixes) {
            this.prefixes = line.hasOption(SharedOptions.prefixEncoding.getOpt());
        }
        char separator = '+';
        if (line.hasOption(SharedOptions.annotationSeparatorCharacterOption.getLongOpt())) {
            String sep = line.getOptionValue(SharedOptions.annotationSeparatorCharacterOption.getLongOpt());
            if ((sep = StringEscapeUtils.unescapeJava((String)sep)).length() != 1) {
                throw new IllegalArgumentException("Field separator must be a single character: " + sep);
            }
            if (sep.charAt(0) > '\u00ff') {
                throw new IllegalArgumentException("Field separator not within byte range: " + sep.charAt(0));
            }
            separator = sep.charAt(0);
            FSABuildTool.checkSingleByte(Character.toString(separator));
        }
        this.encoder = new MorphEncoder((byte)separator);
        DataInputStream input = MorphEncodingTool.initializeInput(line);
        DataOutputStream output = MorphEncodingTool.initializeOutput(line);
        try {
            this.process(input, output);
            output.flush();
        }
        finally {
            input.close();
            output.close();
        }
    }

    private static byte[][] splitFields(byte[] line, int pos) {
        byte[][] outputArray = new byte[3][];
        int prevPos = 0;
        int arrayInd = 0;
        for (int i = 0; i < pos; ++i) {
            if (line[i] != 9) continue;
            outputArray[arrayInd] = new byte[i - prevPos];
            System.arraycopy(line, prevPos, outputArray[arrayInd], 0, i - prevPos);
            prevPos = i + 1;
            ++arrayInd;
        }
        return outputArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(DataInputStream input, DataOutputStream output) throws IOException {
        long lnumber = 0L;
        try {
            int bufPos = 0;
            byte[] buf = new byte[1048575];
            int dataByte = -1;
            while ((dataByte = input.read()) != -1) {
                if (dataByte == 10) {
                    ++lnumber;
                    buf[bufPos++] = 9;
                    byte[][] words = MorphEncodingTool.splitFields(buf, bufPos);
                    for (int i = 0; i < words.length; ++i) {
                        if (i < 1 && words[i] == null) {
                            throw new IllegalArgumentException("The input file has less than 2 tab-separated fields in line " + lnumber + ": " + new String(buf, "iso8859-1"));
                        }
                        if (words[i] != null || this.noWarn) continue;
                        System.err.println("Line number " + lnumber + " has less than 3 tab-separated fields: " + new String(buf, "iso8859-1"));
                    }
                    if (this.infixes) {
                        output.write(this.encoder.infixEncode(words[0], words[1], words[2]));
                    } else if (this.prefixes) {
                        output.write(this.encoder.prefixEncode(words[0], words[1], words[2]));
                    } else {
                        output.write(this.encoder.standardEncode(words[0], words[1], words[2]));
                    }
                    output.writeByte(10);
                    bufPos = 0;
                    continue;
                }
                if (dataByte == 13) continue;
                buf[bufPos++] = (byte)dataByte;
            }
        }
        finally {
            input.close();
        }
    }

    @Override
    protected void initializeOptions(Options options) {
        options.addOption(SharedOptions.inputFileOption);
        options.addOption(SharedOptions.outputFileOption);
        options.addOption(SharedOptions.standardEncoding);
        options.addOption(SharedOptions.prefixEncoding);
        options.addOption(SharedOptions.infixEncoding);
        options.addOption(SharedOptions.noWarnIfTwoFields);
        options.addOption(SharedOptions.annotationSeparatorCharacterOption);
    }

    private static DataOutputStream initializeOutput(CommandLine line) throws IOException, ParseException {
        String opt = SharedOptions.outputFileOption.getOpt();
        DataOutputStream output = line.hasOption(opt) ? new DataOutputStream(new BufferedOutputStream(new FileOutputStream((File)line.getParsedOptionValue(opt)))) : new DataOutputStream(new BufferedOutputStream(System.out));
        return output;
    }

    private static DataInputStream initializeInput(CommandLine line) throws IOException, ParseException {
        String opt = SharedOptions.inputFileOption.getOpt();
        DataInputStream input = line.hasOption(opt) ? new DataInputStream(new BufferedInputStream(new FileInputStream((File)line.getParsedOptionValue(opt)))) : new DataInputStream(new BufferedInputStream(System.in));
        return input;
    }

    public static void main(String[] args) throws Exception {
        MorphEncodingTool tool = new MorphEncodingTool();
        tool.go(args);
    }
}

