/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.internal;

import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.align.util.RotationAxis;
import org.biojava.nbio.structure.symmetry.internal.OrderDetector;
import org.biojava.nbio.structure.symmetry.internal.RefinerFailedException;

public class AngleOrderDetectorPlus
implements OrderDetector {
    private int maxOrder;
    private final double error;
    private boolean normalizeError;

    public AngleOrderDetectorPlus(double angleError) {
        this(8, angleError, false);
    }

    public AngleOrderDetectorPlus(int maxOrder) {
        this(maxOrder, Math.PI, false);
    }

    public AngleOrderDetectorPlus(int maxOrder, double angleError) {
        this(maxOrder, angleError, false);
    }

    public AngleOrderDetectorPlus(int maxOrder, double angleError, boolean normalize) {
        this.maxOrder = maxOrder;
        this.error = angleError;
        this.normalizeError = normalize;
    }

    @Override
    public int calculateOrder(AFPChain afpChain, Atom[] ca) throws RefinerFailedException {
        double tol = 1.0E-6;
        try {
            RotationAxis axis = new RotationAxis(afpChain);
            double theta = axis.getAngle();
            double bestDelta = this.error;
            int bestOrder = 1;
            for (int order = 1; order <= this.maxOrder; ++order) {
                double delta = Math.abs(Math.abs(theta * (double)order / (Math.PI * 2) - 0.5) % 1.0 - 0.5);
                if (!this.normalizeError) {
                    delta *= Math.PI * 2 / (double)order;
                }
                if (!(delta < bestDelta - 1.0E-6)) continue;
                bestOrder = order;
                bestDelta = delta;
            }
            return bestOrder;
        }
        catch (Exception e) {
            throw new RefinerFailedException(e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[maxOrder=" + this.maxOrder + ", error=" + this.error + ", normalizeError=" + this.normalizeError + "]";
    }
}

