/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.geometry;

import java.util.Arrays;
import java.util.List;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import org.biojava.nbio.structure.symmetry.geometry.Polyhedron;

public class RectangularPrism
implements Polyhedron {
    private static int[] lineLoop1 = new int[]{0, 1, 2, 3, 0, 4, 5, 6, 7, 4};
    private static int[] lineLoop2 = new int[]{1, 5};
    private static int[] lineLoop3 = new int[]{2, 6};
    private static int[] lineLoop4 = new int[]{3, 7};
    private double length = 1.0;
    private double width = 1.0;
    private double height = 1.0;
    private static String[] viewNames = new String[]{"Front", "Left", "Back", "Right", "Top", "Bottom"};

    public RectangularPrism(double length, double width, double height) {
        this.length = length;
        this.width = width;
        this.height = height;
    }

    public double getLength() {
        return this.length;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    @Override
    public double getCirumscribedRadius() {
        return 0.5 * Math.sqrt(this.width * this.width + this.height * this.height + this.length * this.length);
    }

    @Override
    public Point3d[] getVertices() {
        double x = 0.5 * this.width;
        double y = 0.5 * this.height;
        double z = 0.5 * this.length;
        Point3d[] vertices = new Point3d[]{new Point3d(-x, -y, z), new Point3d(-x, y, z), new Point3d(x, y, z), new Point3d(x, -y, z), new Point3d(-x, -y, -z), new Point3d(-x, y, -z), new Point3d(x, y, -z), new Point3d(x, -y, -z)};
        return vertices;
    }

    @Override
    public List<int[]> getLineLoops() {
        return Arrays.asList(lineLoop1, lineLoop2, lineLoop3, lineLoop4);
    }

    @Override
    public int getViewCount() {
        return viewNames.length;
    }

    @Override
    public String getViewName(int index) {
        return viewNames[index];
    }

    @Override
    public Matrix3d getViewMatrix(int index) {
        Matrix3d m = new Matrix3d();
        switch (index) {
            case 0: {
                m.setIdentity();
                break;
            }
            case 1: {
                m.rotY(1.5707963267948966);
                break;
            }
            case 2: {
                m.rotY(Math.PI);
                break;
            }
            case 3: {
                m.rotY(-1.5707963267948966);
                break;
            }
            case 4: {
                m.rotX(1.5707963267948966);
                break;
            }
            case 5: {
                m.rotX(-1.5707963267948966);
                break;
            }
            default: {
                throw new IllegalArgumentException("getViewMatrix: index out of range:" + index);
            }
        }
        return m;
    }
}

