/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.multiple.mc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.align.CallableStructureAlignment;
import org.biojava.nbio.structure.align.MultipleStructureAligner;
import org.biojava.nbio.structure.align.StructureAlignment;
import org.biojava.nbio.structure.align.ce.CeCPMain;
import org.biojava.nbio.structure.align.ce.ConfigStrucAligParams;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.align.multiple.Block;
import org.biojava.nbio.structure.align.multiple.BlockImpl;
import org.biojava.nbio.structure.align.multiple.BlockSetImpl;
import org.biojava.nbio.structure.align.multiple.MultipleAlignment;
import org.biojava.nbio.structure.align.multiple.MultipleAlignmentEnsemble;
import org.biojava.nbio.structure.align.multiple.MultipleAlignmentEnsembleImpl;
import org.biojava.nbio.structure.align.multiple.MultipleAlignmentImpl;
import org.biojava.nbio.structure.align.multiple.mc.MultipleMcOptimizer;
import org.biojava.nbio.structure.align.multiple.mc.MultipleMcParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleMcMain
implements MultipleStructureAligner {
    private static final Logger logger = LoggerFactory.getLogger(MultipleMcMain.class);
    public static final String version = "1.1";
    public static final String algorithmName = "jMultipleMC";
    private MultipleMcParameters params = new MultipleMcParameters();
    private MultipleAlignmentEnsemble ensemble = null;
    private StructureAlignment pairwise;
    private int reference = 0;

    public MultipleMcMain(StructureAlignment pairwiseAlgo) {
        this.pairwise = pairwiseAlgo;
        if (this.pairwise == null) {
            this.pairwise = new CeCPMain();
        }
    }

    private MultipleAlignment generateSeed(List<Atom[]> atomArrays) throws InterruptedException, ExecutionException, StructureException {
        int size = atomArrays.size();
        ArrayList<List<AFPChain>> afpAlignments = new ArrayList<List<AFPChain>>();
        for (int i = 0; i < size; ++i) {
            afpAlignments.add(new ArrayList());
            for (int j = 0; j < size; ++j) {
                ((List)afpAlignments.get(i)).add(null);
            }
        }
        int threads = this.params.getNrThreads();
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        ArrayList<Future<AFPChain>> afpFuture = new ArrayList<Future<AFPChain>>();
        for (int i = 0; i < size; ++i) {
            for (int j = i + 1; j < size; ++j) {
                CallableStructureAlignment worker = new CallableStructureAlignment(atomArrays.get(i), atomArrays.get(j), this.pairwise.getAlgorithmName(), this.pairwise.getParameters());
                Future<AFPChain> submit = executor.submit(worker);
                afpFuture.add(submit);
            }
        }
        int index = 0;
        for (int i = 0; i < size; ++i) {
            for (int j = i; j < size; ++j) {
                if (i == j) continue;
                ((List)afpAlignments.get(i)).add(j, ((Future)afpFuture.get(index)).get());
                ((List)afpAlignments.get(j)).add(i, ((Future)afpFuture.get(index)).get());
                ++index;
            }
        }
        executor.shutdown();
        this.reference = MultipleMcMain.chooseReferenceRMSD(afpAlignments);
        boolean flexible = false;
        if (this.pairwise.getAlgorithmName().contains("flexible")) {
            flexible = true;
        }
        return MultipleMcMain.combineReferenceAlignments((List)afpAlignments.get(this.reference), atomArrays, this.reference, flexible);
    }

    private static int chooseReferenceRMSD(List<List<AFPChain>> afpAlignments) {
        int size = afpAlignments.size();
        ArrayList<Double> RMSDs = new ArrayList<Double>();
        for (int i = 0; i < afpAlignments.size(); ++i) {
            double rmsd = 0.0;
            for (int j = 0; j < size; ++j) {
                if (i == j) continue;
                rmsd += afpAlignments.get(i).get(j).getTotalRmsdOpt();
            }
            RMSDs.add(rmsd);
        }
        int reference = 0;
        for (int i = 1; i < size; ++i) {
            if (!((Double)RMSDs.get(i) < (Double)RMSDs.get(reference))) continue;
            reference = i;
        }
        logger.info("Reference structure is " + reference);
        return reference;
    }

    private static MultipleAlignment combineReferenceAlignments(List<AFPChain> afpList, List<Atom[]> atomArrays, int ref, boolean flexible) throws StructureException {
        int str;
        int size = atomArrays.size();
        int length = 0;
        length = ref == 0 ? afpList.get(1).getCa1Length() : afpList.get(0).getCa2Length();
        TreeSet<Integer> flexibleBoundaries = new TreeSet<Integer>();
        ArrayList equivalencies = new ArrayList();
        for (str = 0; str < size; ++str) {
            equivalencies.add(new ArrayList());
            for (int res = 0; res < length; ++res) {
                if (str == ref) {
                    ((List)equivalencies.get(str)).add(res);
                    continue;
                }
                ((List)equivalencies.get(str)).add(null);
            }
        }
        for (str = 0; str < size; ++str) {
            if (str == ref) continue;
            for (int bk = 0; bk < afpList.get(str).getBlockNum(); ++bk) {
                for (int i = 0; i < afpList.get(str).getOptLen()[bk]; ++i) {
                    int res1 = 0;
                    int res2 = 0;
                    if (str > ref) {
                        res1 = afpList.get(str).getOptAln()[bk][0][i];
                        res2 = afpList.get(str).getOptAln()[bk][1][i];
                    } else if (str < ref) {
                        res1 = afpList.get(str).getOptAln()[bk][1][i];
                        res2 = afpList.get(str).getOptAln()[bk][0][i];
                    }
                    ((List)equivalencies.get(str)).set(res1, res2);
                    if (!flexible || i != 0) continue;
                    flexibleBoundaries.add(res1);
                }
            }
        }
        MultipleAlignmentImpl seed = new MultipleAlignmentImpl();
        seed.getEnsemble().setAtomArrays(atomArrays);
        BlockSetImpl blockSet = new BlockSetImpl(seed);
        new BlockImpl(blockSet);
        int[] lastResidues = new int[size];
        Arrays.fill(lastResidues, -1);
        for (int pos = 0; pos < length; ++pos) {
            int str2;
            if (flexibleBoundaries.contains(pos) && blockSet.getBlocks().get(blockSet.getBlocks().size() - 1).getAlignRes() != null) {
                blockSet = new BlockSetImpl(seed);
                new BlockImpl(blockSet);
            }
            boolean cp = false;
            for (str2 = 0; str2 < size; ++str2) {
                if (((List)equivalencies.get(str2)).get(pos) == null) continue;
                if ((Integer)((List)equivalencies.get(str2)).get(pos) < lastResidues[str2]) {
                    cp = true;
                    break;
                }
                lastResidues[str2] = (Integer)((List)equivalencies.get(str2)).get(pos);
            }
            if (cp) {
                new BlockImpl(blockSet);
                Arrays.fill(lastResidues, -1);
            }
            for (str2 = 0; str2 < size; ++str2) {
                Block lastB = blockSet.getBlocks().get(blockSet.getBlocks().size() - 1);
                if (lastB.getAlignRes() == null) {
                    ArrayList<List<Integer>> alnRes = new ArrayList<List<Integer>>(size);
                    for (int k = 0; k < size; ++k) {
                        alnRes.add(new ArrayList());
                    }
                    lastB.setAlignRes(alnRes);
                }
                lastB.getAlignRes().get(str2).add((Integer)((List)equivalencies.get(str2)).get(pos));
            }
        }
        logger.info("Seed alignment has " + seed.getBlocks() + " Blocks.");
        return seed;
    }

    @Override
    public MultipleAlignment align(List<Atom[]> atomArrays, Object parameters) throws StructureException {
        MultipleAlignment result = null;
        this.ensemble = new MultipleAlignmentEnsembleImpl();
        this.ensemble.setAtomArrays(atomArrays);
        this.ensemble.setAlgorithmName(algorithmName);
        this.ensemble.setVersion(version);
        this.ensemble.setIoTime(System.currentTimeMillis());
        this.setParameters((ConfigStrucAligParams)parameters);
        try {
            result = this.generateSeed(atomArrays);
        }
        catch (InterruptedException e) {
            logger.warn("Seed generation failed.", (Throwable)e);
        }
        catch (ExecutionException e) {
            logger.warn("Seed generation failed.", (Throwable)e);
        }
        MultipleMcOptimizer optimizer = new MultipleMcOptimizer(result, this.params, this.reference);
        Long runtime = System.currentTimeMillis() - this.ensemble.getIoTime();
        this.ensemble.setCalculationTime(runtime);
        result = optimizer.optimize();
        result.setEnsemble(this.ensemble);
        this.ensemble.addMultipleAlignment(result);
        return result;
    }

    @Override
    public MultipleAlignment align(List<Atom[]> atomArrays) throws StructureException {
        if (this.params == null) {
            logger.info("Using DEFAULT MultipleMc Parameters");
            this.params = new MultipleMcParameters();
        }
        return this.align(atomArrays, this.params);
    }

    @Override
    public ConfigStrucAligParams getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(ConfigStrucAligParams parameters) {
        if (!(parameters instanceof MultipleMcParameters)) {
            throw new IllegalArgumentException("Provided parameter object is not of type MultipleMC");
        }
        this.params = (MultipleMcParameters)parameters;
    }

    @Override
    public String getAlgorithmName() {
        return algorithmName;
    }

    @Override
    public String getVersion() {
        return version;
    }
}

