/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.ontology.utils;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.nbio.ontology.utils.KeyedWeakReference;

public class WeakValueHashMap
extends AbstractMap {
    private final Map keyToRefMap = new HashMap();
    private final ReferenceQueue queue = new ReferenceQueue();
    private final Set iteratorRefs = new HashSet();
    private final ReferenceQueue iteratorRefQueue = new ReferenceQueue();

    private void diddleReferenceQueue() {
        KeyedWeakReference ref;
        if (this.iteratorRefs.size() > 0) {
            while ((ref = this.iteratorRefQueue.poll()) != null) {
                this.iteratorRefs.remove(ref);
            }
            if (this.iteratorRefs.size() > 0) {
                return;
            }
        }
        while ((ref = (KeyedWeakReference)this.queue.poll()) != null) {
            this.keyToRefMap.remove(ref.getKey());
        }
    }

    @Override
    public Object put(Object key, Object value) {
        this.diddleReferenceQueue();
        Reference oldRef = this.keyToRefMap.put(key, new KeyedWeakReference(key, value, this.queue));
        if (oldRef != null) {
            Object oldRefVal = oldRef.get();
            oldRef.clear();
            return oldRefVal;
        }
        return null;
    }

    @Override
    public Object get(Object key) {
        Reference ref = (Reference)this.keyToRefMap.get(key);
        if (ref != null) {
            return ref.get();
        }
        return null;
    }

    @Override
    public boolean containsKey(Object o) {
        this.diddleReferenceQueue();
        return this.keyToRefMap.containsKey(o);
    }

    @Override
    public Set entrySet() {
        this.diddleReferenceQueue();
        return new WVEntrySet();
    }

    private class WVEntrySet
    extends AbstractSet {
        private Set keyRefEntrySet;

        public WVEntrySet() {
            this.keyRefEntrySet = WeakValueHashMap.this.keyToRefMap.entrySet();
        }

        @Override
        public int size() {
            return this.keyRefEntrySet.size();
        }

        @Override
        public Iterator iterator() {
            WVEntryIterator i = new WVEntryIterator(this.keyRefEntrySet.iterator());
            WeakValueHashMap.this.iteratorRefs.add(new PhantomReference<WVEntryIterator>(i, WeakValueHashMap.this.iteratorRefQueue));
            return i;
        }
    }

    private static class WVMapEntry
    implements Map.Entry {
        private Object key;
        private Object value;

        private WVMapEntry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry mo = (Map.Entry)o;
            return (this.key == null ? mo.getKey() == null : this.key.equals(mo.getKey())) && (this.value == null ? mo.getValue() == null : this.value.equals(mo.getValue()));
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }
    }

    private class WVEntryIterator
    implements Iterator {
        private Object cache;
        private Iterator keyRefIterator;

        public WVEntryIterator(Iterator keyRefIterator) {
            this.keyRefIterator = keyRefIterator;
        }

        @Override
        public boolean hasNext() {
            if (this.cache == null) {
                this.primeCache();
            }
            return this.cache != null;
        }

        public Object next() {
            if (this.cache == null) {
                this.primeCache();
            }
            if (this.cache == null) {
                throw new NoSuchElementException();
            }
            Object o = this.cache;
            this.cache = null;
            return o;
        }

        @Override
        public void remove() {
            if (this.cache != null) {
                throw new IllegalStateException("next() not called");
            }
            this.keyRefIterator.remove();
        }

        private void primeCache() {
            while (this.keyRefIterator.hasNext()) {
                Map.Entry krme = (Map.Entry)this.keyRefIterator.next();
                Object ref = ((Reference)krme.getValue()).get();
                if (ref == null) continue;
                this.cache = new WVMapEntry(krme.getKey(), ref);
                return;
            }
        }
    }
}

