/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message.token;

import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoType;
import org.apache.ws.security.message.CallbackLookup;
import org.apache.ws.security.message.DOMCallbackLookup;
import org.apache.ws.security.message.token.DOMX509Data;
import org.apache.ws.security.message.token.DOMX509IssuerSerial;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.message.token.X509Security;
import org.apache.ws.security.util.Base64;
import org.apache.ws.security.util.DOM2Writer;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class SecurityTokenReference {
    public static final String SECURITY_TOKEN_REFERENCE = "SecurityTokenReference";
    public static final QName STR_QNAME = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "SecurityTokenReference");
    public static final String SKI_URI = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier";
    public static final String THUMB_URI = "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1";
    public static final String ENC_KEY_SHA1_URI = "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKeySHA1";
    private static Log log = LogFactory.getLog(SecurityTokenReference.class);
    protected Element element = null;
    private DOMX509IssuerSerial issuerSerial = null;
    private byte[] skiBytes = null;
    private static boolean doDebug = false;
    private Reference reference = null;

    public SecurityTokenReference(Element elem) throws WSSecurityException {
        this(elem, true);
    }

    public SecurityTokenReference(Element elem, boolean bspCompliant) throws WSSecurityException {
        doDebug = log.isDebugEnabled();
        this.element = elem;
        QName el = new QName(this.element.getNamespaceURI(), this.element.getLocalName());
        if (!STR_QNAME.equals(el)) {
            throw new WSSecurityException(0, "badElement", null);
        }
        if (bspCompliant) {
            this.checkBSPCompliance();
        }
        if (this.containsReference()) {
            for (Node node = this.element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (1 != node.getNodeType() || !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(node.getNamespaceURI()) || !"Reference".equals(node.getLocalName())) continue;
                this.reference = new Reference((Element)node);
                break;
            }
        }
    }

    public SecurityTokenReference(Document doc) {
        doDebug = log.isDebugEnabled();
        this.element = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:SecurityTokenReference");
    }

    public void addWSSENamespace() {
        WSSecurityUtil.setNamespace(this.element, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse");
    }

    public void addWSUNamespace() {
        WSSecurityUtil.setNamespace(this.element, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
    }

    public void addTokenType(String tokenType) {
        WSSecurityUtil.setNamespace(this.element, "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "wsse11");
        this.element.setAttributeNS("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "wsse11:TokenType", tokenType);
    }

    public String getTokenType() {
        return this.element.getAttributeNS("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "TokenType");
    }

    public void setReference(Reference ref) {
        Element elem = this.getFirstElement();
        if (elem != null) {
            this.element.replaceChild(ref.getElement(), elem);
        } else {
            this.element.appendChild(ref.getElement());
        }
        this.reference = ref;
    }

    public Reference getReference() throws WSSecurityException {
        return this.reference;
    }

    public Element getTokenElement(Document doc, WSDocInfo docInfo, CallbackHandler cb) throws WSSecurityException {
        Reference ref = this.getReference();
        String uri = null;
        String valueType = null;
        if (ref != null) {
            uri = ref.getURI();
            valueType = ref.getValueType();
        } else {
            uri = this.getKeyIdentifierValue();
            valueType = this.getKeyIdentifierValueType();
        }
        if (doDebug) {
            log.debug((Object)("Token reference uri: " + uri));
        }
        if (uri == null) {
            throw new WSSecurityException(3, "badReferenceURI");
        }
        Element tokElement = this.findProcessedTokenElement(doc, docInfo, cb, uri, valueType);
        if (tokElement == null) {
            tokElement = this.findUnprocessedTokenElement(doc, docInfo, cb, uri, valueType);
        }
        if (tokElement == null) {
            throw new WSSecurityException(7, "noToken", new Object[]{uri});
        }
        return tokElement;
    }

    public Element findUnprocessedTokenElement(Document doc, WSDocInfo docInfo, CallbackHandler cb, String uri, String type) throws WSSecurityException {
        CallbackLookup callbackLookup;
        String id = uri;
        if (id.charAt(0) == '#') {
            id = id.substring(1);
        }
        if ((callbackLookup = docInfo.getCallbackLookup()) == null) {
            callbackLookup = new DOMCallbackLookup(doc);
        }
        return callbackLookup.getElement(uri, type, true);
    }

    public Element findProcessedTokenElement(Document doc, WSDocInfo docInfo, CallbackHandler cb, String uri, String type) throws WSSecurityException {
        Element token;
        String id = uri;
        if (id.charAt(0) == '#') {
            id = id.substring(1);
        }
        if (docInfo != null && (token = docInfo.getTokenElement(id)) != null) {
            return token;
        }
        if (cb != null && "http://schemas.xmlsoap.org/ws/2005/02/sc/sct".equals(type) || "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(type) || "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID".equals(type)) {
            WSPasswordCallback pwcb = new WSPasswordCallback(id, 7);
            try {
                cb.handle(new Callback[]{pwcb});
                Element assertionElem = pwcb.getCustomToken();
                if (assertionElem != null) {
                    return (Element)doc.importNode(assertionElem, true);
                }
            }
            catch (Exception e) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public void setKeyIdentifier(X509Certificate cert) throws WSSecurityException {
        Document doc = this.element.getOwnerDocument();
        byte[] data = null;
        try {
            data = cert.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new WSSecurityException(7, "encodeError", null, e);
        }
        Text text = doc.createTextNode(Base64.encode(data));
        this.createKeyIdentifier(doc, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3", text, true);
    }

    public void setKeyIdentifierSKI(X509Certificate cert, Crypto crypto) throws WSSecurityException {
        if (cert.getVersion() != 3) {
            throw new WSSecurityException(1, "invalidCertForSKI", new Object[]{new Integer(cert.getVersion())});
        }
        Document doc = this.element.getOwnerDocument();
        byte[] data = crypto.getSKIBytesFromCert(cert);
        Text text = doc.createTextNode(Base64.encode(data));
        this.createKeyIdentifier(doc, SKI_URI, text, true);
    }

    public void setKeyIdentifierThumb(X509Certificate cert) throws WSSecurityException {
        Document doc = this.element.getOwnerDocument();
        byte[] encodedCert = null;
        try {
            encodedCert = cert.getEncoded();
        }
        catch (CertificateEncodingException e1) {
            throw new WSSecurityException(7, "encodeError", null, e1);
        }
        try {
            byte[] encodedBytes = WSSecurityUtil.generateDigest(encodedCert);
            Text text = doc.createTextNode(Base64.encode(encodedBytes));
            this.createKeyIdentifier(doc, THUMB_URI, text, true);
        }
        catch (WSSecurityException e1) {
            throw new WSSecurityException(0, "noSHA1availabe", null, e1);
        }
    }

    public void setKeyIdentifierEncKeySHA1(String value) throws WSSecurityException {
        Document doc = this.element.getOwnerDocument();
        Text text = doc.createTextNode(value);
        this.createKeyIdentifier(doc, ENC_KEY_SHA1_URI, text, true);
    }

    public void setKeyIdentifier(String valueType, String keyIdVal) throws WSSecurityException {
        this.setKeyIdentifier(valueType, keyIdVal, false);
    }

    public void setKeyIdentifier(String valueType, String keyIdVal, boolean base64) throws WSSecurityException {
        Document doc = this.element.getOwnerDocument();
        this.createKeyIdentifier(doc, valueType, doc.createTextNode(keyIdVal), base64);
    }

    private void createKeyIdentifier(Document doc, String uri, Node node, boolean base64) {
        Element keyId = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:KeyIdentifier");
        keyId.setAttributeNS(null, "ValueType", uri);
        if (base64) {
            keyId.setAttributeNS(null, "EncodingType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
        }
        keyId.appendChild(node);
        Element elem = this.getFirstElement();
        if (elem != null) {
            this.element.replaceChild(keyId, elem);
        } else {
            this.element.appendChild(keyId);
        }
    }

    public Element getFirstElement() {
        for (Node currentChild = this.element.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            if (1 != currentChild.getNodeType()) continue;
            return (Element)currentChild;
        }
        return null;
    }

    public X509Certificate[] getKeyIdentifier(Crypto crypto) throws WSSecurityException {
        Element elem = this.getFirstElement();
        String value = elem.getAttribute("ValueType");
        if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3".equals(value)) {
            X509Security token = new X509Security(elem);
            if (token != null) {
                X509Certificate cert = token.getX509Certificate(crypto);
                return new X509Certificate[]{cert};
            }
        } else {
            if (SKI_URI.equals(value)) {
                X509Certificate cert = this.getX509SKIAlias(crypto);
                return new X509Certificate[]{cert};
            }
            if (THUMB_URI.equals(value)) {
                Node node = this.getFirstElement().getFirstChild();
                if (node == null) {
                    return null;
                }
                if (3 == node.getNodeType()) {
                    byte[] thumb = Base64.decode(((Text)node).getData());
                    CryptoType cryptoType = new CryptoType(CryptoType.TYPE.THUMBPRINT_SHA1);
                    cryptoType.setBytes(thumb);
                    X509Certificate[] certs = crypto.getX509Certificates(cryptoType);
                    if (certs != null) {
                        return new X509Certificate[]{certs[0]};
                    }
                }
            }
        }
        return null;
    }

    public String getKeyIdentifierValue() {
        if (this.containsKeyIdentifier()) {
            Node node = this.getFirstElement().getFirstChild();
            if (node == null) {
                return null;
            }
            if (node.getNodeType() == 3) {
                return ((Text)node).getData();
            }
        }
        return null;
    }

    public String getKeyIdentifierValueType() {
        if (this.containsKeyIdentifier()) {
            Element elem = this.getFirstElement();
            return elem.getAttribute("ValueType");
        }
        return null;
    }

    public String getKeyIdentifierEncodingType() {
        if (this.containsKeyIdentifier()) {
            Element elem = this.getFirstElement();
            return elem.getAttribute("EncodingType");
        }
        return null;
    }

    public X509Certificate getX509SKIAlias(Crypto crypto) throws WSSecurityException {
        if (this.skiBytes == null) {
            this.skiBytes = this.getSKIBytes();
            if (this.skiBytes == null) {
                return null;
            }
        }
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.SKI_BYTES);
        cryptoType.setBytes(this.skiBytes);
        X509Certificate[] certs = crypto.getX509Certificates(cryptoType);
        if (certs != null) {
            return certs[0];
        }
        return null;
    }

    public byte[] getSKIBytes() {
        if (this.skiBytes != null) {
            return this.skiBytes;
        }
        Node node = this.getFirstElement().getFirstChild();
        if (node == null) {
            return null;
        }
        if (node.getNodeType() == 3) {
            try {
                this.skiBytes = Base64.decode(((Text)node).getData());
            }
            catch (WSSecurityException e) {
                return null;
            }
        }
        return this.skiBytes;
    }

    public void setX509Data(DOMX509Data domX509Data) {
        Element elem = this.getFirstElement();
        if (elem != null) {
            this.element.replaceChild(domX509Data.getElement(), elem);
        } else {
            this.element.appendChild(domX509Data.getElement());
        }
    }

    public void setUnknownElement(Element unknownElement) {
        Element elem = this.getFirstElement();
        if (elem != null) {
            this.element.replaceChild(unknownElement, elem);
        } else {
            this.element.appendChild(unknownElement);
        }
    }

    public X509Certificate[] getX509IssuerSerial(Crypto crypto) throws WSSecurityException {
        if (this.issuerSerial == null) {
            this.issuerSerial = this.getIssuerSerial();
            if (this.issuerSerial == null) {
                return null;
            }
        }
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ISSUER_SERIAL);
        cryptoType.setIssuerSerial(this.issuerSerial.getIssuer(), this.issuerSerial.getSerialNumber());
        return crypto.getX509Certificates(cryptoType);
    }

    private DOMX509IssuerSerial getIssuerSerial() throws WSSecurityException {
        if (this.issuerSerial != null) {
            return this.issuerSerial;
        }
        Element elem = this.getFirstElement();
        if (elem == null) {
            return null;
        }
        if ("X509Data".equals(elem.getLocalName())) {
            elem = WSSecurityUtil.findElement(elem, "X509IssuerSerial", "http://www.w3.org/2000/09/xmldsig#");
        }
        this.issuerSerial = new DOMX509IssuerSerial(elem);
        return this.issuerSerial;
    }

    public boolean containsReference() {
        return this.lengthReference() > 0;
    }

    public int lengthReference() {
        return this.length("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Reference");
    }

    public boolean containsX509IssuerSerial() {
        return this.lengthX509IssuerSerial() > 0;
    }

    public boolean containsX509Data() {
        return this.lengthX509Data() > 0;
    }

    public int lengthX509IssuerSerial() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "X509IssuerSerial");
    }

    public int lengthX509Data() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "X509Data");
    }

    public boolean containsKeyIdentifier() {
        return this.lengthKeyIdentifier() > 0;
    }

    public int lengthKeyIdentifier() {
        return this.length("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "KeyIdentifier");
    }

    public int length(String namespace, String localname) {
        int result = 0;
        for (Node node = this.element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (1 != node.getNodeType()) continue;
            String ns = node.getNamespaceURI();
            String name = node.getLocalName();
            if ((namespace == null || !namespace.equals(ns)) && (namespace != null || ns != null) || !localname.equals(name)) continue;
            ++result;
        }
        return result;
    }

    public Element getElement() {
        return this.element;
    }

    public void setID(String id) {
        this.element.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", id);
    }

    public String getID() {
        return this.element.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
    }

    public String toString() {
        return DOM2Writer.nodeToString(this.element);
    }

    private void checkBSPCompliance() throws WSSecurityException {
        Node node;
        int result = 0;
        Node child = null;
        for (node = this.element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (1 != node.getNodeType()) continue;
            ++result;
            child = (Element)node;
        }
        if (result != 1) {
            throw new WSSecurityException(3, "invalidDataRef");
        }
        if ("KeyIdentifier".equals(child.getLocalName()) && "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(child.getNamespaceURI())) {
            String valueType = this.getKeyIdentifierValueType();
            if (valueType == null || "".equals(valueType)) {
                throw new WSSecurityException(3, "invalidValueType");
            }
            String encodingType = this.getFirstElement().getAttribute("EncodingType");
            if (encodingType != null && !"".equals(encodingType) && !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary".equals(encodingType)) {
                throw new WSSecurityException(3, "badEncodingType", new Object[]{encodingType});
            }
            if (!("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(valueType) || "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID".equals(valueType) || encodingType != null && !"".equals(encodingType))) {
                throw new WSSecurityException(3, "noEncodingType");
            }
        } else if ("Embedded".equals(child.getLocalName())) {
            result = 0;
            for (node = child.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (1 != node.getNodeType()) continue;
                ++result;
                if (!SECURITY_TOKEN_REFERENCE.equals(node.getLocalName()) || !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(node.getNamespaceURI())) continue;
                throw new WSSecurityException(3, "invalidEmbeddedRef");
            }
            if (result != 1) {
                throw new WSSecurityException(3, "invalidEmbeddedRef");
            }
        }
    }
}

