/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.message.CallbackLookup;
import org.apache.ws.security.message.DOMCallbackLookup;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EnvelopeIdResolver
extends ResourceResolverSpi {
    private static Log log = LogFactory.getLog(EnvelopeIdResolver.class);
    private boolean doDebug = false;
    private WSDocInfo wsDocInfo;

    public void setWsDocInfo(WSDocInfo docInfo) {
        this.wsDocInfo = docInfo;
    }

    public XMLSignatureInput engineResolve(Attr uri, String BaseURI) throws ResourceResolverException {
        this.doDebug = log.isDebugEnabled();
        String uriNodeValue = uri.getNodeValue();
        if (this.doDebug) {
            log.debug((Object)("enter engineResolve, look for: " + uriNodeValue));
        }
        String id = uriNodeValue.substring(1);
        Element selectedElem = null;
        if (this.wsDocInfo != null) {
            selectedElem = this.wsDocInfo.getProtectionElement(id);
        }
        if (selectedElem == null && this.wsDocInfo != null) {
            selectedElem = this.wsDocInfo.getTokenElement(id);
        }
        if (selectedElem == null && (id != null || "".equals(id))) {
            CallbackLookup callbackLookup = null;
            if (this.wsDocInfo != null) {
                callbackLookup = this.wsDocInfo.getCallbackLookup();
            }
            if (callbackLookup == null) {
                callbackLookup = new DOMCallbackLookup(uri.getOwnerDocument());
            }
            try {
                selectedElem = callbackLookup.getElement(id, null, true);
            }
            catch (WSSecurityException ex) {
                throw new ResourceResolverException(ex.getMessage(), new Object[]{"Id: " + id + " not found"}, uri, BaseURI);
            }
            if (selectedElem == null) {
                throw new ResourceResolverException("generic.EmptyMessage", new Object[]{"Id: " + id + " not found"}, uri, BaseURI);
            }
        }
        XMLSignatureInput result = new XMLSignatureInput((Node)selectedElem);
        result.setMIMEType("text/xml");
        if (this.doDebug) {
            log.debug((Object)("exit engineResolve, result: " + result));
        }
        return result;
    }

    public boolean engineCanResolve(Attr uri, String BaseURI) {
        if (uri == null) {
            return false;
        }
        String uriNodeValue = uri.getNodeValue();
        return uriNodeValue.startsWith("#");
    }
}

