/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.components.crypto;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.util.WSSecurityUtil;

public abstract class CryptoBase
implements Crypto {
    public static final String SKI_OID = "2.5.29.14";
    public static final String NAME_CONSTRAINTS_OID = "2.5.29.30";
    private static final Constructor<?> BC_509CLASS_CONS;
    protected Map<String, CertificateFactory> certFactMap = new HashMap<String, CertificateFactory>();
    protected String defaultAlias = null;
    protected String cryptoProvider = null;

    protected CryptoBase() {
    }

    public String getCryptoProvider() {
        return this.cryptoProvider;
    }

    public void setCryptoProvider(String provider) {
        this.cryptoProvider = provider;
    }

    public String getDefaultX509Identifier() throws WSSecurityException {
        return this.defaultAlias;
    }

    public void setDefaultX509Identifier(String identifier) {
        this.defaultAlias = identifier;
    }

    public void setCertificateFactory(String provider, CertificateFactory certFactory) {
        if (provider == null || provider.length() == 0) {
            this.certFactMap.put(certFactory.getProvider().getName(), certFactory);
        } else {
            this.certFactMap.put(provider, certFactory);
        }
    }

    public CertificateFactory getCertificateFactory() throws WSSecurityException {
        String provider = this.getCryptoProvider();
        CertificateFactory factory = null;
        factory = provider != null && provider.length() != 0 ? this.certFactMap.get(provider) : this.certFactMap.get("DEFAULT");
        if (factory == null) {
            try {
                if (provider == null || provider.length() == 0) {
                    factory = CertificateFactory.getInstance("X.509");
                    this.certFactMap.put("DEFAULT", factory);
                } else {
                    factory = CertificateFactory.getInstance("X.509", provider);
                    this.certFactMap.put(provider, factory);
                }
                this.certFactMap.put(factory.getProvider().getName(), factory);
            }
            catch (CertificateException e) {
                throw new WSSecurityException(7, "unsupportedCertType", null, e);
            }
            catch (NoSuchProviderException e) {
                throw new WSSecurityException(7, "noSecProvider", null, e);
            }
        }
        return factory;
    }

    public X509Certificate loadCertificate(InputStream in) throws WSSecurityException {
        try {
            CertificateFactory certFactory = this.getCertificateFactory();
            return (X509Certificate)certFactory.generateCertificate(in);
        }
        catch (CertificateException e) {
            throw new WSSecurityException(7, "parseError", null, e);
        }
    }

    public byte[] getSKIBytesFromCert(X509Certificate cert) throws WSSecurityException {
        byte[] derEncodedValue = cert.getExtensionValue(SKI_OID);
        if (cert.getVersion() < 3 || derEncodedValue == null) {
            PublicKey key = cert.getPublicKey();
            if (!(key instanceof RSAPublicKey)) {
                throw new WSSecurityException(1, "noSKIHandling", new Object[]{"Support for RSA key only"});
            }
            byte[] encoded = key.getEncoded();
            byte[] value = new byte[encoded.length - 22];
            System.arraycopy(encoded, 22, value, 0, value.length);
            try {
                return WSSecurityUtil.generateDigest(value);
            }
            catch (WSSecurityException ex) {
                throw new WSSecurityException(1, "noSKIHandling", new Object[]{"Wrong certificate version (<3) and no SHA1 message digest available"}, ex);
            }
        }
        byte[] abyte0 = new byte[derEncodedValue.length - 4];
        System.arraycopy(derEncodedValue, 4, abyte0, 0, abyte0.length);
        return abyte0;
    }

    public byte[] getBytesFromCertificates(X509Certificate[] certs) throws WSSecurityException {
        try {
            CertPath path = this.getCertificateFactory().generateCertPath(Arrays.asList(certs));
            return path.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new WSSecurityException(7, "encodeError", null, e);
        }
        catch (CertificateException e) {
            throw new WSSecurityException(7, "parseError", null, e);
        }
    }

    public X509Certificate[] getCertificatesFromBytes(byte[] data) throws WSSecurityException {
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        CertPath path = null;
        try {
            path = this.getCertificateFactory().generateCertPath(in);
        }
        catch (CertificateException e) {
            throw new WSSecurityException(7, "parseError", null, e);
        }
        List<? extends Certificate> l = path.getCertificates();
        X509Certificate[] certs = new X509Certificate[l.size()];
        int i = 0;
        Iterator<? extends Certificate> iterator = l.iterator();
        while (iterator.hasNext()) {
            certs[i++] = (X509Certificate)iterator.next();
        }
        return certs;
    }

    protected Object createBCX509Name(String s) {
        if (BC_509CLASS_CONS != null) {
            try {
                return BC_509CLASS_CONS.newInstance(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new X500Principal(s);
    }

    static {
        Constructor<?> cons = null;
        try {
            Class<?> c = Class.forName("org.bouncycastle.asn1.x509.X509Name");
            cons = c.getConstructor(String.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        BC_509CLASS_CONS = cons;
    }
}

