/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.client.handlers;

import org.apache.commons.codec.binary.Base64;
import org.apache.wink.client.ClientAuthenticationException;
import org.apache.wink.client.ClientRequest;
import org.apache.wink.client.ClientResponse;
import org.apache.wink.client.handlers.ClientHandler;
import org.apache.wink.client.handlers.HandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAuthSecurityHandler
implements ClientHandler {
    private static Logger logger = LoggerFactory.getLogger(BasicAuthSecurityHandler.class);
    private volatile String handlerUsername = null;
    private volatile String handlerPassword = null;

    public void setUserName(String aUserName) {
        logger.debug("Setting the username to {}", (Object)aUserName);
        this.handlerUsername = aUserName;
    }

    public void setPassword(String aPassword) {
        logger.debug("Setting the password");
        this.handlerPassword = aPassword;
    }

    public ClientResponse handle(ClientRequest request, HandlerContext context) throws Exception {
        logger.debug("Entering BasicAuthSecurityHandler.doChain()");
        ClientResponse response = context.doChain(request);
        int statusCode = response.getStatusCode();
        logger.debug("Response status code was {}", (Object)statusCode);
        if (statusCode != 401) {
            logger.debug("Status code was not 401 so no need to re-issue request.");
            return response;
        }
        String userid = this.handlerUsername;
        String password = this.handlerPassword;
        if (logger.isDebugEnabled()) {
            logger.debug("The 'username' property was set to: {}", (Object)userid);
            logger.debug("Was the 'password' property set: {}", (Object)(password != null ? 1 : 0));
        }
        if (userid != null && !userid.equals("") && password != null && !password.equals("")) {
            logger.debug("userid and password set so setting Authorization header");
            String credential = userid + ":" + password;
            byte[] credBytes = credential.getBytes();
            byte[] encodedCredBytes = Base64.encodeBase64((byte[])credBytes, (boolean)false);
            String credEncodedString = "Basic " + new String(encodedCredBytes);
            request.getHeaders().putSingle((Object)"Authorization", (Object)credEncodedString);
            logger.debug("Issuing request again with Authorization header");
            response = context.doChain(request);
            if (response.getStatusCode() == 401) {
                logger.debug("After sending request with Authorization header, still got 401 response");
                throw new ClientAuthenticationException("Service failed to authenticate user: " + userid);
            }
            logger.debug("Got a non-401 response, so returning response");
            return response;
        }
        logger.debug("userid and/or password were not set so throwing exception");
        throw new ClientAuthenticationException("Missing client authentication credential for user: " + userid);
    }
}

