/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.util.List;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Flow;
import org.apache.tapestry5.func.Worker;
import org.apache.tapestry5.ioc.internal.services.ServiceMessages;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.OneShotLock;
import org.apache.tapestry5.ioc.services.RegistryShutdownHub;
import org.apache.tapestry5.ioc.services.RegistryShutdownListener;
import org.slf4j.Logger;

public class RegistryShutdownHubImpl
implements RegistryShutdownHub {
    private final OneShotLock lock = new OneShotLock();
    private final Logger logger;
    private final List<Runnable> listeners = CollectionFactory.newThreadSafeList();
    private final List<Runnable> preListeners = CollectionFactory.newThreadSafeList();

    public RegistryShutdownHubImpl(Logger logger) {
        this.logger = logger;
    }

    public void addRegistryShutdownListener(final RegistryShutdownListener listener) {
        assert (listener != null);
        this.addRegistryShutdownListener(new Runnable(){

            public void run() {
                listener.registryDidShutdown();
            }
        });
    }

    public void addRegistryShutdownListener(Runnable listener) {
        assert (listener != null);
        this.lock.check();
        this.listeners.add(listener);
    }

    public void addRegistryWillShutdownListener(Runnable listener) {
        assert (listener != null);
        this.lock.check();
        this.preListeners.add(listener);
    }

    public void fireRegistryDidShutdown() {
        this.lock.lock();
        ((Flow)F.flow(this.preListeners).concat(this.listeners)).each((Worker)new Worker<Runnable>(){

            public void work(Runnable element) {
                try {
                    element.run();
                }
                catch (RuntimeException ex) {
                    RegistryShutdownHubImpl.this.logger.error(ServiceMessages.shutdownListenerError(element, ex), (Throwable)ex);
                }
            }
        });
        this.preListeners.clear();
        this.listeners.clear();
    }
}

