/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal;

import org.apache.tapestry5.ioc.Invokable;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.internal.OperationException;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.util.Stack;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationTrackerImpl
implements OperationTracker {
    private final Logger logger;
    private final Stack<String> operations = CollectionFactory.newStack();
    private boolean logged;

    public OperationTrackerImpl(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void run(String description, final Runnable operation) {
        assert (InternalUtils.isNonBlank(description));
        assert (operation != null);
        this.invoke(description, new Invokable<Void>(){

            @Override
            public Void invoke() {
                operation.run();
                return null;
            }
        });
    }

    @Override
    public <T> T invoke(String description, Invokable<T> operation) {
        assert (InternalUtils.isNonBlank(description));
        assert (operation != null);
        long startNanos = System.nanoTime();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("[%3d] --> %s", this.operations.getDepth() + 1, description));
        }
        this.operations.push(description);
        try {
            T result = operation.invoke();
            if (this.logger.isDebugEnabled()) {
                long elapsedNanos = System.nanoTime() - startNanos;
                double elapsedMillis = (double)elapsedNanos / 1000000.0;
                this.logger.debug(String.format("[%3d] <-- %s [%,.2f ms]", this.operations.getDepth(), description, elapsedMillis));
            }
            T t = result;
            return t;
        }
        catch (RuntimeException ex) {
            this.logAndRethrow(ex);
            throw ex;
        }
        catch (Error ex) {
            if (!this.logged) {
                this.log(ex);
                this.logged = true;
            }
            throw ex;
        }
        finally {
            this.operations.pop();
            if (this.operations.isEmpty()) {
                this.logged = false;
            }
        }
    }

    private void logAndRethrow(Throwable ex) {
        if (!this.logged) {
            String[] trace = this.log(ex);
            this.logged = true;
            throw new OperationException(ex, trace);
        }
    }

    private String[] log(Throwable ex) {
        this.logger.error(InternalUtils.toMessage(ex));
        this.logger.error("Operations trace:");
        Object[] snapshot = this.operations.getSnapshot();
        String[] trace = new String[snapshot.length];
        for (int i = 0; i < snapshot.length; ++i) {
            trace[i] = snapshot[i].toString();
            this.logger.error(String.format("[%2d] %s", i + 1, trace[i]));
        }
        return trace;
    }

    boolean isEmpty() {
        return this.operations.isEmpty();
    }
}

