/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal;

import java.lang.reflect.Method;
import java.util.Map;
import org.apache.tapestry5.ioc.Location;
import org.apache.tapestry5.ioc.ModuleBuilderSource;
import org.apache.tapestry5.ioc.ObjectCreator;
import org.apache.tapestry5.ioc.ObjectLocator;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.ServiceResources;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InjectionResources;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.PlasticProxyFactory;
import org.slf4j.Logger;

public class AbstractMethodInvokingInstrumenter {
    private final ModuleBuilderSource moduleSource;
    protected final Map<Class, Object> resourcesDefaults = CollectionFactory.newMap();
    private final ServiceResources resources;
    private final PlasticProxyFactory proxyFactory;
    protected final Method method;
    protected final Class serviceInterface;
    protected final String serviceId;
    private final Logger logger;

    public AbstractMethodInvokingInstrumenter(ModuleBuilderSource moduleSource, Method method, ServiceResources resources, PlasticProxyFactory proxyFactory) {
        this.moduleSource = moduleSource;
        this.method = method;
        this.resources = resources;
        this.proxyFactory = proxyFactory;
        this.serviceId = resources.getServiceId();
        this.resourcesDefaults.put(String.class, this.serviceId);
        this.resourcesDefaults.put(ObjectLocator.class, resources);
        this.resourcesDefaults.put(ServiceResources.class, resources);
        this.logger = resources.getLogger();
        this.resourcesDefaults.put(Logger.class, this.logger);
        this.serviceInterface = resources.getServiceInterface();
        this.resourcesDefaults.put(Class.class, this.serviceInterface);
        this.resourcesDefaults.put(OperationTracker.class, resources.getTracker());
    }

    public String toString() {
        Location location = this.proxyFactory.getMethodLocation(this.method);
        return location.toString();
    }

    private Object getModuleInstance() {
        return InternalUtils.isStatic(this.method) ? null : this.moduleSource.getModuleBuilder();
    }

    protected Object invoke(InjectionResources injectionResources) {
        String description = String.format("Invoking method %s", this.toString());
        ObjectCreator plan = InternalUtils.createMethodInvocationPlan(this.resources.getTracker(), this.resources, injectionResources, this.logger, description, this.getModuleInstance(), this.method);
        return plan.createObject();
    }
}

